/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.security.MessageDigest;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Password;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.UnixCrypt;

public abstract class Credential {
    static Log log = LogFactory.getLog(Credential.class);

    public abstract boolean check(Object var1);

    public static Credential getCredential(String string) {
        if (string.startsWith("CRYPT:")) {
            return new Crypt(string);
        }
        if (string.startsWith("MD5:")) {
            return new MD5(string);
        }
        return new Password(string);
    }

    public static class MD5
    extends Credential {
        public static final String __TYPE = "MD5:";
        private static MessageDigest __md;
        private byte[] _digest;

        MD5(String string) {
            string = string.startsWith(__TYPE) ? string.substring(__TYPE.length()) : string;
            this._digest = TypeUtil.parseBytes(string, 16);
        }

        public byte[] getDigest() {
            return this._digest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean check(Object object) {
            try {
                byte[] byArray = null;
                if (object instanceof Password || object instanceof String) {
                    String string = __TYPE;
                    synchronized (__TYPE) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(object.toString().getBytes(StringUtil.__ISO_8859_1));
                        byArray = __md.digest();
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        if (byArray == null || byArray.length != this._digest.length) {
                            return false;
                        }
                        for (int i = 0; i < byArray.length; ++i) {
                            if (byArray[i] == this._digest[i]) continue;
                            return false;
                        }
                        return true;
                    }
                }
                if (object instanceof MD5) {
                    MD5 mD5 = (MD5)object;
                    if (this._digest.length != mD5._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < this._digest.length; ++i) {
                        if (this._digest[i] == mD5._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (object instanceof Credential) {
                    return ((Credential)object).check(this);
                }
                log.warn((Object)("Can't check " + object.getClass() + " against MD5"));
                return false;
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String string) {
            try {
                String string2 = __TYPE;
                synchronized (__TYPE) {
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception exception) {
                            log.warn((Object)"EXCEPTION ", (Throwable)exception);
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(string.getBytes(StringUtil.__ISO_8859_1));
                    byte[] byArray = __md.digest();
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return __TYPE + TypeUtil.toString(byArray, 16);
                }
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                return null;
            }
        }
    }

    public static class Crypt
    extends Credential {
        public static final String __TYPE = "CRYPT:";
        private String _cooked;

        Crypt(String string) {
            this._cooked = string.startsWith(__TYPE) ? string.substring(__TYPE.length()) : string;
        }

        public boolean check(Object object) {
            if (!(object instanceof String) && !(object instanceof Password)) {
                log.warn((Object)("Can't check " + object.getClass() + " against CRYPT"));
            }
            String string = object.toString();
            return this._cooked.equals(UnixCrypt.crypt(string, this._cooked));
        }

        public static String crypt(String string, String string2) {
            return __TYPE + UnixCrypt.crypt(string2, string);
        }
    }
}

