/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Credential;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;
import org.mortbay.util.URLResource;

public class FileResource
extends URLResource {
    private static Log log = LogFactory.getLog(Credential.class);
    private static boolean __checkAliases = "true".equalsIgnoreCase(System.getProperty("org.mortbay.util.FileResource.checkAliases", "true"));
    private File _file;
    private transient URL _alias = null;
    private transient boolean _aliasChecked = false;

    public static void setCheckAliases(boolean bl) {
        __checkAliases = bl;
    }

    public static boolean getCheckAliases() {
        return __checkAliases;
    }

    FileResource(URL uRL) throws IOException, URISyntaxException {
        super(uRL, null);
        try {
            this._file = new File(new java.net.URI(uRL.toString()));
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
            try {
                String string = "file:" + URI.encodePath(uRL.toString().substring(5));
                this._file = new File(new java.net.URI(string));
            }
            catch (Exception exception2) {
                LogSupport.ignore(log, exception2);
                this.checkConnection();
                Permission permission = this._connection.getPermission();
                this._file = new File(permission == null ? uRL.getFile() : permission.getName());
            }
        }
        if (this._file.isDirectory() && !this._urlString.endsWith("/")) {
            this._urlString = this._urlString + "/";
        }
    }

    FileResource(URL uRL, URLConnection uRLConnection, File file) {
        super(uRL, uRLConnection);
        this._file = file;
        if (this._file.isDirectory() && !this._urlString.endsWith("/")) {
            this._urlString = this._urlString + "/";
        }
    }

    public Resource addPath(String string) throws IOException, MalformedURLException {
        String string2;
        FileResource fileResource = null;
        if (!this.isDirectory()) {
            fileResource = (FileResource)super.addPath(string);
        } else {
            string2 = string = URI.canonicalPath(string);
            if (string.startsWith("/")) {
                string2 = string.substring(1);
            }
            File file = new File(this._file, string2.replace('/', File.separatorChar));
            fileResource = new FileResource(file.toURI().toURL(), null, file);
        }
        string2 = URI.encodePath(string);
        int n = fileResource._urlString.length() - string2.length();
        int n2 = fileResource._urlString.lastIndexOf(string2, n);
        if (n != n2 && (n - 1 != n2 || string.endsWith("/") || !fileResource.isDirectory())) {
            fileResource._alias = fileResource._url;
            fileResource._aliasChecked = true;
        }
        return fileResource;
    }

    public URL getAlias() {
        if (__checkAliases && !this._aliasChecked) {
            try {
                String string = this._file.getAbsolutePath();
                String string2 = this._file.getCanonicalPath();
                if (string.length() != string2.length() || !string.equals(string2)) {
                    this._alias = new File(string2).toURI().toURL();
                }
                this._aliasChecked = true;
                if (this._alias != null && log.isDebugEnabled()) {
                    log.debug((Object)("ALIAS abs=" + string));
                    log.debug((Object)("ALIAS can=" + string2));
                }
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                return this.getURL();
            }
        }
        return this._alias;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public long length() {
        return this._file.length();
    }

    public String getName() {
        return this._file.getAbsolutePath();
    }

    public File getFile() {
        return this._file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    public boolean renameTo(Resource resource) throws SecurityException {
        if (resource instanceof FileResource) {
            return this._file.renameTo(((FileResource)resource)._file);
        }
        return false;
    }

    public String[] list() {
        String[] stringArray = this._file.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        while (n-- > 0) {
            if (!new File(this._file, stringArray[n]).isDirectory() || stringArray[n].endsWith("/")) continue;
            int n2 = n;
            stringArray[n2] = stringArray[n2] + "/";
        }
        return stringArray;
    }

    public String encode(String string) {
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !(object instanceof FileResource)) {
            return false;
        }
        FileResource fileResource = (FileResource)object;
        return fileResource._file == this._file || null != this._file && this._file.equals(fileResource._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    static {
        if (__checkAliases) {
            log.info((Object)"Checking Resource aliases");
        }
    }
}

