/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayPool;

public class LineInput
extends FilterInputStream {
    private static Log log = LogFactory.getLog(LineInput.class);
    private byte[] _buf;
    private ByteBuffer _byteBuffer;
    private InputStreamReader _reader;
    private int _mark = -1;
    private int _pos;
    private int _avail;
    private int _contents;
    private int _byteLimit = -1;
    private boolean _newByteLimit;
    private LineBuffer _lineBuffer;
    private String _encoding;
    private boolean _eof = false;
    private boolean _lastCr = false;
    private boolean _seenCrLf = false;
    private static final int LF = 10;
    private static final int CR = 13;

    public LineInput(InputStream inputStream) {
        this(inputStream, 0);
    }

    public LineInput(InputStream inputStream, int n) {
        super(inputStream);
        if (n == 0) {
            n = 8192;
        }
        this._buf = ByteArrayPool.getByteArray(n);
        this._byteBuffer = new ByteBuffer(this._buf);
        this._lineBuffer = new LineBuffer(n);
        try {
            this._reader = new InputStreamReader((InputStream)this._byteBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._reader = new InputStreamReader(this._byteBuffer);
        }
    }

    public LineInput(InputStream inputStream, int n, String string) throws UnsupportedEncodingException {
        super(inputStream);
        if (n == 0) {
            n = 2048;
        }
        this._buf = ByteArrayPool.getByteArray(n);
        this._byteBuffer = new ByteBuffer(this._buf);
        this._lineBuffer = new LineBuffer(n);
        this._reader = new InputStreamReader((InputStream)this._byteBuffer, string);
        this._encoding = string;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setByteLimit(int n) {
        this._byteLimit = n;
        if (n >= 0) {
            this._newByteLimit = true;
            this._byteLimit -= this._contents - this._pos;
            if (this._byteLimit < 0) {
                this._avail += this._byteLimit;
                this._byteLimit = 0;
            }
        } else {
            this._newByteLimit = false;
            this._avail = this._contents;
            this._eof = false;
        }
    }

    public int getByteLimit() {
        if (this._byteLimit < 0) {
            return this._byteLimit;
        }
        return this._byteLimit + this._avail - this._pos;
    }

    public synchronized String readLine() throws IOException {
        int n = this.fillLine(this._buf.length);
        if (n < 0) {
            return null;
        }
        String string = null;
        if (this._encoding == null) {
            string = new String(this._buf, this._mark, n);
        } else {
            try {
                string = new String(this._buf, this._mark, n, this._encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.warn((Object)"EXCEPTION ", (Throwable)unsupportedEncodingException);
            }
        }
        this._mark = -1;
        return string;
    }

    public int readLine(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = this.fillLine(n2);
        if (n5 < 0) {
            return -1;
        }
        if (n5 == 0) {
            return 0;
        }
        this._byteBuffer.setStream(this._mark, n5);
        for (n3 = 0; n3 < n2 && this._reader.ready() && (n4 = this._reader.read(cArray, n + n3, n2 - n3)) > 0; n3 += n4) {
        }
        this._mark = -1;
        return n3;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        if ((n2 = this.fillLine(n2)) < 0) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        System.arraycopy(this._buf, this._mark, byArray, n, n2);
        this._mark = -1;
        return n2;
    }

    public LineBuffer readLineBuffer() throws IOException {
        return this.readLineBuffer(this._buf.length);
    }

    public LineBuffer readLineBuffer(int n) throws IOException {
        int n2;
        int n3;
        if ((n = this.fillLine(n > 0 ? n : this._buf.length)) < 0) {
            return null;
        }
        if (n == 0) {
            this._lineBuffer.size = 0;
            return this._lineBuffer;
        }
        this._byteBuffer.setStream(this._mark, n);
        this._lineBuffer.size = 0;
        for (n2 = 0; n2 < n && this._reader.ready() && (n3 = this._reader.read(this._lineBuffer.buffer, n2, n - n2)) > 0; n2 += n3) {
        }
        this._lineBuffer.size = n2;
        this._mark = -1;
        return this._lineBuffer;
    }

    public synchronized int read() throws IOException {
        if (this._pos >= this._avail) {
            this.fill();
        }
        int n = this._pos >= this._avail ? -1 : this._buf[this._pos++] & 0xFF;
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this._avail - this._pos;
        if (n3 <= 0) {
            this.fill();
            n3 = this._avail - this._pos;
        }
        if (n3 <= 0) {
            n2 = -1;
        } else {
            n2 = n3 < n2 ? n3 : n2;
            System.arraycopy(this._buf, this._pos, byArray, n, n2);
            this._pos += n2;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        int n = this._avail - this._pos;
        if (n <= 0) {
            this.fill();
            n = this._avail - this._pos;
        }
        if (n <= 0) {
            l = 0L;
        } else {
            l = (long)n < l ? (long)n : l;
            this._pos = (int)((long)this._pos + l);
        }
        return l;
    }

    public synchronized int available() throws IOException {
        int n = this.in.available();
        if (this._byteLimit >= 0 && n > this._byteLimit) {
            n = this._byteLimit;
        }
        return this._avail - this._pos + n;
    }

    public synchronized void mark(int n) throws IllegalArgumentException {
        if (n > this._buf.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this._buf, this._pos, byArray, this._pos, this._avail - this._pos);
            this._buf = byArray;
            if (this._byteBuffer != null) {
                this._byteBuffer.setBuffer(this._buf);
            }
        }
        this._mark = this._pos;
    }

    public synchronized void reset() throws IOException {
        if (this._mark < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this._pos = this._mark;
        this._mark = -1;
    }

    public boolean markSupported() {
        return true;
    }

    private void fill() throws IOException {
        int n;
        if (this._mark > 0) {
            n = this._contents - this._mark;
            System.arraycopy(this._buf, this._mark, this._buf, 0, n);
            this._pos -= this._mark;
            this._avail -= this._mark;
            this._contents = n;
            this._mark = 0;
        } else if (this._mark < 0 && this._pos > 0) {
            n = this._contents - this._pos;
            System.arraycopy(this._buf, this._pos, this._buf, 0, n);
            this._avail -= this._pos;
            this._contents = n;
            this._pos = 0;
        } else if (this._mark == 0 && this._pos > 0 && this._contents == this._buf.length) {
            this._mark = -1;
            this.fill();
            return;
        }
        n = 0;
        this._eof = false;
        if (this._byteLimit == 0) {
            this._eof = true;
        } else {
            while (!this._eof && n == 0 && this._buf.length > this._contents) {
                int n2 = this._buf.length - this._contents;
                n = this.in.read(this._buf, this._contents, n2);
                if (n <= 0) {
                    if (n == 0) {
                        Thread.yield();
                        int n3 = this.in.read();
                        if (n3 >= 0) {
                            n = 1;
                            this._buf[this._contents++] = (byte)n3;
                        } else {
                            this._eof = true;
                        }
                    } else {
                        this._eof = true;
                    }
                } else {
                    this._contents += n;
                }
                this._avail = this._contents;
                if (this._byteLimit <= 0) continue;
                if (this._contents - this._pos >= this._byteLimit) {
                    this._avail = this._byteLimit + this._pos;
                }
                if (n > this._byteLimit) {
                    this._byteLimit = 0;
                    continue;
                }
                if (n >= 0) {
                    this._byteLimit -= n;
                    continue;
                }
                if (n != -1) continue;
                throw new IOException("Premature EOF");
            }
        }
        if (this._avail - this._pos > 0 && this._lastCr && this._buf[this._pos] == 10) {
            this._seenCrLf = true;
            ++this._pos;
            if (this._mark >= 0) {
                ++this._mark;
            }
            this._lastCr = false;
            if (this._byteLimit >= 0 && this._newByteLimit) {
                if (this._avail < this._contents) {
                    ++this._avail;
                } else {
                    ++this._byteLimit;
                }
            }
            if (this._pos == this._avail) {
                this.fill();
            }
        }
        this._newByteLimit = false;
    }

    private int fillLine(int n) throws IOException {
        this._mark = this._pos;
        if (this._pos >= this._avail) {
            this.fill();
        }
        if (this._pos >= this._avail) {
            return -1;
        }
        boolean bl = this._lastCr;
        boolean bl2 = false;
        this._lastCr = false;
        int n2 = 0;
        block4: while (this._pos <= this._avail) {
            while (this._pos == this._avail) {
                if (this._eof || this._mark == 0 && this._contents == this._buf.length) {
                    this._lastCr = !this._eof && this._buf[this._avail - 1] == 13;
                    bl = true;
                    bl2 = true;
                    break block4;
                }
                if (bl && this.in.available() == 0 && !this._seenCrLf) {
                    this._lastCr = true;
                    bl = true;
                    bl2 = true;
                    break block4;
                }
                this._pos = this._mark;
                this.fill();
                this._pos = n2;
                bl = false;
            }
            byte by = this._buf[this._pos++];
            switch (by) {
                case 10: {
                    if (bl) {
                        this._seenCrLf = true;
                    }
                    bl2 = true;
                    break block4;
                }
                case 13: {
                    if (bl && this._pos > 1) {
                        --this._pos;
                        break block4;
                    }
                    bl = true;
                    continue block4;
                }
                default: {
                    if (bl) {
                        if (this._pos == 1) {
                            bl = false;
                        } else {
                            --this._pos;
                            break block4;
                        }
                    }
                    if (++n2 != n) continue block4;
                    if (this._mark != 0 && this._pos + 2 >= this._avail && this._avail < this._buf.length) {
                        this.fill();
                    }
                    if (this._pos < this._avail && this._buf[this._pos] == 13) {
                        bl = true;
                        ++this._pos;
                    }
                    if (this._pos < this._avail && this._buf[this._pos] == 10) {
                        bl2 = true;
                        ++this._pos;
                    }
                    if (bl || bl2) break block4;
                    bl2 = true;
                    bl = true;
                    break block4;
                }
            }
        }
        if (!bl && !bl2 && n2 == 0) {
            n2 = -1;
        }
        return n2;
    }

    public void destroy() {
        ByteArrayPool.returnByteArray(this._buf);
        this._byteBuffer = null;
        this._reader = null;
        this._lineBuffer = null;
        this._encoding = null;
    }

    public static class LineBuffer {
        public char[] buffer;
        public int size;

        public LineBuffer(int n) {
            this.buffer = new char[n];
        }

        public String toString() {
            return new String(this.buffer, 0, this.size);
        }
    }

    private static class ByteBuffer
    extends ByteArrayInputStream {
        ByteBuffer(byte[] byArray) {
            super(byArray);
        }

        void setBuffer(byte[] byArray) {
            this.buf = byArray;
        }

        void setStream(int n, int n2) {
            this.pos = n;
            this.count = n + n2;
            this.mark = -1;
        }
    }
}

