/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;

public class Pool
implements LifeCycle,
Serializable {
    private static Log log = LogFactory.getLog(Pool.class);
    static int __max = Integer.getInteger("POOL_MAX", 256);
    static int __min = Integer.getInteger("POOL_MIN", 2);
    static HashMap __nameMap = new HashMap();
    private int _max = __max;
    private int _min = __min;
    private String _name;
    private String _className;
    private int _maxIdleTimeMs = 10000;
    private HashMap _attributes = new HashMap();
    private transient Class _class;
    private transient PondLife[] _pondLife;
    private transient int[] _index;
    private transient int _size;
    private transient int _available;
    private transient int _running = 0;
    private transient long _lastShrink = 0L;

    public static Pool getPool(String string) {
        return (Pool)__nameMap.get(string);
    }

    public String getPoolName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolName(String string) throws IllegalStateException {
        Pool pool = this;
        synchronized (pool) {
            Class clazz = Pool.class;
            synchronized (clazz) {
                if (this._name != null && !this._name.equals(string)) {
                    __nameMap.remove(this._name);
                }
                if (__nameMap.containsKey(string)) {
                    throw new IllegalStateException("Name already exists");
                }
                this._name = string;
                __nameMap.put(this._name, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolClass(Class clazz) throws IllegalStateException {
        Pool pool = this;
        synchronized (pool) {
            if (this._class != clazz) {
                if (this._running > 0) {
                    throw new IllegalStateException("Thread Pool Running");
                }
                if (!PondLife.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Not PondLife: " + clazz);
                }
                this._class = clazz;
                this._className = this._class.getName();
            }
        }
    }

    public Class getPoolClass() {
        return this._class;
    }

    public int getMinSize() {
        return this._min;
    }

    public void setMinSize(int n) {
        this._min = n;
    }

    public int getMaxSize() {
        return this._max;
    }

    public void setMaxSize(int n) {
        this._max = n;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public void setMaxIdleTimeMs(int n) {
        this._maxIdleTimeMs = n;
    }

    public void setAttribute(String string, Object object) {
        this._attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this._attributes.get(string);
    }

    public boolean isStarted() {
        return this._running > 0 && this._pondLife != null;
    }

    public int size() {
        return this._size;
    }

    public int available() {
        return this._available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Pool pool = this;
        synchronized (pool) {
            int n;
            ++this._running;
            if (this._running > 1) {
                return;
            }
            if (this._min >= this._max || this._max < 1) {
                throw new IllegalStateException("!(0<=min<max)");
            }
            this._pondLife = new PondLife[this._max];
            this._index = new int[this._max];
            this._size = 0;
            this._available = 0;
            for (n = 0; n < this._max; ++n) {
                this._index[n] = n;
            }
            for (n = 0; n < this._min; ++n) {
                this.newPondLife();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Pool pool = this;
        synchronized (pool) {
            --this._running;
            if (this._running > 0) {
                return;
            }
            this.notifyAll();
        }
        if (this._pondLife != null && this._size > 0) {
            int n;
            for (n = 0; n < this._pondLife.length; ++n) {
                this.closePondLife(n);
            }
            Thread.yield();
            for (n = 0; n < this._pondLife.length; ++n) {
                this.stopPondLife(n);
            }
        }
        Pool pool2 = this;
        synchronized (pool2) {
            this._pondLife = null;
            this._index = null;
            this._size = 0;
            this._available = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PondLife get(int n) throws Exception {
        PondLife pondLife = null;
        if (this._available < this._min) {
            Thread.yield();
        }
        int n2 = -1;
        Pool pool = this;
        synchronized (pool) {
            if (this._running > 0 && this._available == 0 && this._size == this._pondLife.length && n > 0) {
                this.wait(n);
            }
            if (this._running > 0) {
                if (this._available > 0) {
                    int n3 = this._index[--this._available];
                    pondLife = this._pondLife[n3];
                } else if (this._size < this._pondLife.length) {
                    n2 = this.reservePondLife(false);
                }
            }
            if (pondLife == null && n2 >= 0) {
                pondLife = this.newPondLife(n2);
            }
        }
        return pondLife;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PondLife pondLife) throws InterruptedException {
        int n = pondLife.getID();
        Pool pool = this;
        synchronized (pool) {
            if (this._running == 0) {
                this.stopPondLife(n);
            } else if (this._pondLife[n] != null) {
                this._index[this._available++] = n;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink() throws InterruptedException {
        if (this._running == 0) {
            return;
        }
        Pool pool = this;
        synchronized (pool) {
            if (this._maxIdleTimeMs > 0) {
                long l = System.currentTimeMillis();
                if (l - this._lastShrink < (long)this._maxIdleTimeMs) {
                    return;
                }
                this._lastShrink = l;
            }
            if (this._running > 0 && this._available > 0 && this._size > this._min) {
                this.stopPondLife(this._index[--this._available]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reservePondLife(boolean bl) throws Exception {
        int n = -1;
        Pool pool = this;
        synchronized (pool) {
            n = this._index[this._size++];
            if (bl) {
                this._index[this._available++] = n;
            }
        }
        return n;
    }

    private PondLife newPondLife(int n) throws Exception {
        PondLife pondLife;
        this._pondLife[n] = pondLife = (PondLife)this._class.newInstance();
        pondLife.enterPool(this, n);
        return pondLife;
    }

    private PondLife newPondLife() throws Exception {
        return this.newPondLife(this.reservePondLife(true));
    }

    private void closePondLife(int n) {
        if (this._pondLife[n] != null) {
            this._pondLife[n].poolClosing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPondLife(int n) {
        PondLife pondLife = null;
        Pool pool = this;
        synchronized (pool) {
            pondLife = this._pondLife[n];
            if (pondLife != null) {
                this._pondLife[n] = null;
                this._index[--this._size] = n;
                if (this._available > this._size) {
                    this._available = this._size;
                }
            }
        }
        if (pondLife != null) {
            pondLife.leavePool();
        }
    }

    public void dump(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer.append("pond: ");
        stringBuffer2.append("avail:");
        stringBuffer3.append("index:");
        for (int i = 0; i < this._pondLife.length; ++i) {
            if (this._pondLife[i] == null) {
                stringBuffer.append("   ");
            } else {
                stringBuffer.append(' ');
                StringUtil.append(stringBuffer, (byte)i, 16);
            }
            if (i == this._size) {
                stringBuffer2.append(i == this._available ? " AS" : "  S");
            } else {
                stringBuffer2.append(i == this._available ? " A " : "   ");
            }
            stringBuffer3.append(' ');
            StringUtil.append(stringBuffer3, (byte)this._index[i], 16);
        }
        System.err.println();
        System.err.println(string);
        System.err.println(stringBuffer);
        System.err.println(stringBuffer2);
        System.err.println(stringBuffer3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this._class == null || !this._class.getName().equals(this._className)) {
            try {
                this.setPoolClass(Loader.loadClass(Pool.class, this._className));
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                throw new InvalidObjectException(exception.toString());
            }
        }
    }

    public static interface PondLife {
        public int getID();

        public void enterPool(Pool var1, int var2);

        public void poolClosing();

        public void leavePool();
    }
}

