/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.BadResource;
import org.mortbay.util.CachedResource;
import org.mortbay.util.FileResource;
import org.mortbay.util.IO;
import org.mortbay.util.JarFileResource;
import org.mortbay.util.JarResource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;
import org.mortbay.util.URLResource;

public abstract class Resource
implements Serializable {
    private static Log log = LogFactory.getLog(Resource.class);
    Object _associate;

    public static Resource newResource(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(uRL);
                return fileResource;
            }
            catch (Exception exception) {
                log.debug((Object)"EXCEPTION ", (Throwable)exception);
                return new BadResource(uRL, exception.toString());
            }
        }
        if (string.startsWith("jar:file:")) {
            return new JarFileResource(uRL);
        }
        if (string.startsWith("jar:")) {
            return new JarResource(uRL);
        }
        return new URLResource(uRL, null);
    }

    public static Resource newResource(String string) throws MalformedURLException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!(string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("jar:"))) {
                try {
                    if (string.startsWith("./")) {
                        string = string.substring(2);
                    }
                    File file = new File(string).getCanonicalFile();
                    uRL = file.toURI().toURL();
                    URLConnection uRLConnection = uRL.openConnection();
                    FileResource fileResource = new FileResource(uRL, uRLConnection, file);
                    return fileResource;
                }
                catch (Exception exception) {
                    log.debug((Object)"EXCEPTION ", (Throwable)exception);
                    throw malformedURLException;
                }
            }
            log.warn((Object)("Bad Resource: " + string));
            throw malformedURLException;
        }
        String string2 = uRL.toString();
        if (!(string2.length() <= 0 || string2.charAt(string2.length() - 1) == string.charAt(string.length() - 1) || string2.charAt(string2.length() - 1) == '/' && string2.charAt(string2.length() - 2) == string.charAt(string.length() - 1) || string.charAt(string.length() - 1) == '/' && string.charAt(string.length() - 2) == string2.charAt(string2.length() - 1))) {
            return new BadResource(uRL, "Trailing special characters stripped by URL in " + string);
        }
        return Resource.newResource(uRL);
    }

    public static Resource newSystemResource(String string) throws IOException {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (uRL = classLoader.getResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null && (classLoader = Resource.class.getClassLoader()) != null && (uRL = classLoader.getResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null && (uRL = ClassLoader.getSystemResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL);
    }

    protected void finalize() {
        this.release();
    }

    public abstract void release();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    public abstract URL getURL();

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException, SecurityException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    public String encode(String string) {
        return URI.encodePath(string);
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object object) {
        this._associate = object;
    }

    public URL getAlias() {
        return null;
    }

    public CachedResource cache() throws IOException {
        return new CachedResource(this);
    }

    public String getListHTML(String string, boolean bl) throws IOException {
        if (!this.isDirectory()) {
            return null;
        }
        Object[] objectArray = this.list();
        if (objectArray == null) {
            return null;
        }
        Arrays.sort(objectArray);
        String string2 = "Directory: " + URI.decodePath(string);
        string2 = StringUtil.replace(StringUtil.replace(string2, "<", "&lt;"), ">", "&gt;");
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("<HTML><HEAD><TITLE>");
        stringBuffer.append(string2);
        stringBuffer.append("</TITLE></HEAD><BODY>\n<H1>");
        stringBuffer.append(string2);
        stringBuffer.append("</H1><TABLE BORDER=0>");
        if (bl) {
            stringBuffer.append("<TR><TD><A HREF=");
            stringBuffer.append(URI.encodePath(URI.addPaths(string, "../")));
            stringBuffer.append(">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        for (int i = 0; i < objectArray.length; ++i) {
            String string3 = URI.encodePath((String)objectArray[i]);
            Resource resource = this.addPath(string3);
            stringBuffer.append("<TR><TD><A HREF=\"");
            String string4 = URI.addPaths(string, string3);
            if (resource.isDirectory() && !string4.endsWith("/")) {
                string4 = URI.addPaths(string4, "/");
            }
            stringBuffer.append(string4);
            stringBuffer.append("\">");
            stringBuffer.append(StringUtil.replace(StringUtil.replace((String)objectArray[i], "<", "&lt;"), ">", "&gt;"));
            stringBuffer.append("&nbsp;");
            stringBuffer.append("</TD><TD ALIGN=right>");
            stringBuffer.append(resource.length());
            stringBuffer.append(" bytes&nbsp;</TD><TD>");
            stringBuffer.append(dateFormat.format(new Date(resource.lastModified())));
            stringBuffer.append("</TD></TR>\n");
        }
        stringBuffer.append("</TABLE>\n");
        stringBuffer.append("</BODY></HTML>\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream, long l, long l2) throws IOException {
        InputStream inputStream = this.getInputStream();
        try {
            inputStream.skip(l);
            if (l2 < 0L) {
                IO.copy(inputStream, outputStream);
            } else {
                IO.copy(inputStream, outputStream, (long)((int)l2));
            }
        }
        finally {
            inputStream.close();
        }
    }
}

