<%
dim quantityproducts    ' new facility for cloning
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'  This routine gets the features from the form 
'  and stores them in the feature array
' VP-ASP 6.00  June 29, 2005
' Oct 13, 2003 fix checkbox as radio button
' March 7, 2004 Multiplier
' Add QtyProduct  Sept 11, 2004
'  Sept 17 fix line totalnewquantity  325
' April 27, 2005 add translate
'*****************************************************************************
Sub GetProductFeatures (prodi)
'*************************************************************
' called by shopaddtocart and shopproductselect
' Gets product options from form fields and stores them in
' Productoptions array
'*************************************************************
dim sOption, sMultiOption, sMultivalue, soptionvalue,i
dim susertext, susertextvalue
dim featurename, featurevaluename
dim dmaxfeatures, msg
featurecount=0
userselectedstring=""
UserSelectedCount=0
if strfeatures="" then exit sub
if isnull(strfeatures) then exit sub
dmaxfeatures=getconfig("xmaxfeatures")
shopopendatabaseP featureconn
fprefix=""
If prodi<>"" then
   fprefix="x"
end if
sxRequiredList=fprefix & prodi & "Required" 
sXRequiredvalue=request(sXRequiredList)
featurecount=0
featureerror=""
'**************************************************************************
' For each possible feature see if there is anything to process
'*************************************************************************
for i =1 to dMaxFeatures
   sOption= fprefix &  prodi & "Feature" & i
   sOptionNumber=i
   featureid=Request(Soption)
   
   'VP-ASP 6.09 - precautionary security fix
   if featureid > "" then
	   if not isnumeric(featureid) then
		   shopclosedatabase featureconn
		   shoperror "Feature ID must be numeric"
		end if
	end if
   
   'debugwrite "soption=" & soption & "featureid=" & featureid
   featurevaluename= fprefix & prodi & "Featurevalue" & i
   featurevalue=request(featurevaluename)
  ' Debugwrite "featureid=" & featureid & " featurevalue=" & featurevalue
   If featureid<>"" then 
       if isnumeric(featureid) then 
         ProcessGetFeatureRecord featureconn, featureid
         ProcessFeaturevalues 
       end if  
   end if
   If Susertextvalue<>"" then
     HandleCompatbilityUserText sUserText,sUserTextValue
   end if  
next
memUserText=request("UserText" & prodi)
StrAllowUserText=request("UserCaption" & Prodi)
SetSess "MaxFeatures",featurecount       ' maximum features in array
If featureerror<>"" then 
   shopclosedatabase featureconn
   shopError featureError
end if       
VerifyRequired msg
shopclosedatabase featureconn
if msg<>"" then
       shopError msg
end if    
if getconfig("xFeaturesRequired")="Yes" then
      VerifyFeaturesSelected 
end if
End Sub

'**************************************************************************
'Reread the prod features tabler for this feature
'**************************************************************************
Sub ProcessGetFeatureRecord (featureconn, featureid)
dim featuresql, rs
Featuresql = "select * from prodfeatures where id =" & featureid
set rs=featureconn.execute(featuresql)
if not rs.eof then
       GetOptionvalues rs, featureconn
end if
rs.close
set rs=nothing
end sub

'*************************************************************************************
' A feature was obtained from the form
'************************************************************************************ 
Sub ProcessFeaturevalues 
dim featuretype
featuretype=ucase(StrFeatureType)
if featuretype="" then
     If strFeatureOther<>"" then
         featuretype="SELECTLIST"      ' compatibility
      else   
        featuretype="DROPDOWN"
      end if  
end if
FeatureMultiSelection=ucase(strFeatureMulti)
Select case featureType
   Case "DROPDOWN"
         ProcessDropDownList
   case "CHECKBOX"
         ProcessCheckbox
   case "RADIO"
         ProcessRadioButton      
   Case "SELECTLIST"
         ProcessSelectList
   Case "USERTEXT","TEXTAREA"
         ProcessUserText
  Case "USERPRICE"
         ProcessUserPrice              ' generates same as user text       
  Case "MULTIPLIER"
       ProcessMultiplier              ' generates same as user text
  Case "QUANTITY"
         ProcessFeatureQuantity
  Case "QTYPRODUCT"
         ProcessFeatureQuantityProduct       
   Case else
          ProcessDropDownList
end select
end sub

'************************************************************************
' Drop down list can have a value or it can 
'************************************************************************
Sub ProcessDropDownList
dim i
If FeatureMultiSelection<>"YES" then
  ProcessFeatureAddToArray
  Featurecount=featurecount+1
  exit sub
end if
parserecord featurevalue, featurevalueids, featurevaluecount,","
for i = 0 to featurevaluecount-1
   If isnumeric(featurevalueids(i)) then 
     ProcessGetFeatureRecord featureconn, featurevalueids(i)
     ProcessFeatureAddToArray
     Featurecount=featurecount+1
   end if  
next  
  
end sub

'************************************************************************
' check box can have multiple values

'************************************************************************
Sub ProcessCheckBox
dim i
If FeatureMultiSelection<>"YES" then
   ProcessRadioButton
   exit sub
end if   
If featurevalue="" then exit sub
parserecord featurevalue, featurevalueids, featurevaluecount,","
for i = 0 to featurevaluecount-1
   ProcessGetFeatureRecord featureconn, featurevalueids(i)
   ProcessFeatureAddToArray
   Featurecount=featurecount+1
next  
end sub

'************************************************************************
' Drop Radio Button 
'************************************************************************
Sub ProcessRadioButton
ProcessFeatureAddToArray
Featurecount=featurecount+1
end sub

'************************************************************************
' Process SelectList
' could be in form xxx or xxx [55.55]
'************************************************************************
' Value came from select list
Sub ProcessSelectList
dim name, price
parseoption featurevalue, name, price
If name<> getlang("Langcommonselect") then 
  ProcessFeatureAddToArray
  Featurearray(cfeaturevalue,featurecount)=name
  Featurearray(cfeatureprice,featurecount)=price
  Featurecount=featurecount+1
end if  
end sub

'************************************************************************
' Process SelectList
' could be in form xxx or xxx [55.55]
'************************************************************************
' Value came from select list
Sub ProcessUserText
if featurevalue="" then exit sub
ProcessFeatureAddToArray
Featurearray(cfeaturevalue,featurecount)=featurevalue
Featurecount=featurecount+1
end sub

'************************************************************************
' Process User Price
' could be in form xxx or xxx [55.55]
'************************************************************************
' Value came from select list
Sub ProcessUserPrice
dim price
price=featurevalue
'VP-ASP 6.08 - error was being thrown if nothing was entered, even if feature not required
if price > "" then
If not isnumeric(price) then
   featureerror=featureError &  getlang("LangUserPriceError") & " " & strfeaturecaption & ".<br>"  & getlang("LangProductname") & " " &  strcname & "<br>"
   exit sub
end if       
ProcessFeatureAddToArray
Featurearray(cfeatureprice,featurecount)=featurevalue
Featurecount=featurecount+1
end if
end sub


'********************************************************************
' a multiplier multiplies the current price by the number selected
'*********************************************************************
sub ProcessMultiplier
  dim multvalue, tempname, newprice, checkname,priceeach
  checkname=fprefix & Prodi & "FeatureQuantity" & sOptionNumber & "_" & featureid
  multvalue=request(checkname)
  If not isnumeric(multvalue) then
      shoperror  getlang("LangUserPriceError") & " " & strcname
  end if
  ProcessGetFeatureRecord featureconn, featureid
  price=shopformatcurrency(curfeatureprice,getconfig("xdecimalpoint"))
  multvalue=csng(multvalue)
  newprice=multvalue*curfeatureprice
  ProcessFeatureAddToArray
  tempname=strfeaturecaption & " (" & multvalue & " @ " & price & ")"
  Featurearray(cfeaturevalue,featurecount)=tempname
  Featurearray(cfeatureprice,featurecount)=newprice
  Featurecount=featurecount+1
end sub  
'***************************************************************************
' adds the feature to an internal array of features selected
'**************************************************************************
Sub ProcessFeatureAddToArray
Featurearray(cfeaturecaption,featurecount)=strfeaturecaption
Featurearray(cfeatureprice,featurecount)=curfeatureprice
Featurearray(cfeatureid,featurecount)=lngfeatureid
Featurearray(cfeaturevalue,featurecount)=strfeaturename
Featurearray(cfeatureother,featurecount)=strfeatureother  ' for sku
Featurearray(cfeaturenum,featurecount)=lngfeaturenum
Featurearray(cfeatureweight,featurecount)=strfeatureweight
Featurearray(cfeaturepercent,featurecount)=strfeaturepercent
AddToSelectedFeatures lngfeatureid
end sub

'*******************************************************************
' Verify if all features for this product have an entry in the feature array
'*************************************************************************
Sub VerifyFeaturesSelected
dim j
on error goto 0
Dim farray, found, featurenum
Dim FeatureNotSelected
Dim MaxFeatures
if strFeatures="" then         ' this product has no features
    exit sub
end if
Farray = Split(strFeatures, ",")     ' get feature numbers
maxfeatures=ubound(farray)+1
If featurecount>= featurecount then 
  For i = 0 to maxfeatures-1 
   featurenum=clng(farray(i)) 
   found=false
   for j=0 to featurecount-1
'       debugwrite "comparing " & featurenum & " with " & featurearray(cfeaturenum,j)
      If featurenum=clng(featurearray(cfeaturenum,j)) then
         found=true
         exit for
      end if
   next
   If found=false then 
      exit for
   end if   
next
else
   found=false
end if    
If found=false then       
  shoperror  getlang("LangFeatureMissing") & strcname
end if             
end sub
'
'**************************************************************************
' The feature values have a list of ids 
'we generate a form field based on this is and see if there is anything in them
'******************************************************************************
sub ProcessFeatureQuantity
dim quanarray, quanlimit, checkname, quantity, featureid
dim totalnewprice, newprice, tempname, totalnewquantity
QuanArray=split(featurevalue,",",-1,1)
Quanlimit=ubound(Quanarray)
totalnewprice=0
totalnewquantity=0
for i=0 to quanlimit
   featureid=quanarray(i)
   checkname=fprefix & Prodi & "FeatureQuantity" & sOptionNumber & "_" & featureid
   quantity=request(checkname)
  ' debugwrite "checkname="  & checkname & " qunatity=" & quantity & " limit=" & quanlimit
   Validatefeaturequantity quantity, rc
   if rc=0 then
      ProcessGetFeatureRecord featureconn, featureid
      ProcessFeatureAddToArray
      newprice=curfeatureprice
      newprice=csng(quantity)*newprice
      tempname=strfeaturename & "(" & quantity & ")</b>"
      Featurearray(cfeaturevalue,featurecount)=tempname
      Featurearray(cfeatureprice,featurecount)=newprice
      totalnewprice=totalnewprice + (curcprice*quantity)
      totalnewprice=totalnewprice + newprice
	  
	  'VP-ASP 6.09 - this line caused the cart to add 3 products instead of just one if multiple feautres were chosen
      'totalnewquantity=totalnewquantity+quantity
	  
      Featurecount=featurecount+1
   end if      
next
'if totalnewprice>0 then 
if totalnewquantity>0 then 
  setsess "newproductprice",totalnewprice
  setsess "newproductquantity",totalnewquantity
end if  
end sub
Sub Validatefeaturequantity (quantity, rc)
dim tquantity
rc=4
If not isnumeric(quantity) then
   quantity=1
   rc=0
   exit sub
end if   
tquantity=clng(quantity)
if tquantity= 0 then exit sub
rc=0
end sub
'*******************************************************************
' create a string of featureids that is added to the internal shopping cart
' and eventually stored with the product in the oitems table
'**************************************************************************
Sub AddToSelectedFeatures (featureid)
UserSelectedCount=UserSelectedCount+1
If UserSelectedstring<>"" then
  Userselectedstring=userselectedstring & ","
end if
userselectedstring=UserselectedString & cstr(featureid)
end sub


'**************************************************************************
' The feature values have a list of ids 
'we generate a form field based on this is and see if there is anything in them
'******************************************************************************
sub ProcessFeatureQuantityProduct
dim quanarray, quanlimit, checkname, quantity, featureid
dim totalnewprice, newprice, tempname, totalnewquantity
dim tempmsg
QuanArray=split(featurevalue,",",-1,1)
Quanlimit=ubound(Quanarray)
totalnewprice=0
totalnewquantity=0
quantityproducts=""
for i=0 to quanlimit
   featureid=quanarray(i)
   checkname=fprefix & Prodi & "FeatureQuantity" & sOptionNumber & "_" & featureid
   quantity=request(checkname)
   'debugwrite "checkname="  & checkname & " qunatity=" & quantity & " limit=" & quanlimit
   Validatefeaturequantity quantity, rc
   if rc=0 then
      If quantityproducts<>"" then
         quantityproducts=quantityproducts & ";"
      end if
      quantityproducts=quantityproducts & featureid & "," & quantity
    end if      
next
if quantityproducts<>"" then
  setsess "quantityproducts",quantityproducts
else
   tempmsg=  getlang("LangFeatureMissing")  & strcname & " - " & strfeaturecaption & "<br>" 
   shoperror tempmsg
end if   
end sub
Sub Validatefeaturequantity (quantity, rc)
dim tquantity
rc=4
If not isnumeric(quantity) then
   quantity=1
   rc=0
   exit sub
end if   
tquantity=clng(quantity)
if tquantity= 0 then exit sub
rc=0
end sub

%>
