<%
'****************************************************************
' see if product has any inventory related products
' VP-ASP 6.00
' April 26, 2005 add translate
'  Support multiple different formatting types
' table, radio, dropdownlist
' July 28, 2005 fix productid on radio button
' August 9, 2009 add inventory out of stock
'***************************************************************
Sub FormatInventoryproducts (conn, objrs)
dim inventorytype, hassubproduct, catalogid, spdisplatype
dim lncstock, spdisplaytype
dim strCrossProductIDs,strsql, rs, strmessage, strcdescurl,strurl
If getconfig("XInventoryproducts")<>"Yes" then exit sub
strcrossproductids=objrs("inventoryproducts")
hassubproduct=objrs("hassubproduct")
catalogid=objrs("catalogid")
spdisplaytype=objrs("spdisplaytype")
if isnull(spdisplaytype) then
   spdisplaytype="table"
end if   
if isnull(strcrossproductids) and isnull(hassubproduct) then exit sub
strsql="select * from products where ("
If strcrossproductids<>"" Then 
   strsql=strsql & " catalogid in (" & strcrossproductids & ")" 
   strsql=strsql & " or "
end if   
strsql =strsql & "highercatalogid=" & catalogid & ")"
if getconfig("xstocklow")<>"" then
    lngcstock= clng(getconfig("xstocklow")) 
    strsql = strsql & " and cstock> " & lngcstock
end if 

'VP-ASP 6.09 - only show products that aren't hidden
strsql = strsql & " and hide = 0 "

if getconfig("xsortproducts") > "" then
	strsql = strsql & " ORDER BY " & getconfig("xsortproducts")
end if
set rs=conn.execute(strsql)
If rs.eof then
  closerecordset rs
  exit sub
end if  
Select case lcase(spdisplaytype)
   case "table"
        FormatInventorytable conn, rs, objrs
   case "radio"
        FormatInventoryRadio  conn, rs, objrs
   case "checkbox"
        FormatInventoryCheckbox  conn, rs, objrs
   case "quantity"
        FormatInventoryQuantity  conn, rs, objrs
   case "dropdown"
        FormatinventoryDropdown conn, rs, objrs
   case else
        Formatinventorytable  conn, rs, objrs
end select 
closerecordset rs
end sub

'************************************************************************
' format inventory as a table'
' rs is the subproducts
' objrs is main product
'***********************************************************************
sub FormatInventorytable (conn, rs, objrs)
dim headerok
'FormatInventoryHeader
headerok=true
While Not rs.EOF
	response.write "<p align='right'><table width='75%'>"
   ProductFormatInventoryrow rs
   response.write "</table></P>"
   RS.MoveNext
WEND
if headerok=true then
'   Response.write tabledefend
end if   	
end sub
'
'*******************************************************************
' Start Inventory list table
'****************************************************************
Sub FormatInventoryHeader
Response.write reporttabledef
response.write reportheadrow
response.write ReportHeadColumn
Response.write getlang("LangInventory")
Response.write ReportHeadColumnEnd
response.write reportrowend 
Response.write tabledefend
Response.write reporttabledef
end sub

'**********************************************************************
' format one row of inventory
' image, description and buy button
'**************************************************************************
Sub ProductFormatInventoryRow (rs)
dim catalogid, imagefile, cname, cprice, url, imageurl, description
dim cstock, outofstockflag
outofstockflag=false
Response.write reportdetailrow
description=rs("cdescription")
catalogid=rs("catalogid")
imagefile=rs("cimageurl")
cname=rs("cname")
cname=translatelanguage(dbc, "products", "cname","catalogid", catalogid, cname)
description=translatelanguage(dbc, "products", "cname","catalogid", catalogid, description)
cstock=rs("cstock")
URL=getconfig("xCrossLinkURL")
url="shopexd.asp?id=" & rs("catalogid")
InventoryCheckstock cstock, outofstockflag
InventoryFormatimage  rs, imagefile, cname, url, outofstockflag
InventoryformatDescription  rs, description, cstock, outofstockflag
InventoryFormatButton  url, outofstockflag
response.write "</tr>"
end sub

'***************************************************************
' Put out image and name
'*****************************************************************
Sub InventoryFormatimage (rs, imagefile, cname, url, outofstockflag)
dim urlimage, urlname
response.write "<td width='75'>"
If not isnull(imagefile) then
    If outofstockflag=false then 
       urlimage="<a href='" &  url & "'><img border='0' src='" & imagefile & "'></a><br>"
    else
      urlimage="<img border='0' src='" & imagefile & "'><br>" 
    end if
end if
response.write urlimage
If outofstockflag=false then 
'       response.write "<a href='" & url & "'>" & cname & "</a>"
else
'       response.write cname 
end if   
response.write reportDetailColumnEnd 
end sub

'*****************************************************************
' Put out description and stock
'***************************************************************
Sub Inventoryformatdescription (rs, description, stock, outofstockflag)
response.write "<td align='left' width='100%'>"
response.write  description 
if getconfig("xOutOfStockLimit")<>"" then
   Inventoryformatstock   stock, outofstockflag
end if   
'response.write reportDetailColumnEnd 
End sub

Sub InventoryFormatstock  (stock, outofstockflag)
response.write "<br>" & getlang("LangProductStock") & " " & stock
end sub

Sub Inventoryformatbutton(url, outofstockflag)
'response.write reportdetailcolumn
response.write "<br>"
If outofstockflag=false then 
   response.write "<a href='" & url & "'>" & getlang("langcommonview") & "</a>"
else
  Response.write getlang("langOutOfStock") 
end if  
response.write reportDetailColumnEnd 
end sub

Sub InventoryCheckStock (lngcstock, outofstockflag)
if getconfig("xOutOfStockLimit")="" then exit sub
if isnull(lngcstock) then exit sub
if lngcstock>clng(getconfig("xOutOfStocklImit")) then exit sub
outofstockflag=True
end sub

'*******************************************************************************
' need to know whether this product has subproducts.
' If yes inventorycjeck is set to true
' If inventory display type is table, then we don't want to display prices
' since main product cannot be order
'********************************************************************************
sub InventoryProductYesNo (dbc, objrs, catalogid, inventorycheck, pricedisplay, quantitydisplay,inventoryoutofstock)
dim inventorydisplaytype, strhassubproduct, rc
inventorycheck=false
priceDisplay=true
quantitydisplay=true
inventoryoutofstock=false
If getconfig("xinventoryproducts")="No" then  exit sub
strinventoryproducts=objrs("inventoryproducts")
inventorydisplaytype=objrs("spdisplaytype")
if isnull(inventorydisplaytype) then
   inventorydisplaytype="table"
end if
if lcase(inventorydisplaytype)="table" then
   pricedisplay=false
   quantitydisplay=false
end if
if lcase(inventorydisplaytype)="quantity" then
   quantitydisplay=false
end if   
'      
if isnull(strinventoryproducts) then strinventoryproducts="" 
if strinventoryproducts<>"" then
    inventorycheck=true
end if

strhassubproduct=objrs("hassubproduct")   

if isnull(strhassubproduct) then strhassubproduct="" 
if strhassubproduct<>"" then
    inventorycheck=true
end if
If inventorycheck=true then
  Inventorystockcheck dbc, objrs, Inventoryoutofstock, rc
end if  
end sub
'**************************************************************************
' create a radio of subproducts
' ************************************************************************     
Sub  FormatInventoryRadio ( conn, rs, objrs)
dim selectname, checkname, msize, setselected, Loopend, subcatalogid
dim formcaption, multiple
dim fprefix, sSelect
Formatinventoryformname  fprefix, formcaption
selectname=fprefix & "subproductradio"
checkname=selectname
Multiple=""
msize=1
loopend="False"
sSelect=""
setselected=""
sSelect = ProdFeatureCaption & formCaption & ProdFeatureCaptionEnd 
tempOption=""
sSelect = sSelect & "<table cellpadding=0 cellspacing=0>"
Do While LoopEnd="False" 
   GenerateSubProductName tempoption, rs
   subcatalogid=rs("catalogid")
   sselect = sselect & "<tr>"
   If multiple="Yes" then 
     sselect=sselect & "<td><input type='Checkbox'" & setselected & " name='" & checkname & "' value='" & subcatalogid & "'></td><td>" & tempoption & "</td>"   
   else
     sselect=sselect & "<td><input type='Radio'" & setselected & " name='" & checkname & "' value='" & subcatalogid & "'></td><td>" & tempoption & "</td>"   
   end if  
   sselect = sselect & "</tr>"
   Rs.movenext
   if rs.EOF then 
      LoopEnd="True"
   end if
loop
sSelect = sSelect & "</table>"
response.write "<br>" & sselect 
end sub

'**************************************************************************
' create a Checkbox of subproducts
' ************************************************************************     
Sub  FormatInventoryCheckbox ( conn, rs, objrs)
dim selectname, checkname, msize, setselected, Loopend, subcatalogid
dim formcaption, multiple
dim fprefix, sSelect
Formatinventoryformname  fprefix, formcaption
selectname=fprefix & "subproductCheckbox"
checkname=selectname
Multiple=""
msize=1
loopend="False"
sSelect=""
setselected=""
sSelect = ProdFeatureCaption & formCaption & ProdFeatureCaptionEnd 
sSelect = sSelect & "<table cellpadding=0 cellspacing=0>"
tempOption=""
Do While LoopEnd="False" 
   GenerateSubProductName tempoption, rs
   subcatalogid=rs("catalogid")
   sSelect = sSelect & "<tr>"
   sselect=sselect & "<td><input type='Checkbox'" & setselected & " name='" & checkname & "' value='" & subcatalogid & "'></td><td>" & tempoption & "</td>"   
   sSelect = sSelect & "</tr>"
   Rs.movenext
   if rs.EOF then 
      LoopEnd="True"
   end if
loop
sSelect = sSelect & "</table>"
response.write "<br>" & sselect 
end sub
'**************************************************************************
' create a dropdownlist of subproducts
' subrs is the subproducts
' mainrs is the main product recordset
' ************************************************************************     
Sub FormatinventoryDropdown (conn, rs, mainrs)
dim selectname, checkname, msize, setselected, Loopend, subcatalogid
dim formcaption, multiple, discount
dim fprefix, sSelect
Formatinventoryformname  fprefix, formcaption
selectname=fprefix & "subproductdropdown"
Multiple=""
msize=1
loopend="False"
sSelect=""
setselected=""
sSelect = ProdFeatureCaption & formCaption & ProdFeatureCaptionEnd 
sSelect = sSelect & "<select size=" & msize & " name=" & Selectname & Multiple & " class='txtfielddropdown'>"
sSelect = sSelect & "<option selected>" & getlang("langCommonSelect") & "</option>" 
tempOption=""
Do While LoopEnd="False" 
   GenerateSubProductName tempoption, rs
   subcatalogid=rs("catalogid")
   sSelect = sSelect & "<option" & setselected & " value='" & subcatalogid &"'>" & tempoption & "</option>"    
   Rs.movenext
   if rs.EOF then 
      LoopEnd="True"
   end if
loop
sSelect= sSelect & "</select></p>"
Response.write sSelect
end sub

'**********************************************************************
' the formfieldname and caption are generated here
'**********************************************************************
Sub Formatinventoryformname (prefix, caption) 
dim fprefix
fprefix="Y"
prefix=fprefix & Prodindex
caption=getlang("langinventory")
end sub
'*****************************************************************************
' generate name in form
'  cname $xxx.yyy
'****************************************************************************
Sub GenerateSubProductName (tempoption, rs)
dim catalogid, discount, theprice
dim higherprice, newprice, highercat
dim hideprice 

hideprice = false
If getconfig("XDisplayPrices")<>"Yes" then
	hideprice = true
end if

if getconfig("xpriceloggedinonly") = "Yes" then
	if Getsess ("login") = "" then
		hideprice= true
		end if
end if

If getconfig("xshowchildprice")<>"Yes" then
	hideprice = true
end if

catalogid=rs("catalogid")
higherprice=rs("cprice")
newprice=rs("cprice")
highercat=rs("ccategory")
tempoption=rs("cname")
ShopCustomerPrices rs, catalogid, highercat, higherprice, newprice,discount
higherprice=newprice
theprice=shopformatcurrency(higherprice,getconfig("xdecimalpoint"))
if hideprice = true then
	tempoption=tempoption
else
	tempoption=tempoption & " - " & theprice  
end if
end sub

'**************************************************************************
' create a Checkbox of subproducts
' ************************************************************************     
Sub  FormatInventoryQuantity ( conn, rs, objrs)
dim selectname, checkname, msize, setselected, Loopend, subcatalogid
dim formcaption, multiple, valuename, catalogids, quantityname
dim fprefix, sSelect
Formatinventoryformname  fprefix, formcaption
selectname=fprefix & "subproductquantity"
valuename=selectname & "_catalogids"
checkname=selectname
catalogids=""
loopend="False"
sSelect=""
setselected=""
sSelect = ProdFeatureCaption & formCaption & ProdFeatureCaptionEnd 
sSelect = sSelect & "<table cellpadding=0 cellspacing=0>"
tempOption=""
Do While LoopEnd="False" 
   GenerateSubProductName tempoption, rs
   subcatalogid=rs("catalogid")
   if catalogids<>"" then
      catalogids=catalogids & ","
   end if
   catalogids=catalogids & subcatalogid
   quantityname=selectname & "_" & subcatalogid
   sSelect = sSelect & "<tr>"
   sselect=sselect & "<td><input type=text size=1 name='" & quantityname & "' value='" & "0" & "' class='txtfield'>&nbsp;</td>"
   sselect= sselect & "<td>" & tempoption & "</td>" 
   sSelect = sSelect & "</tr>"
   Rs.movenext
   if rs.EOF then 
      LoopEnd="True"
   end if
loop
sSelect = sSelect & "</table>"
response.write "<br>" & sselect 
Response.write "<input type='hidden' name='" & valuename & "' Value='" & catalogids & "'>" & vbcrlf
Response.Write "<input type=hidden name='" & checkname & "' value=" & Chr(34) & "Yes" & Chr(34) & ">" & vbcrlf
end sub


'*******************************************************************************
' see if there is a sub product being added.
' If so use its catalogid and not the main catalogid
' field could be
' subproductdropdown
' subproductquantity
' subproductradio
' subproductcheckbox
' subproduct
'******************************************************************************
' see if we have any sub products and if so handle 4 different types
'*****************************************************************************
sub CartInventoryProduct (productid, rc)
dim selectname, caption, subcatalogid, prefix
' See if we have subproduct radio selection
CartInventorySubproductRadio productid, rc 
If rc=0 then
     exit sub
end if
CartInventorySubproductDropdown productid, rc 
If rc=0 then
     exit sub
end if
' If we have a checkbox, product(s) where added in thar routine
' so we need to tell caller to do nothing
CartInventorySubproductCheckbox productid, rc 
If rc=0 then
     rc=4
     exit sub
end if
' If we have a checkbox, product(s) where added in thar routine
' so we need to tell caller to do nothing
CartInventorySubproductQuantity productid, rc 
If rc=0 then
     rc=4
     exit sub
end if          
rc=0
end sub
'***********************************************************************
' if there is a radio subproduct, change the main product id to the
' sub productid and that is all that needs to be done
'***********************************************************************
sub CartInventorySubproductRadio (productid, rc )
dim prefix, caption, selectname
rc=4
CartFormatinventoryformname prefix
selectname=prefix & "subproductradio"
subcatalogid=request(selectname) 
if subcatalogid<>"" then
   If not isnumeric(subcatalogid) then
       CartInventoryError  getlang("langsubnotnumeric")
   else    
     productid=subcatalogid
     'debugwrite "selectname=" & selectname & " Subcatalogid=" & subcatalogid   
     rc=0                                      
  end if   
end if
end sub
'***********************************************************************
' if there is a radio subproduct, change the main product id to the
' sub productid and that is all that needs to be done
'***********************************************************************
sub CartInventorySubproductDropdown (productid, rc )
dim prefix, caption, selectname
rc=4
CartFormatinventoryformname prefix
selectname=prefix & "subproductdropdown"
subcatalogid=request(selectname) 
'debugwrite "subcatalogid=" & subcatalogid & " selectname=" & selectname
if subcatalogid<>"" then
   if subcatalogid=getlang("langcommonselect") then
      cartinventoryerror getlang("langselectsubproduct")
   end if   
   If not isnumeric(subcatalogid) then
       CartInventoryError  getlang("langsubnotnumeric")
   else    
     productid=subcatalogid
     'debugwrite "selectname=" & selectname & " Subcatalogid=" & subcatalogid   
     rc=0                                      
  end if   
end if
end sub
'***********************************************************************
' if there is a Checkboxes. There can be multiple subproducts toadd to cart at once
' sub productid and that is all that needs to be done
'***********************************************************************
sub CartInventorySubproductCheckbox (productid, rc )
dim prefix, caption, selectname, i, catalogids(100), catalogidcount
dim count
rc=4
CartFormatinventoryformname prefix
selectname=prefix & "subproductcheckbox"
subcatalogid=request(selectname) 
'VP-ASP 6.08 Fix
'debugwrite "selectname=" & selectname & " Subcatalogid=" & subcatalogid 


'check if this product is a parent and of type checkbox
dim subrs, subdbc
shopopendatabaseP subdbc
sql = "select hassubproduct, spdisplaytype from products where catalogid = " & productid
set subrs = subdbc.execute(sql)

if not subrs.eof then
	if subrs("hassubproduct") = "Yes" then
		if subrs("spdisplaytype") = "Checkbox" OR subrs("spdisplaytype") = "Radio" then
			if subcatalogid="" then 
				closerecordset subrs
				shopclosedatabase subdbc
				cartinventoryerror getlang("langselectsubproduct")
			end if
		else
			'VP-ASP 6.09 - close open connection
			if subcatalogid="" then 
				closerecordset subrs
				shopclosedatabase subdbc
				exit sub			
			end if
		end if
	else
		'VP-ASP 6.09 - close open connection
		if subcatalogid="" then 
			closerecordset subrs
			shopclosedatabase subdbc
			exit sub	
		end if
	end if
else
	'VP-ASP 6.09 - close open connection
	if subcatalogid="" then 
		closerecordset subrs
		shopclosedatabase subdbc
		exit sub
	end if
end if
closerecordset subrs
shopclosedatabase subdbc


'19/01/2006 - wasn't erroring out if no sub product was selected
'if subcatalogid="" then 
'	CartInventoryError  getlang("langselectsubproduct")  
'end if
'VP-ASP 6.08 End Fix
'debugwrite "selectname=" & selectname & " Subcatalogid=" & subcatalogid   
parserecord subcatalogid, catalogids,catalogidcount,","
count=0
for i =0 to catalogidcount-1
   subcatalogid=catalogids(I)
   If not isnumeric(subcatalogid) then
     CartInventoryError  getlang("langsubnotnumeric")
     rc=0
     exit sub
   end if
next  
' if there is only 1 then treat it normally by changing main product id
' At this time we have multiple subproducts to add to the cart
' catalogids are in the catalogids array
  for i = 0 to catalogidcount-1          
     CartInventorySubproductAddtocart catalogids(i), quantity
     count=count+1
  next
  If count>0 then 
    rc=0  
    exit sub
  end if  
  CartInventoryError  getlang("langselectsubproduct")      
end sub

'***********************************************************************
' if there is a quantities have multiple form fields
' subproductquantity_catalogids= 3,5,7   list of subproducts
' subproductquanty_3  = actual quantity for subproduct 3
' sub productid and that is all that needs to be done
'***********************************************************************
sub CartInventorySubproductQuantity (productid, rc )
dim prefix, caption, selectname, i, catalogids(100), catalogidcount
dim quantityname, subcatalogid, valuename
dim catalogidlist, count, subquantity

rc=4
CartFormatinventoryformname prefix
selectname=prefix & "subproductquantity"
valuename=selectname & "_catalogids"
subcatalogid=request(selectname) 
if subcatalogid="" then exit sub
catalogidlist=request(valuename)
'debugwrite "selectname=" & selectname & " Subcatalogid=" & catalogidlist   
parserecord catalogidlist, catalogids,catalogidcount,","
for i =0 to catalogidcount-1
   subcatalogid=catalogids(I)
   If not isnumeric(subcatalogid) then
     CartInventoryError  getlang("langsubnotnumeric")
     rc=0
     exit sub
   end if
next
count=0
' we now know all the sub products. Each can have their own quantity
' in form subproductquantity_x  where x is the catalogid
' if there is only 1 then treat it normally by changing main product id
' At this time we have multiple subproducts to add to the cart
' catalogids are in the catalogids array
  'debugwrite "catalogidcount=" & catalogidcount
  for i = 0 to catalogidcount-1
     subcatalogid=catalogids(i)
     quantityname=selectname & "_" & subcatalogid 
     subquantity=request(quantityname)
     'debugwrite "quantityname=" & quantityname & " quantity=" & subquantity
     if isnumeric(subquantity) then
        if subquantity>0 then          
            CartInventorySubproductAddtocart subcatalogid, subquantity
            count=count+1
        end if
    end if          
  next
  if count>0 then  
    rc=0  
    exit sub
  end if
  CartInventoryError  getlang("langselectsubproduct")   
 end sub
 
Sub CartInventoryError (msg)
shoperror msg
end sub
'***********************************************************************************
' we need to add the subproduct to the cart with the quantity given
'**********************************************************************************
Sub CartInventorySubproductAddtocart (productid, subquantity)
dim rc
'productid=catalogid
quantity=subquantity 
CartGetProduct productid, rc
If rc= 0 then 
     SetSess "newProductPrice",""
     GetProductFeatures prodi          ' located in shopproductfeatures 
     CartAddItem Productid, rc   
end if    
end sub

'**********************************************************************
' the formfieldname and caption are generated here
'**********************************************************************
Sub CartFormatinventoryformname (prefix) 
dim fprefix
fprefix="Y"
prefix=fprefix & Prodi
end sub
'**********************************************************************************************
' check all inventory products to see if they are out of stock
' use highest of xstocklow and xoutofstocklimit
'*********************************************************************************************
sub Inventorystockcheck (dbc, objrs, Inventoryoutofstock, rc)
dim stocknum, stocknum2, rs
dim strcrossproductids,hassubproduct,catalogid,strsql
rc=0
inventoryoutofstock=false
if getconfig("xstocklow")<>"" then 
   stocknum=clng(getconfig("xstocklow"))
else
   stocknum=-1
end if  
if getconfig("xOutOfStockLimit")<>"" then
     stocknum2=clng(getconfig("xOutOfStockLimit"))
else
     stocknum2=-1
end if 
if stocknum2>stocknum then
   stocknum=stocknum2
end if
if stocknum=-1 then exit sub       
strcrossproductids=objrs("inventoryproducts")
hassubproduct=objrs("hassubproduct")
catalogid=objrs("catalogid")
strsql="select * from products where ("
If strcrossproductids<>"" Then 
   strsql=strsql & " catalogid in (" & strcrossproductids & ")" 
   strsql=strsql & " or "
end if   
strsql =strsql & "highercatalogid=" & catalogid & ")"
if getconfig("xstocklow")<>"" then
    lngcstock= clng(getconfig("xstocklow")) 
    strsql = strsql & " and cstock> " & stocknum
    
end if 
'debugwrite strsql
set rs=dbc.execute(strsql)
If rs.eof then
  rc=4
  inventoryoutofstock=true
  exit sub
end if  
closerecordset rs
end sub
%>
