<%
'*********************************************************
' VP-ASP 5.00 Validate vatnumber
' Feb 4, 2003
' May 13, 2004 Fix vat calculation
' August 18, 2004 Fix Greek VAT numbers not accepted at all
' August 18, 2004 Fix UK VAT numbers with prefix GB not accepted
' August 18, 2004 Fix UK VAT numbers with length = 12 not accepted
' August 18, 2004 Fix Irish VAT numbers accepted to incorrect scheme
' August 18, 2004 Added the 10 new EU member states
'*********************************************************
Sub Validatevat (strcountry)
dim vatmycountry, partial
setsess "vatnumbertax",""
dim vatnumber, vatrc
vatnumber=request("vatnumber")
If vatnumber <> "" then
   ShopvalidateVat strcountry, vatnumber, vatrc
    select case vatrc
    	case 0
    	   vatmycountry=getconfig("xvatcountry")
    	   if strcountry<>vatmycountry  then
    	      setsess "vatnumbertax",vatnumber
    	   end if   
    	case 4
    	   sError = sError & getlang("LangVatinvalid")  & " " & vatnumber & "<br>"
    end select 
end if                   
End sub

'*********************************************************
' VP-ASP 4.50 April 7, 2002
' Validate VAT
'******************************************************
Sub ShopValidateVat(country, vatnumber, rc)
	dim tmpcountry, tmpvat, partial
	tmpvat = ucase(replace(vatnumber," ", ""))	
	tmpcountry = left(vatnumber,2)
	
	' Oops, there is a small problem with two member states:
	' The member states that VPASP refers to as "UK" and "GR"
	' use VAT prefixes "GB" and "EL" respectively.
	' We will use the codes "UK" and "GR" only internally,
	' but we will NOT accept them as input
	
	if tmpcountry = "UK" OR tmpcountry = "GR" then
		rc = 4
		exit sub
	end if
	
	if tmpcountry = "GB" then
	  tmpcountry = "UK"
	end if
	if tmpcountry = "EL" then
	  tmpcountry = "GR"
	end if
		
	If tmpcountry=country then
	   tmpvat=right(tmpvat, len(vatnumber) - 2)
	end if   
	select case country
		case "AT"
			if len(tmpvat) = 9 then
				if left(tmpvat, 1) = "U" then
					rc = 0
				else
					rc = 4
				end if
			else
				rc = 4
			end if
			
		case "BE"
			if len(tmpvat) = 9 And  IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "DK"
			if len(tmpvat) = 8 And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "FI"
			if len(tmpvat) = 8 And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if
		
		case "FR"
		      rc=4
		      if len(tmpvat) <> 11  then exit sub
		      partial=mid(tmpvat,3,9)
		      If not isnumeric(partial) then exit sub
		      rc=0    

		case "UK"
			if (len(tmpvat) = 9 Or len(tmpvat) = 12) And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "DE"
			if len(tmpvat) = 9 And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "GR"
			if len(tmpvat) = 9 And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "IE"
		      rc=4
		      if len(tmpvat) <> 8  then exit sub
			  if NOT IsNumeric(left(tmpvat,1)) then exit sub
		      partial=mid(tmpvat,3,5)
		      If not isnumeric(partial) then exit sub
		      rc=0    

		case "IT" 
			if len(tmpvat) = 11  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "LU"
			if len(tmpvat) = 8 And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "NL"
			if len(tmpvat) = 12 And left(right(tmpvat, 3), 1) = "B" And IsNumeric(right(tmpvat,2)) then
				rc = 0
			else
				rc = 4
			end if

		case "PT"
			if len(tmpvat) = 9  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "ES"
			if len(tmpvat) = 9 And IsNumeric(left(right(tmpvat, 8),7)) then
				rc = 0
			else
				rc = 4
			end if

		case "SE"
			if len(tmpvat) = 12  And IsNumeric(tmpvat) And right(tmpvat, 2) = "01" then
				rc = 0
			else
				rc = 4 
			end if

		case "CY"
			if len(tmpvat) = 9 And IsNumeric(left(tmpvat,8)) then
				rc = 0
			else
				rc = 4
			end if
		
		case "CZ"
			if len(tmpvat) = 11 then
				tmpvat = mid(tmpvat,4,8)
			else	if len(tmpvat)=12 then 
						tmpvat = mid(tmpvat,4,9)
				 	else 	if len(tmpvat)= 13 then 
								tmpvat = mid (tmpvat,4,10)
							end if
					end if
			end if
			if (len(tmpvat) = 8 OR len(tmpvat) = 9 OR len(tmpvat)=10) AND IsNumeric(tmpvat) then
				rc = 0
			else
				rc= 4
			end if
			
		case "EE"
			if len(tmpvat) = 9  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if
		
		case "HU"
			if len(tmpvat) = 8  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if
		
		case "LV"
			if len(tmpvat) = 11  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if
		
		case "LT"
			if (len(tmpvat) = 9 OR len(tmpvat) = 12) AND IsNumeric(tmpvat) then
				rc = 0
			else
				rc= 4
			end if
		
		case "MT"
			if len(tmpvat) = 8  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case "PL"
			if len(tmpvat) = 10  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if
		
		case "SK"
			if len(tmpvat) = 10  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if
		
		case "SI"
			if len(tmpvat) = 8  And IsNumeric(tmpvat) then
				rc = 0
			else
				rc = 4
			end if

		case else
			'Set country to "" and return invalid country code error
			rc=8
	end select
end sub
%>