<!-- 
    ****************************************
    * List of categories 
    ****************************************
    Template sequence:
        - cats_top
        
        - cats_column_top       // for each categories column           |
        - cat                   // repeat for each category in column   | repeat for all categories
        - cats_column_bottom    // for each categories column           |     
        
        - cats_bottom
-->

<!-- Categories block top -->
{TEMPLATE cats_top}
    <table width="100%" class="categories">
    <tr>
{/TEMPLATE}

<!-- Categories block column top -->
{TEMPLATE cats_column_top}
       <td valign="top" width="{$CNCAT[page][cat_col_width]}%">
{/TEMPLATE}

<!-- Category template. 
    Additional fields that can be used:
        $CNCAT[cat][_number]   - index of current category (starts from 0)
        $CNCAT[cat][_count]    - count of categories
        $CNCAT[cat][_isfirst]  - =1 if first category
        $CNCAT[cat][_islast]   - =1 if last category
        $CNCAT[cat][_colcount] - column count
        $CNCAT[cat][_colwidth] - column width
--> 
{TEMPLATE cat 
    ( CAT[id, title, item_count_full, is_link, image_mime])
}   
            <table width="100%" class="category">
            <tr>
                <td width="1" valign="top" rowspan="2">
                    {IF $CNCAT[cat][image_mime]}
                    	<a href="{$CNCAT[cat][url]}"><img src="{$CNCAT[abs]}cncat_image.php?cat={$CNCAT[cat][id]}" alt="" style="vertical-align: middle;border:0;margin:2px 4px 2px 4px" /></a>
                    {ELSE}
	                    <a href="{$CNCAT[cat][url]}"><img src="{$THEMEURL}images/category{IF $CNCAT[cat][is_link]}_link{ENDIF}.gif" vspace="2" hspace="4" width="16" height="12" border="0" alt=""></a>
					{ENDIF}
                </td>
                <td valign="top" class="category">
                    {IF $CNCAT[cat][is_link]}@{ENDIF}<a href="{cn_str($CNCAT[cat][url])}">{cn_str($CNCAT[cat][title])}</a>
                    &nbsp;{$CNCAT[cat][item_count_full]}
                </td>
            </tr>
            <tr>
                <td class="subcategories">
                    {DISPLAY SUBCATS}
                </td>
            </table>
            <br>
{/TEMPLATE}    

<!-- Categories block column bottom -->
{TEMPLATE cats_column_bottom}
        </td>
{/TEMPLATE}


<!-- Categories block bottom -->
{TEMPLATE cats_bottom}
    </tr>
    </table>
{/TEMPLATE}




<!-- 
    ****************************************
    * Subcategories for each category in list
    ****************************************
    Template sequence:
        - subcats_top
        
        - subcat        // first subcategory
        
        - subcats_delim  | repeat for each next subcategory
        - subcat        |
        
        - subcats_more // if there are more subcategories than displayed
        
        - subcats_bottom
-->

<!-- Subcategories block top -->
{TEMPLATE subcats_top}{/TEMPLATE}

<!-- Subcategory template. 
    Additional fields that can be used:
        $CNCAT[subcat][_number]   - index of current subcategory (starts from 0)
        $CNCAT[subcat][_count]    - count of subcategories
        $CNCAT[subcat][_isfirst]  - =1 if first subcategory
        $CNCAT[subcat][_islast]   - =1 if last subcategory
--> 
{TEMPLATE subcat (SUBCAT[title, item_count_full, is_link])}{IF $CNCAT[subcat][is_link]}&nbsp;@{ENDIF}<a href="{$CNCAT[subcat][url]}">{cn_str($CNCAT[subcat][title])}</a>&nbsp;{$CNCAT[subcat][item_count_full]}{/TEMPLATE}

<!-- Subcategories delimiter -->
{TEMPLATE subcats_delim}, {/TEMPLATE}

<!-- "..." if there are more subcategories than displayed -->
{TEMPLATE subcats_more}... {/TEMPLATE}

<!-- Subcategories block bottom -->
{TEMPLATE subcats_bottom}{/TEMPLATE}


<!-- 
    ****************************************
    * Path to the current category  
    ****************************************
    Template sequence for root category:
        - catpath_top
        - catpath_currentcat
        - catpath_bottom

    Template sequence for non-root category:
        - catpath_top
        - catpath_rootcat
        
        - catpath_parentcat_delim    | repeat for all parent categories
        - catpath_parentcat          | 
        
        - catpath_currentcatdelim
        - catpath_currentcat
        - catpath_bottom
-->

<!-- Category path block top -->
{TEMPLATE catpath_top}
    <br>    
    <table class="catpath">
    <tr>
        <td width="1">{IF $CNCAT[page][cat][image_mime]}<img src="{$CNCAT[abs]}cncat_image.php?cat={$CNCAT[page][cid]}" alt="" style="vertical-align: middle;" />{ENDIF}</td>
        <td>
            &nbsp;
{/TEMPLATE}

<!-- Root category (if current category is not root) -->
{TEMPLATE catpath_rootcat}
            <a href="{cn_str($CNCAT[cat][url])}" class="main">{cn_str($CNCAT[cat][title])}</a> 
{/TEMPLATE}

<!-- Delimiter between categories (except current category) -->
{TEMPLATE catpath_parentcat_delim} 
            &raquo; 
{/TEMPLATE}

<!-- One of the parent categories -->
{TEMPLATE catpath_parentcat}
            <a href="{cn_str($CNCAT[cat][url])}">{cn_str($CNCAT[cat][title])}</a>
{/TEMPLATE}

<!-- Delimiter before the current category -->
{TEMPLATE catpath_currentcat_delim} 
            &raquo;
{/TEMPLATE}

<!-- Current category -->
{TEMPLATE catpath_currentcat}
            <span class="currentcat">{cn_str($CNCAT[cat][title])}</span>
{/TEMPLATE}

<!-- Category path block bottom -->
{TEMPLATE catpath_bottom}
            {IF $CNCAT[cat][_canedit]}
                (<a href="{$CNCAT[abs]}{$CNCAT[system][dir_admin]}index.php?act=cats&mode=add&id={$CNCAT[cat][id]}"><small>{$CNCAT[lang][do_submit]}</small></a> |
                <a href="{$CNCAT[abs]}{$CNCAT[system][dir_admin]}index.php?act=cats&mode=edit&id={$CNCAT[cat][id]}"><small>{$CNCAT[lang][do_edit]}</small></a>)
            {ENDIF}
        </td>
    </tr>
    </table>
{/TEMPLATE}


