;
; Startup file for notGNU emacs (notgnu.st).
; This form of file can be loaded at anytime using
; the extended command load-file.
;

; Default is to make backups; uncommenting the following
; line will turn backups off.
(toggle-make-backups)


; I like to make sure I don't edit a file in 2 places
; the default is NOT to check so this turns it on
(toggle-check-file-timestamp)


; Default is not to display linenumber in the modeline; 
; The following toggles line numbers on.
(toggle-show-linenumber)

; Default is to highlight the background on mouse selections.
; Uncomment if you want to highlight the foreground (text) instead:
; (set-select-highlight 'f)

; My UNIX machines hate to see my C source with all those
; dang CR in them (network shared disks) - default is CR
; is written for all files, this disables CR from being written
; [Should remain disabled for DOS machines]
; (toggle-just-write-newline)


; GNU-like autocompletion is not set by default; the GNU-ness
; isn't perfect yet. :(  Uncomment if you are a die-hard GNU.
; (set-gnu)


; Default autosave interval is 15 seconds.
; Let's be a little more macho than that.
if !DOS (set-autosave-inc '120)


; Various keybindings to make me happy
; "\^x" is ctrl-x
; "\F1" is function key F1
; "\Eo" is meta-o (or ESC-o)
; "\Kp-+" is keypad +
; "\Delete" is a named key
; "\SDelete" is shift + a named key
; "\CDelete" is control + a named key

(global-set-key "\F1"         'goto-line)
(global-set-key "\F8"         'other-window)
(global-set-key "\e+"         'enlarge-window)
(global-set-key "\e-"         'shrink-window)
(global-set-key "\^z"         'scroll-one-line-up)
(global-set-key "\ez"         'scroll-one-line-down)

(global-set-key "\^x\^i"      'insert-file)
(global-set-key "\^x!"        'shell-command)
(global-set-key "\^xu"        'undo)
(global-set-key "\^_"         'undo)

; Uncomment the ones you like:
; (global-set-key "\efx"        'save-buffers-kill-emacs) ; Alt-F x
; (global-set-key "\Insert"     'set-mark-command)        ; A Demacs thing

; These they will fail in the DOS version because
;   (1) these are not legal DOS commands or
;   (2) fkeys beyond 10 are not visible.
;
; ``if <os>'' and ``if !<os>'' are supported; case sensitive!
; Legal <os> values are DOS, Win3, WinNT, X11

if !DOS (global-set-key "\F2"         'shell-window)
if !DOS (global-set-key "\F9"         'make)
if !DOS (global-set-key "\F10"        'next-error)
if !DOS (global-set-key "\F12"        'undo)
if !DOS (global-set-key "\^x`"        'next-error)
if !DOS (global-set-key "\SBackspace" 'backward-kill-word)

; Uncomment the ones you like:
; if  DOS (global-set-key "\^z" 'shell-command)
; if !DOS (global-set-key "\^z" 'shell-window)
