
#define MAX_FORTUNE 	512

#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/*-----------------------------*/

long FAR PASCAL MainWndProc (HWND, WORD, WORD, LONG);
char *fortune(HWND);

/*-----------------------------*/

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow )
{
HWND hwnd;
MSG msg;
WNDCLASS wndclass;

if (!hPrevInstance)
	{
	wndclass.lpszClassName="FORTUNE";
	wndclass.hInstance=hInstance;
	wndclass.lpfnWndProc=(WNDPROC)MainWndProc;
	wndclass.hCursor=LoadCursor(hInstance,IDC_ARROW);
	wndclass.hIcon=LoadIcon(hInstance,IDI_APPLICATION);
	wndclass.lpszMenuName=NULL;
	wndclass.hbrBackground=COLOR_WINDOW+1;
	wndclass.style=NULL;
	wndclass.cbClsExtra=0;
	wndclass.cbWndExtra=0;

        RegisterClass (&wndclass);
        }

CreateWindow (	"FORTUNE",
		"Windows Fortune",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		0,
		CW_USEDEFAULT,
		0,
		NULL,
		NULL,
		hInstance,
		NULL ) ;

return 0;
}

/*------------------------------*/

long FAR PASCAL MainWndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
char *str;
	switch (message)
		{
		case WM_CREATE:
			if ((str=(char *)fortune(hwnd))!=(char *)NULL)
				MessageBox(hwnd,(LPCSTR)str,(LPCSTR)"Fortune says",MB_ICONEXCLAMATION);
			SendMessage(hwnd,WM_DESTROY,0,0L);
                        break;
		case WM_DESTROY:
			PostQuitMessage(0);
                        break;
		default:
			return(DefWindowProc(hwnd,message,wParam,lParam));
		}
return 0L;
}

/*-----------------------------*/

char *fortune(HWND hwnd)
{
FILE *fd;
long pos;
char *str;
int i,j;
char c1,c2;

if ((fd=fopen("fortune.txt","r"))==NULL)
	{
	MessageBox(hwnd,(LPCSTR)"File FORTUNE.TXT not found !",(LPCSTR)"WFORTUNE",MB_ICONSTOP);
	return(NULL);
	}

randomize();

if (fseek(fd,0,SEEK_END)!=0)
	{
	MessageBox(hwnd,(LPCSTR)"File FORTUNE.TXT not found !",(LPCSTR)"WFORTUNE",MB_ICONSTOP);
	return(NULL);
	}

if ((pos=ftell(fd))==-1L)
	{
	MessageBox(hwnd,(LPCSTR)"File FORTUNE.TXT size error !",(LPCSTR)"WFORTUNE",MB_ICONSTOP);
	return(NULL);
	}

if (pos==0L)
	{
	MessageBox(hwnd,(LPCSTR)"File FORTUNE.TXT is empty !",(LPCSTR)"WFORTUNE",MB_ICONSTOP);
	return(NULL);
	}
j=0;

str=(char *)malloc(MAX_FORTUNE);

loop:

fseek(fd,MAKELONG(random(LOWORD(pos+1)),random(HIWORD(pos+1))),SEEK_SET);

i=0;

if (j++==10)
	{
	MessageBox(hwnd,(LPCSTR)"File FORTUNE.TXT error !",(LPCSTR)"WFORTUNE",MB_ICONSTOP);
	return(NULL);
	}					  	// I'll pay a beer if it append

if ((c2=getc(fd))!=EOF)					// file is empty ??
	while ((c1 = getc(fd)) != EOF)
		{
		if ((c1=='%')&&(c2=='%')) break;
		c2=c1;
		}
if ((c2=getc(fd))!=EOF)					// I got the last scene
	while ((c1 = getc(fd)) != EOF)
		{
		if ((c1=='%')&&(c2=='%')) break;
		str[i++]=c2;
		c2=c1;
		}
else
	goto loop;

str[i]=0;

fclose (fd);

return(str);
}

