#include <stdlib.h>

/*============= STRUCTURES ================*/

struct GAME
{
	int nbrcoups;
	int lastX,lastY;
	int t[9][8];
	int lastpos[8];
} game;

/*============= DEFINES ====================*/

#define COMPUTER -1
#define PLAYER 	  1
#define NOBODY 	  0
#define OTHER     2

#define COUP int				/* Generateur de coup */

#define MaxVal 128
#define InitCoup(x) x=1
#define CoupSvt(x) x++
#define LastCoup(x) (x>7)
				/* Mouvements dans le jeu */
#define put(i,colour) \
	game.t[i][++game.lastpos[i]]=colour;\
	game.nbrcoups++;\
	game.lastY=game.lastpos[i];\
	game.lastX=i;\

#define get(i) \
	game.t[i][game.lastpos[i]--]=0;\
	game.nbrcoups--;\

#define finish() (game.nbrcoups==46)			/* regles du jeu */

#define good(i) (game.lastpos[i]!=6)

/*============= PROTOTYPES ================*/

void InitGame(void);
int win (int);
int Heurist(int, int);
int Max(int, int);
int Min(int, int);
int Min_Max(int);

/* ============ FUNCTIONS =================*/

void InitGame()
{
	short i,j;
	game.nbrcoups=0;
	for (i=0;i<=8;i++)
	{
		game.t[i][0]=OTHER;
		game.t[i][7]=OTHER;
	}
	for(i=0;i<=7;i++)
	{
		game.t[0][i]=OTHER;
		game.t[8][i]=OTHER;
		game.lastpos[i]=0;
	}
	for (i=1;i<=7;i++)
		for(j=1;j<=6;j++)
			game.t[i][j]=NOBODY;
}

int win(colour)
int colour;
{
	int c;					/* vertical */
	c=0;
	if (game.t[game.lastX][game.lastY-1]==colour)
	{
		c++;
		if (game.t[game.lastX][game.lastY-2]==colour)
		{
			c++;
			if (game.t[game.lastX][game.lastY-3]==colour)
				return (1);
		}
	}
	c=0;					/* horizontal */
	if (game.t[game.lastX-1][game.lastY]==colour)
	{
		c++;
		if (game.t[game.lastX-2][game.lastY]==colour)
		{
			c++;
			if (game.t[game.lastX-3][game.lastY]==colour)
				return(1);
		}
	}
	if (game.t[game.lastX+1][game.lastY]==colour)
	{
		c++;
		if (game.t[game.lastX+2][game.lastY]==colour)
		{
			c++;
			if (game.t[game.lastX+3][game.lastY]==colour)
				return(1);
		}
	}
	if (c>=3) return(1);
	c=0;					/* diagonal gauche */
	if (game.t[game.lastX+1][game.lastY-1]==colour)
	{
		c++;
		if (game.t[game.lastX+2][game.lastY-2]==colour)
		{
			c++;
			if (game.t[game.lastX+3][game.lastY-3]==colour)
				return (1);
		}
	}
	if (game.t[game.lastX-1][game.lastY+1]==colour)
	{
		c++;
		if (game.t[game.lastX-2][game.lastY+2]==colour)
		{
			c++;
			if (game.t[game.lastX-3][game.lastY+3]==colour)
				return (1);
		}
	}
	if (c>=3) return(1);
	c=0;					/* diagonal droite */
	if (game.t[game.lastX+1][game.lastY+1]==colour)
	{
		c++;
		if (game.t[game.lastX+2][game.lastY+2]==colour)
		{
			c++;
			if (game.t[game.lastX+3][game.lastY+3]==colour)
				return(1);
		}
	}
	if (game.t[game.lastX-1][game.lastY-1]==colour)
	{
		c++;
		if (game.t[game.lastX-2][game.lastY-2]==colour)
		{
			c++;
			if (game.t[game.lastX-3][game.lastY-3]==colour)
				return (1);
		}
	}
	if (c>=3) return(1);
	return(0);
}

int Heurist(X,colour)
int X; int colour;
{
	int c,Y,vertic,horiz,diagg,diagd;
	/* vertical */
	Y=game.lastpos[X];

	vertic=0;
	c=0;
	if ((game.t[X][Y-1]==colour)||(game.t[X][Y-1]==0))
	{
		vertic++;
		if (game.t[X][Y-1]==colour) c++;
		if ((game.t[X][Y-2]==colour)||(game.t[X][Y-2]==0))
		{
			vertic++;
			if (game.t[X][Y-2]==colour) c++;
			if (game.t[X][Y-3]==colour) c++;
			else
				if (game.t[X][Y-3]==0) vertic++;
		}
	}

	if ((game.t[X][Y+1]==colour)||(game.t[X][Y+1]==0))
	{
		vertic++;
		if (game.t[X][Y+1]==colour) c++;
		if ((game.t[X][Y+2]==colour)||(game.t[X][Y+2]==0))
		{
			vertic++;
			if (game.t[X][Y+2]==colour) c++;
			if (game.t[X][Y+3]==colour) c++;
			else
				if (game.t[X][Y+3]==0) vertic++;
		}
	}
	if (vertic>=3) vertic=vertic-2+2*c;
	else vertic=0;

	c=0;                                                    /* horizontal */
	horiz=0;
	if ((game.t[X-1][Y]==colour)||(game.t[X-1][Y]==0))
	{
		horiz++;
		if (game.t[X-1][Y]==colour) c++;
		if ((game.t[X-2][Y]==colour)||(game.t[X-2][Y]==0))
		{
			horiz++;
			if (game.t[X-2][Y]==colour) c++;
			if (game.t[X-3][Y]==colour) c++;
			else
				if (game.t[X-3][Y]==0) horiz++;
		}
	}

	if ((game.t[X+1][Y]==colour)||(game.t[X+1][Y]==0))
	{
		horiz++;
		if (game.t[X+1][Y]==colour) c++;
		if ((game.t[X+2][Y]==colour)||(game.t[X+2][Y]==0))
		{
			horiz++;
			if (game.t[X+2][Y]==colour) c++;
			if (game.t[X+3][Y]==colour) c++;
			else
				if (game.t[X+3][Y]==0) horiz++;
		}
	}
	if (horiz>=3) horiz=horiz-2+2*c;
	else horiz=0;

	c=0;                                            /* diag gauche */
	diagg=0;
	if ((game.t[X-1][Y-1]==colour)||(game.t[X-1][Y-1]==0))
	{
		diagg++;
		if (game.t[X-1][Y-1]==colour) c++;
		if ((game.t[X-2][Y-2]==colour)||(game.t[X-2][Y-2]==0))
		{
			diagg++;
			if (game.t[X-2][Y-2]==colour) c++;
			if (game.t[X-3][Y-3]==colour) c++;
			else
				if (game.t[X-3][Y-3]==0) diagg++;
		}
	}

	if ((game.t[X+1][Y+1]==colour)||(game.t[X+1][Y+1]==0))
	{
		diagg++;
		if (game.t[X+1][Y+1]==colour) c++;
		if ((game.t[X+2][Y+2]==colour)||(game.t[X+2][Y+2]==0))
		{
			diagg++;
			if (game.t[X+2][Y+2]==colour) c++;
			if (game.t[X+3][Y+3]==colour) c++;
			else
				if (game.t[X+3][Y+3]==0) diagg++;
		}
	}
	if (diagg>=3) diagg=diagg-2+2*c;
	else diagg=0;

	c=0;                                    /* diag droite */
	diagd=0;
	if ((game.t[X+1][Y-1]==colour)||(game.t[X+1][Y-1]==0))
	{
		diagd++;
		if (game.t[X+1][Y-1]==colour) c++;
		if ((game.t[X+2][Y-2]==colour)||(game.t[X+2][Y-2]==0))
		{
			diagd++;
			if (game.t[X+2][Y-2]==colour) c++;
			if (game.t[X+3][Y-3]==colour) c++;
			else
				if (game.t[X+3][Y-3]==0) diagd++;
		}
	}
	if ((game.t[X-1][Y+1]==colour)||(game.t[X-1][Y+1]==0))
	{
		diagd++;
		if (game.t[X-1][Y+1]==colour) c++;
		if ((game.t[X-2][Y+2]==colour)||(game.t[X-2][Y+2]==0))
		{
			diagd++;
			if (game.t[X-2][Y+2]==colour) c++;
			if (game.t[X-3][Y+3]==colour) c++;
			else
				if (game.t[X-3][Y+3]==0) diagd++;
		}
	}
	if (diagd>=3) diagd=diagd-2+2*c;
	else diagd=0;

	return(vertic+horiz+diagg+diagd);
}

/* ============================= Min Max ========================== */


int Min(level, Seuil)
int level; int Seuil;
{
	int BestVal,Val;
	COUP Coup;
	InitCoup(Coup);
	BestVal=MaxVal;
	do
	{
		if (good(Coup))
		{
			put(Coup,PLAYER);
			if (win(PLAYER)) Val= -level;
			else if ((level==0)||(finish())) Val=0;
			else Val=Max(level-1,BestVal);
			get(Coup);
			if (Val<BestVal)
				{
				BestVal=Val;
				if (BestVal<Seuil) break;
				}
		}
		CoupSvt(Coup);
	}
	while (!LastCoup(Coup));
	return(BestVal);
}

int Max(level, Seuil)
int level; int Seuil;
{ 
	int BestVal,Val;
	COUP Coup;
	InitCoup(Coup);
	BestVal= -MaxVal;
	do
	{
		if (good(Coup))
		{
			put(Coup,COMPUTER);
			if (win(COMPUTER)) Val=level;
			else if ((level==0)||(finish())) Val=0;
				else Val=Min(level-1,BestVal);
			get(Coup);
			if (Val>BestVal)
				{
				BestVal=Val;
				if (BestVal>Seuil) break;
				}
		}
		CoupSvt(Coup);
	}
	while (!LastCoup(Coup));
	return(BestVal);
}

COUP Min_Max(level)
int level;
{
	int Val,BestVal,BestHVal,HVal;
	COUP Coup,BestCoup;
	InitCoup(Coup);
	BestHVal=0;
	BestVal= -MaxVal;
	while (!LastCoup(Coup))
	{
		if (good(Coup))
		{
			put(Coup,COMPUTER);
			if (win(COMPUTER)) Val=level;
			else if (finish()||(level==0)) Val=0;
			else Val=Min(level,BestVal);
			if (BestVal<=Val)
			{
				HVal=Heurist(Coup,COMPUTER);
				if ((BestVal<Val)||((BestVal==Val)&&
				    ((BestHVal<HVal)||
				    ((BestHVal==HVal)&&(rand()<RAND_MAX/2)))))
				{
					BestVal=Val;
					BestCoup=Coup;
					BestHVal=HVal;
				}
			}
			get(Coup);
		}
		CoupSvt(Coup);
	}
	return(BestCoup);
}
