
// game.h


/*============= STRUCTURES ================*/

extern struct GAME
{
	int nbrcoups;
	int lastX,lastY;
	int t[9][8];
	int lastpos[8];
} game;

/*============== DEFINES ==================*/

#define COMPUTER -1
#define PLAYER 	  1
#define NOBODY 	  0
#define OTHER     2

/*============= PROTOTYPES ================*/

void InitGame(void);
int win (int);
int Min_Max(int);

/*============== MACRO =================*/

				/* Mouvements dans le jeu */
#define put(i,colour) \
	game.t[i][++game.lastpos[i]]=colour;\
	game.nbrcoups++;\
	game.lastY=game.lastpos[i];\
	game.lastX=i;\

#define get(i) \
	game.t[i][game.lastpos[i]--]=0;\
	game.nbrcoups--;\

#define finish() (game.nbrcoups==46)			/* regles du jeu */

#define good(i) (game.lastpos[i]!=6)



