// bstateb.cpp : implementation file
//

#include <afxwin.h>
#include <afxdlgs.h>
#include <afxext.h>
#include "bstateb.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBStateButton

IMPLEMENT_DYNAMIC(CBStateButton, CButton)

CBStateButton::CBStateButton(BOOL bCenter, UINT nID, CWnd *pParent)
{
	subclassed = FALSE;
	if (pParent != NULL) {
		if (SubclassDlgItem(nID, pParent)) {
			subclassed = TRUE;
		}
	}
	
	numStates = 0;
	center = bCenter;
	curStateInd = -1;
}

CBStateButton::~CBStateButton()
{
	UINT i;
	
	if (numStates > 0) {
		i = 0;
		while (i < numStates) {
			delete pictures[i];
			i++;
		}
	}
}

void CBStateButton::Center(BOOL bCenter)
{
	center = bCenter;
	Invalidate(TRUE);
}

void CBStateButton::AttachToButton(UINT nID, CWnd *pParent)
{
	if (SubclassDlgItem(nID, pParent)) {
		subclassed = TRUE;
	}
}

void CBStateButton::AddState(UINT stval, UINT bmid)
{
	DoAddState(stval, bmid);
}

void CBStateButton::AddState(UINT stval)
{
	DoAddState(stval, stval);
}

void CBStateButton::DoAddState(UINT stval, UINT bmid)
{
	CBitmap *newbm;
	UINT i;

	newbm = new CBitmap();
	if (!newbm->LoadBitmap(bmid)) {
		return;
	}
	
	if (numStates == 0) {
		numStates = 1;
		states[0] = stval;
		pictures[0] = newbm;
		return;
	}
	
	i = 0;
	while (i < numStates) {
		if (states[i] == stval) {
			delete pictures[i];
			pictures[i] = newbm;
			return;
		}
		i++;
	}
		
	if (numStates >= _CBSTATEMAX_ - 1) {
		delete newbm;
		return;
	}
	
	states[numStates] = stval;
	pictures[numStates] = newbm; 
	
	numStates++;
}

void CBStateButton::SetStateNumber(UINT stval)
{
	UINT i;
	
	if (numStates == 0) {
		return;
	}
	
	i = 0;
	while (i < numStates) {
		if (states[i] == stval) {
			curStateInd = i;
			Invalidate(TRUE);
			return;
		}
		i++;
	}
}

int CBStateButton::GetStateNumber(void)
{
	if (curStateInd == -1) {
		return -1;
	}
	return states[curStateInd];
}

void CBStateButton::DrawItem(LPDRAWITEMSTRUCT lpDIS)
{
	if (curStateInd == -1 || numStates == 0) {
		return;
	}
	
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	CDC memDC;
	memDC.CreateCompatibleDC(pDC);
	CBitmap* pOld = memDC.SelectObject(pictures[curStateInd]);
	if (pOld == NULL)
		return;     // destructors will clean up

	CRect rect;
	rect.CopyRect(&lpDIS->rcItem);
	
	// TODO: If bitmap is smaller than the area, fill in with the
	// background and center the bitmap if requested
	
	pDC->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(),
		&memDC, 0, 0, SRCCOPY);
	memDC.SelectObject(pOld);
}



