/* HELPDIR.C -- List all internal files with a Windows .HLP file
   WHIFS = Windows Help Internal File System
   bcc helpdir.c
   Pete Davis, June 1993
   See article on Windows .HLP format in Dr. Dobb's Journal, September 1993
*/
#pragma pack(1)
#include <conio.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "whstruct.h"
#define DO_TITLES
#define PAGE_SIZE       1024L        /* 1k pages -- must be long! */

void fail(const char *s) { puts(s); exit(1); }

int main(int argc, char *argv[]) {
   HELPHEADER         HelpHdr;
   WHIFSBTREEHEADER   WHIFSHdr;
   BTREENODEHEADER    WHIFSNode;
   int                file, aPage, c;
   long               WHIFSStart, FileOffset;
   FILE               *HelpFile;
   
   if ((HelpFile=fopen(argv[1], "rb")) == NULL)
       fail("can't open file");
   
   /* Get Help header, go to WHIFS and get WHIFS Header */
   fread(&HelpHdr, sizeof(HelpHdr), 1, HelpFile);
   if (HelpHdr.MagicNumber != HELP_MAGIC)
       fail("not a Windows help file");
   
   fseek(HelpFile, HelpHdr.WHIFS, SEEK_SET);
   fread(&WHIFSHdr, sizeof(WHIFSHdr), 1, HelpFile);
   
   /* WHIFS starts after the WHIFSHdr */
   WHIFSStart = HelpHdr.WHIFS + sizeof(WHIFSHdr);
   
   file=1;
   /* Goto WHIFS Root */
   fseek(HelpFile, WHIFSStart + (PAGE_SIZE * WHIFSHdr.RootPage), SEEK_SET);

   /* Find the first leaf node */
   while (file < WHIFSHdr.NLevels) {
       /* if it's not a leaf, we don't need last 2 fields */
       fread(&WHIFSNode, 4, 1, HelpFile);
       
       /* Find page pointer to first node in index */
       fread(&aPage, sizeof(int), 1, HelpFile);
       fseek(HelpFile, WHIFSStart + (PAGE_SIZE * aPage), SEEK_SET);
       file++;
   }

#if defined(DO_MACROS)
{
	extern void do_macros(FILE *HelpFile, long WHIFSStart);
	do_macros(HelpFile, WHIFSStart);
}
#elif defined(DO_PHRASES)
{
	extern void do_phrases(FILE *HelpFile, long WHIFSStart);
	do_phrases(HelpFile, WHIFSStart);
}
#elif defined(DO_TITLES)
{
    extern void do_titles(FILE *HelpFile, long WHIFSStart);
    do_titles(HelpFile, WHIFSStart);
}
#else
   /* Go through linked list of leaf nodes */
   for (;;) {
       if (! fread(&WHIFSNode, sizeof(WHIFSNode)-2, 1, HelpFile))
		   break;
    
       /* List all entries in node */
       for (file = 1; file <= WHIFSNode.NEntries; file ++) {
          while (c = fgetc(HelpFile))
               putchar(c);
          fread(&FileOffset, sizeof(FileOffset), 1, HelpFile);
          printf("  \t0x%08X\n", FileOffset);
       }
       
       if (WHIFSNode.NextPage == -1)
		  break;
	  else
          fseek(HelpFile,WHIFSStart+(WHIFSNode.NextPage*PAGE_SIZE),SEEK_SET);
   } 
#endif

   return 1;
}

