PROGRAM test1;

{Demonstration program for MTASK 2.0, a simple multi-tasker unit for
Turbo Pascal 5.

Written in November, 1988, and donated to the public domain by:

   Wayne E. Conrad
   2627 North 51st Ave, #219
   Phoenix, AZ  85035
   BBS: (602) 484-9356, 300/1200/2400, 24 hours/day
}



{$F+} {All tasks must be FAR}


USES
  mtask;


{This task is created more than once, so the same code is executed for
multiple tasks.  Since each task has its own stack, each task's local
variables are unique to that task.  Global variables, however, are
shared between tasks.}

PROCEDURE sub_task (VAR p);
VAR
  i        : Integer;
  my_id    : Word;
  parent_id: Word ABSOLUTE p;
BEGIN
  my_id := current_task_id;
  Writeln ('Task ', my_id, ' started by task ', parent_id);
  FOR i := 1 TO 4 DO
    BEGIN
    Writeln ('task ', my_id, ': i = ', i);
    switch_task;
    END;
  Writeln ('Task ', my_id, ' terminating');
END;



{Create a couple of tasks, all doing the same thing (counting & displaying
what they're doing).  Wait for all the tasks to exit before we exit.}

CONST
  tasks_to_create = 2;

VAR
  child_id: Word;
  my_id : Word;
  result  : Word;
  i       : Word;

BEGIN
  Writeln;
  Writeln;
  Writeln ('MaxAvail = ', MaxAvail, '  MemAvail = ', MemAvail);
  my_id := current_task_id;
  FOR i := 1 TO tasks_to_create DO
    BEGIN
    create_task (sub_task, my_id, 1024, child_id, result);
    Writeln ('Task ', my_id, ' created task ', child_id,
     ' with result ', result);
    END;
  REPEAT
    Writeln ('Task ', my_id, ' waiting for other tasks to finish');
    switch_task;
  UNTIL number_of_tasks = 1;
  Writeln ('MaxAvail = ', MaxAvail, '  MemAvail = ', MemAvail);
  Writeln ('Task ', my_id, ' exiting')
END.
