PAGE 50,132
TITLE GETSEC5   -PASCAL FUNCTION TO GET DISK SECTORS
;GETSEC --  Pascal Function to get sectors from disk using DOS's INT 25H.
;			Interfaces to IBM PC Pascal v1.00 Compiler (Microsoft).
;			see DOS Manual, page D-25; and Tech Ref Manual, page A-32.
;***********  (c) Copyright 1982 by Walter H. Rauser   5-16-82   ***********
;{sample of Pascal declarations to use GETSEC}
;function GETSEC(drive  :integer;	{A is 0, B is 1, C is 2, D is 3}
;				 first  :integer;	{first sector # in 0-origin}
;				 numof  :integer; 	{number of sectors to get}
;			 var buffer :dirtype;	{buffer to hold all fetched sectors}
;			 var errorc :integer	{DOS error code}
;					   ):boolean; EXTERN;
;{sample of buffer type for directory sectors, DOS 1.10}
;type dirtype = array[1..112] of record		{112 for DS Drives, 64 for SS}
;					name	[0]:string(8);
;					ext		[8]:string(3);
;					attr   [11]:byte;
;					resvd  [12]:array[1..10] of byte;
;					time   [22]:word;
;					date   [24]:word;
;				 cluster1  [26]:word;
;				 sizelow   [28]:word;
;				 sizehigh  [30]:word;
;				end;	
; frame contents for call from Pascal
; offset len  variable     attributes
; [BP]+14  2  drive			int value parameter
; [BP]+12  2  firstsector 	int value parameter
; [BP]+10  2  numofsectors 	int value param
; [BP]+ 8  2  buffer  			var param
; [BP]+ 6  2  errorcode 	int var param 
; [BP]+ 4  2  CS: 		return address long call
; [BP]+ 2  2  offset  	return address
; [BP]+ 0  2  old frame pointer storage
;
;
MYSEG	SEGMENT	PARA	PUBLIC	'CODE'
		ASSUME CS:MYSEG
		PUBLIC GETSEC
;
GETSEC 	PROC	FAR
		PUSH	BP				;save old frame pointer
		MOV		BP,SP			;set new frame pointer
		MOV		AX,[BP].14		;put drive num into AL
		XOR		AH,AH
		MOV		CX,[BP].10		;num of sectors to fetch
		MOV		DX,[BP]+12		;logical record # of first sec, 0-orgin
		PUSH	DS				;restore before ret
		PUSH	SS				;buffer is in stack segment
		POP		DS				;DS: of buffer (transfer address)
;
		MOV		BX,[BP]+8		;offset of buffer
		INT		25H				;absolute disk read, DOS function.
		JC		ERROR			;error if carry flag set
		MOV		AL,01H			; okay, set AL to return GETSEC=true 
		JMP		DONE
;
ERROR:	MOV		BP,[BP].6		;adr of errorc
		MOV  	[BP],AX			;dos error code
		MOV		AL,00H			; error, set AL to return GETSEC=false
;
DONE:	XOR		AH,AH
		POPF					;int 25H left Flags on stack
		POP		DS				;restore DS
		POP		BP				;restore frame pointer
		RET		10				;clear parameters from stack
GETSEC	ENDP
MYSEG	ENDS
		END 
