(*--------------------------------------------------------------------------*)
(*                 TestSigc --- Test chi-square significance routine        *)
(*--------------------------------------------------------------------------*)

PROGRAM TestSigc;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestSigc                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate chi-square significance routine in PIBSIGS.LBR   *)
(*                                                                          *)
(*   Usage:    This program prompts for a chi-square value and the          *)
(*             corresponding degrees of freedom.  It computes and prints    *)
(*             the significance level for the chi-square.                   *)
(*             the given t value.                                           *)
(*                                                                          *)
(*             To stop the program, enter a negative chi-square value.      *)
(*                                                                          *)
(*   Calls:    SigChi                                                       *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   Chisq:    REAL;
   Df:       REAL;
   P:        REAL;
   Done:     BOOLEAN;

(*$I SIGCONST.PAS *)
(*$I LOGTEN.PAS   *)
(*$I POWTEN.PAS   *)
(*$I ALGAMA.PAS   *)
(*$I GAMMAIN.PAS  *)
(*$I SIGCHI.PAS   *)

BEGIN (* TestSigc *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter Chi-square value and degrees of freedom (-99 to stop): ');
      READLN( Chisq, Df );

      IF ( Chisq > 0.0 ) THEN
         BEGIN
            P     := Sigchi( Chisq, Df );
            WRITELN('Significance of chi-square = ',P:8:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestSigc *).