
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*      April 1991                                                          */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/


/* CHANGES:
 *  19Nov88 ISI: add refer. & cum invoc. counts to FIELD structure.
 *  21Nov88 ISI: add nparms and parmp fields to SOBJ structure.
 *  22Nov88 ISI: New structure def. FilterTE.
 *  28Nov88 ISI: Generalize pseudo-program for case construction.
 *  17Oct89 AKS/RTB: Define Subnet table element
 *    Rel 2.4:
 *  01Nov89 RTB: dblword, MAX_LBYTE defined.
 *  09Nov89 RTB: New components of FIELD
 *    Rel 3.0:
 *  ISI: Add sopc_irefs field and ODV.
 *  ISI: Add List entry to object transfer vectors
 *  DEC/ISI: LFETCH include little-endian transformations
 */
   
   /*
    *  #Include File for Statistical Objects and Packet Parser
    *
    */

    
#define GENERICOP struct generic_operation
#define SOBJ  struct StatObj
#define SOPC  struct StatOpCall    
#define FIELD struct FI_info 
       
     /* Element of field vector */
FIELD {
    short field_fino;    /* Field number */
    short field_parent;    /* Parent's Field number */
    short field_symother; /* Field number of symmetric other, or myself */
    short field_subordno; /* Count of subordinates in FPT */
    char *field_name;     /* Name of field */
    SOPC *field_opcs;   /* Head of pseudo-code chain */
    char *field_ptr;    /* Addr of start of field value */
    int   field_len;    /* Actual length (bytes) of value */
    int   field_maxlen; /* Maximum length (bytes) */
    int   field_dtype;     /* Intrinsic data type of field */
    int   field_equivno;  /* Equivalence partition index */
    int   field_cuminv; /* Cumulative invocation count */
    };
    
    /* Element of Filter Table */
struct FilterTE { 
    int FTE_fino;  /* Field number of subtree */
    int FTE_value; /* Corresponding filter value */
};

    /* Subnet Table Element */
typedef struct Subnet_ Subnet;
struct Subnet_ {
   Subnet *Link;   /* list pointer */
   u_long  Addr;   /* IP address of subnetted network */
   u_long  Mask;   /* Corresponding address mask */
};

     /* Generic Operation Transfer Vector Format */
GENERICOP {     
    SOBJ    *(*make_xx)() ;
    boolean  (*write_xx)() ;
    boolean  (*read_xx)() ;
    void     (*clear_xx)() ;
    void     (*delete_xx)() ;
    void     (*list_xx)() ;
} ;

/*
 *  Define format of operation call (invocation) structure
 *
 */
SOPC  {
    SOPC  *sopc_next;      /*  chain pointer */     
    SOBJ  *sopc_sobjp;     /*  Ptr to Stat Object to be acted on */
    FIELD *sopc_FIptr1;    /*  Field ptr 1 for Write() invocation */
    FIELD *sopc_FIptr2;    /*  Field ptr 2 for Write() invocation */
    SOPC  *sopc_indir;     /*  Indirect ptr: earlier filter result */
    short  sopc_rc;        /*  Return code */
    short  sopc_AtFIno;    /*  Field number for invocation */
    char   sopc_irefs;     /*  Count of indirections pointing here... */
    char   sopc_flags;     /*  Compilation flags  */
#define FLAG_SELECT 0x01 /* Mark Select invocation during compilation */

    short  sopc_ncases;      /* Number of sublists that follow... */
                             /*  (0 for recorder, 2 for if filter.) */
    SOPC  *sopc_sublist[2];  /* Array of sub-lists (generally [ncases]) */
/* During compilation of boolean expressions, mark sopc_sublist[] words using
    the following integers: */
#define F_STUB  1
#define T_STUB  2
#define MAX_STUB 2 
   } ; 
   
#define sopc_FIptr  sopc_FIptr1
 
    /*
     *  Define return values from Write operations
     */
#define WRRET_TRUE   1   /* from filter object */
#define WRRET_FALSE  0   /* from filter object */
#define WRRET_OK     0   /* from recording object */

    /* 
      *  Every Object Area begins with the following structure:
      */
SOBJ  {
    SOBJ *sob_next;      /* All-object chain */    
    char  sob_opccnt;    /* Count of SOPC's pointing to object */
    char  sob_lock;      /* Write lock */
    char  sob_flags;
#define CLEAR_REQ 0x1
    char  sob_dum1;

    int   sob_nparms;    /* # long words in parm list copy */
    u_long *sob_parmp;   /* Ptr to allocated parm list copy */
#define MAXSVNPARM 64    /* Maximum #long words save in parm list copy */
    
    GENERICOP sob_genop; /* Transfer vector for operations on object */
    char  *sob_name;     /* Name of object */
    int    sob_class;    /* Object class */
    struct Obj_state sob_object;    /* Standard state info */
    
} ;

#define  sob_dtype     sob_object.datatype    
#define  sob_dtype2    sob_object.datatyp2    
#define  sob_dleng     sob_object.dleng           
#define  sob_dleng2    sob_object.dleng2           
#define  sob_currtime  sob_object.currtime 
#define  sob_maketime  sob_object.maketime 
#define  sob_cleartime sob_object.cleartime
#define  sob_totalno   sob_object.totalno
#define  sob_orphans   sob_object.orphans

    /*
     *   union -- to look at value (pair) as either byte string or 
     *       as series of 32-bit words.
     */    
union v_union {  /* Overlay value string with four u_long words */
    char v_byte[2*MAX_DLENG];
    struct {
            u_long v_ul1;
            u_long v_ul2;
            u_long v_ul3;
            u_long v_ul4;
    } v_ul;
} ;

#define WORD1(x) ((union v_union *)(x))->v_ul.v_ul1
#define WORD2(x) ((union v_union *)(x))->v_ul.v_ul2
#define WORD3(x) ((union v_union *)(x))->v_ul.v_ul3
#define WORD4(x) ((union v_union *)(x))->v_ul.v_ul4
#define ZERO_UNION(up)  (up)->v_ul.v_ul1 = (up)->v_ul.v_ul2 = 0
#define SUM_UNION(up)   (up)->v_ul.v_ul1 + (up)->v_ul.v_ul2
#define ZERO_UN2(up)  (up)->v_ul.v_ul3 = (up)->v_ul.v_ul4 = 0
#define SUM_UN2(up)   (up)->v_ul.v_ul3 + (up)->v_ul.v_ul4 

    /* Definitions for doubly-linked lists */
struct FBlinks {  /* (must be at offset +0 in structure) */
    struct FBlinks *FB_Fp;  /* Forward pointer */
    struct FBlinks *FB_Bp;  /* Backward pointer */
};

  /* Macro to Insert element Q after element P, in doubly-linked list. 
   */ 
#define FBins(Q, P) /* struct FBlinks *P, *Q; */  \
    { (Q)->FB_Fp = (P)->FB_Fp; (P)->FB_Fp = (Q); \
      (Q)->FB_Bp = (P); if ((Q)->FB_Fp)  (Q)->FB_Fp->FB_Bp = (Q); }

   /* Macro to Remove element Q from doubly-linked list.
    */
#define FBrem(Q)  /* struct FBlinks *Q;     */ \
    { if ((Q)->FB_Bp)  (Q)->FB_Bp->FB_Fp = (Q)->FB_Fp; \
      if ((Q)->FB_Fp)  (Q)->FB_Fp->FB_Bp = (Q)->FB_Bp; }
     
    /* Macro to fetch value of n bytes from address p */
#define LFETCH(p, n) ((n)==1)? *(u_char *)p : ((n)==2)? ntohs(*(u_short *)p ): \
   ntohl(* (u_long *) p )     
   
   /* Macro to compute offset of first byte of parameter value of
    *  length n.  Parameters of 4 bytes or less are right-justified,
    *  longer ones are left-justified.
    */
#define PARMALIGN(n)  (((n) > sizeof(long))? 0: sizeof(long)-(n))     
#define ALIGN(x)  ((~3)&((int)(x)+3))
#define Align4(x)  (3 - ((strlen(x)+3)&3))
#define MAX_LBYTE  0x01000000    

extern SOBJ *SOBJ_list ;   /* Head of all-object chain */
extern char *SOBJ_error ;
extern char  Error_msg[];
extern char *class_name[];
extern long  CurrTime ;    /* Current time, in secs since... */
extern int   TTYfd;
extern int   debug, Xdebug;
extern int   tersemode;

    /* XDR definitions */
#include <rpc/rpc.h>
extern  XDR W_xdr;

#define ISTTY(x)  ((x) == NULL)

struct dblword {  /* double word -- used for total byte counts */
   u_long H;
   u_long L;
};

struct addr_and_mask {  /* IP address, mask pair */
   u_long addr;
   u_long mask;
};
#define subnet_parm addr_and_mask
#define restrict_parm addr_and_mask

struct FOparmB {  /* struct needed for parm to ReadFO()  -- two double-prec
                   *  byte counts
                   */
    struct dblword defaultB;
    struct dblword totalB;
}; 

    /* Output Dope Vector */
struct ODV {
    int   odv_file;   /* file descriptor for output */
    char *odv_cp;     /* addr to place output */
    int   odv_left;   /* space left in buffer */
};
