/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The benchmark input/output functions.
 */

/*
 * Generic benchmark io routines: (returns NOTOK on failure)
 *	io_open(iohdl: iohdl_t *; direction: direction_t, bufsize: long)
 *	io_destroy(iohdl: iohdl_t *)		(close and destroy handle)
 *	io_put(iohdl: iohdl_t *; amount: int)	(for destination only)
 *	io_get(iohdl: iohdl_t *; amount: int)	(for source only)
 * 
 *	iohdl_setitemsize(iohdl: iohdl_t *; val: int)
 *
 * Get the size of the io object - the size of the file if IOT_FILE
 * (returns SIZE_UNLIMIT if not known as for [virtual] memory and nonexisting
 * files)
 *	io_size(iohdl: iohdl_t *)		
 *
 */

typedef enum {source, destination} direction_t;

typedef struct {
    int		io_tag;
    direction_t	io_direction;
    int		io_itemsize;
    char 	*io_buffer;
    long	io_bufsize;
    char	*io_bufptr;
    int		(*io_open)();
    int		(*io_put)();
    int		(*io_get)();
    int		(*io_destroy)();
    int		(*io_size)();
    char	*io_filename;	/* only if IOT_FILE */
    int		io_fid;	/* only if IOT_FILE */
} iohdl_t;

#define NULLIO (iohdl_t *)NULL

    
#define IOT_MEM		0
#define IOT_VM		1
#define IOT_FILE	2

/* Routines */
extern iohdl_t *iohdl_create();
		/* (tag: int; filename: char *) */
extern iohdl_print();
		/* (iohdl: iohdl_t *) */


#define iohdl_isfile(iohdl)	((iohdl)->io_tag == IOT_FILE)
#define iohdl_isvm(iohdl)	((iohdl)->io_tag == IOT_VM)
#define iohdl_ismem(iohdl)	((iohdl)->io_tag == IOT_MEM)
#define iohdl_setitemsize(iohdl, val)	((iohdl)->io_itemsize = val)

#define SIZE_UNLIMIT 	-2
