/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks
 */

/* System headers */

#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <sys/time.h>
#ifdef BSD
#include <sys/resource.h>
#include <sys/wait.h>
#include <strings.h>
#endif BSD
#ifdef SYSV
#include <sys/times.h>
#include <string.h>
#endif SYSV
#include <ctype.h>

#ifdef DELAY
#undef DELAY
#endif

/* SPIMS files */

#include <error.h>
#include <metrics.h>
#include <statistics.h>
#include <symbol.h>
#include <spec.h>
#include <random.h>
#include <bio.h>
#include <convert.h>
#include <state.h>

/* Use functions in malloc.c */
#ifdef XMALLOC_FILE
/*
 * These DON'T work for some protocols; if there is a
 * char *malloc();
 * in a protocol specific include file they will BREAK!
*/   
#define malloc(size)	xmalloc(size, __FILE__, __LINE__)
#define free(ptr) 	xfree(ptr, __FILE__, __LINE__)

#else
#ifdef XMALLOC

/* Always works, but produces less information */
/* The above remark is not completely true...
 * ISODE tsap routines returns data that is malloced (by malloc)
 * inside the library, but will be freed by xfree.
 * /Peter					
 */

#define malloc		xmalloc
#define free	 	xfree
#endif
#endif

/* Standard constants */

#define OK	0
#define NOTOK	-1
#define DONE	-2

#define NULL	0
#define NULLP NULL
#define NULLCP (char *)NULL

/* Macros */
    
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define SQR(x) ((x) * (x))

/*
 * This global will signal the benchmark procedure that so
 * that it will terminate prematurely and report its results.
 * It's set when a SIGUSR2 signal is received.
 */
extern int interupted;


#define MAX_ITERATIONS		1000000000	/* will run 'forever' */

