/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for resource metrics
 */

/*
 * The resources being measured are:
 *	elapsed time (start and stop time)
 *	CPU timer
 *	CPU time in user mode
 *	CPU time in system mode
 *
 *	Data sent
 *	Data received
 *
 *	messages sent on sockets
 *	messages received on sockets
 *	packets sent on the interfaces (for all processes on the machine)
 *	packets received
 *
 *	signals received
 *
 * To indicate anomalious behavior:
 *	block output operation
 *	block input operations
 *	page faults
 *	swaps
 *	context switches
 *	memory usage
 *	exit status - interupted or normal
 */



typedef struct {
    long	   mt_ipackets, mt_opackets;
    double         mt_delay;			/* total delay in seconds */
    long	   mt_datasent, mt_datarcvd;
    int		   mt_exit;
    struct timeval mt_starttime,
    		   mt_stoptime;
#ifdef SYSV
    struct timeval	mt_stime;
    struct timeval	mt_utime;
#endif SYSV
#ifdef BSD
    struct rusage  mt_usage;
#define mt_utime 	mt_usage.ru_utime	/* user time used */
#define mt_stime 	mt_usage.ru_stime	/* system time used */
#define mt_maxrss	mt_usage.ru_maxrss
#define mt_ixrss	mt_usage.ru_ixrss	/* integral shared memory size */
#define mt_idrss	mt_usage.ru_idrss	/* integral unshared data " */
#define mt_isrss	mt_usage.ru_isrss	/* integral unshared stack " */
#define mt_minflt	mt_usage.ru_minflt	/* page reclaims */
#define mt_majflt	mt_usage.ru_majflt	/* page faults */
#define mt_nswap	mt_usage.ru_nswap	/* swaps */
#define mt_inblock	mt_usage.ru_inblock	/* block input operations */
#define mt_oublock	mt_usage.ru_oublock	/* block output operations */
#define mt_msgsent	mt_usage.ru_msgsnd	/* messages sent */
#define mt_msgrcvd	mt_usage.ru_msgrcv	/* messages received */
#define mt_nsignals	mt_usage.ru_nsignals	/* signals received */
#define mt_nvcsw	mt_usage.ru_nvcsw      /* voluntary context switches */
#define mt_nivcsw	mt_usage.ru_nivcsw	/* involuntary " */
#endif BSD
} metrics_t;

#define NULLMT (metrics_t *)NULL
    
#define MT_UNSUPP	-1;		/* Unsupported metric */

/* Exit flags */
#define MT_EXIT_OK	0
#define MT_EXIT_INT	1	/* max time for benchmark expired */
#define MT_EXIT_KILLED	2

/*
 * Routines
 */
#define MetricsAddDelay(mt, val) 	((mt)->mt_delay += (val))    
#define MetricsAddDatasent(mt, val) 	((mt)->mt_datasent += (val))    
#define MetricsAddDatarcvd(mt, val) 	((mt)->mt_datarcvd += (val))    


extern StartMeasurements();
extern StopMeasurements();


extern int  Metrics2Exit();
extern long Metrics2Elapsed();		/* Returns ms */
extern double Metrics2Starttime();	/* Returns ms UTC */
extern double Metrics2Stoptime();		/* Returns ms UTC */
extern long Metrics2Cputime();
extern long Metrics2Usertime();
extern long Metrics2Systime();
extern long Metrics2Sentdata();
extern long Metrics2Recvddata();
extern long Metrics2Sentmsg();
extern long Metrics2Recvmsg();
extern long Metrics2Recvsignals();
extern long Metircs2Opackets();
extern long Metrics2Ipackets();
extern long Metrics2Oblock();
extern long Metrics2Iblock();
extern long Metrics2Pfio();
extern long Metrics2Pfrecl();
extern long Metrics2Swaps();
extern long Metrics2Ivcsw();
extern long Metrics2Vcsw();
extern long Metrics2Memusage();
extern double Metrics2Delay();



