/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Symbol table definitions. The symbol table is used by the lexical analyzer
 * to reconizing tokens (reserved words) and by the parser to recognize
 * distribution and benchmark names.
 */

struct symbol {
    int se_tag;
    char *se_name;
    union {
	int seu_token;
	struct {
    	    int (*client_proc)();
	    int (*server_proc)();
	} seu_proc;
    } seu;
#define se_token	seu.seu_token
#define se_client_proc	seu.seu_proc.client_proc
#define se_server_proc	seu.seu_proc.server_proc
};
#define NULLSE	(struct symbol *)NULL

    
/* Tags */
#define SET_TOKEN	1	/* Just a token */
#define SET_DIST	2	/* A distribution function */
#define SET_BASIC	3	/* Basic benchmark routine */
#define SET_COMP	4	/* Composite benchmark routine */

/* Used by the scanner */
#define symbol_istoken(se) 	((se)->se_tag == SET_TOKEN)

#define symbol_isdist(se) 	((se)->se_tag == SET_DIST)
#define symbol_isbasic(se) 	((se)->se_tag == SET_BASIC)
#define symbol_iscomp(se) 	((se)->se_tag == SET_COMP)

/* Routines */
extern symtab_init();
extern symtab_print();

extern struct symbol *symbol_lookup();
		/* (s: char *) */
extern char *symbol_lookup_token();
		/* (token: int) */
extern symbol_enter();
/* (s: char *; tag: int; token: int; client_proc, server_proc: (*int)()) */
extern symbol_print();
		/* (se: struct symbol *) */
extern char*token2name();
		/* (token: int) */


#define symbol_name(se)		((se)->se_name)
#define symbol_client_proc(se)	((se)->se_client_proc)
#define symbol_server_proc(se)	((se)->se_server_proc)
