/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring connection setup and taredown
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

int conn_disc_ch(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;
    TIMING_VARIABLES(0);
    TIMING_VARIABLES(1);
    channel_t 		ch;

    TIMING_INITIATE(0);
    TIMING_INITIATE(1);

    mprintf("conn_disc_ch(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    INITIATOR_BEFORE_START;

    CreateChannel(addr, &ch, &error);
    if (failed(&error)) {
	report_error(&error, "CreateChannel");
	return NOTOK;
    }
    
    StartMeasurements(mt);

    INITIATOR_AFTER_START;

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	ConnChannel(ch, &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "ConnChannel");
	    return NOTOK;
	}

	TIMING_DELAY(0);
	
	DiscChannel(ch, &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "DiscChannel");
	    return NOTOK;
	}
	if (interupted)
	    break;
	TIMING_DELAY(1);
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    DestroyChannel(ch, &error);
    if (failed(&error) && !interupted) {
	report_error(&error, "DestroyChannel");
	return NOTOK;
    }
    
    return OK;
} /* conn_disc_ch */
