/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring connection setup and taredown
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>


int proccall(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;

    mprintf("proccall(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    INITIATOR_BEFORE_START;
    
    StartMeasurements(mt);

    INITIATOR_AFTER_START;

    procedure(iterations);
	
    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    return OK;
} /* proccall */

static procedure(n)
     register int n;
{
  if (n != 0)
    procedure(n-1);
}
      
