/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * NULL level specific code
 */

#include <general.h>
#include <protospec.h>
#include "../protoaddrs/nulladdr.h"

static char nullstr[] = "";
static struct address_t nulladdr = {0};

struct address_t *str2address(str,len)
    char *str;
    int *len;
{
    struct address_t *addr;
    
    *len = 0;	/* 0 bytes used */
    addr = (struct address_t *)malloc(sizeof(struct address_t));
    if (addr == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "str2address");
	return NULL;
    }
    *addr = nulladdr;
    return addr;
}


char *address2str(addr,len)
    struct address_t *addr;
    int *len;
{
    char *str;
    
    *len = 0; /* string length */
    str = (char *)malloc(1);
    if (str == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "address2str");
	return NULL;
    }
    strcpy(str, nullstr);
    return str;
}


struct address_t *addresscopy(addr)
    struct address_t *addr;
{
    struct address_t *addr2;
    
    addr2 = (struct address_t *)malloc(sizeof(struct address_t));
    if (addr2 == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "addresscopy");
	return NULL;
    }
    *addr2 = *addr;
    return addr2;
}

void address_free(addr)
    struct address_t *addr;
{
    if (addr != NULL) { /* must check since CreateServer does nothing */
	free((char *)addr);
    }
}
