/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks on the FTP level 
 */

#ifndef _FTP_
#define _FTP_

#ifndef __SOCKET__
#define __SOCKET__
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif __SOCKET__


typedef struct {
    FILE *control_in;
    FILE *control_out;
    FILE *data;
} channel_t;

struct server_t {
    int sock;		/* a socket being listened on */
};

#include "../protoaddrs/portaddr.h"

/*
 * Error handling
 */

typedef int error_t;
#define failed(errind)	(*errind == NOTOK)

#define report_error(errind,str)	ftp_report_error(errind,str)


#define InitClient()		{};

#define ConnRequest(addr,a_ch,errind) \
    				ftp_conn_request(addr, a_ch, errind)
#define DiscRequest(ch, errind) \
    				ftp_disc_request(ch, errind)
#define AwaitConnInd(serverp, a_ch, errind) \
			    	ftp_await_conn_ind(serverp, a_ch, errind)

#define AwaitDiscInd(ch, errind) \
    				ftp_await_disc_ind(ch, errind)



#define CreateServer(aa_server, aa_addr, errind) \
    				ftp_create_server(aa_server, aa_addr, errind)
#define DestroyServer(a_server, errind) \
    				ftp_destroy_server(a_server, errind)

#ifdef FTP_ASCII
#define DataRequest(channel,buffer,amount, errind) \
{ register char *from, *end; \
  pprintf("DataRequest(%d, %d bytes)\n", fileno(channel.data), amount); \
  *errind = OK; \
  for (from = buffer, end = from + amount; from < end; from++) { \
    if (*from == '\n') { \
      if (ferror(channel.data)) { \
	*errind = NOTOK; \
	break; \
      } \
      putc('\r', channel.data); \
    } \
    putc(*from, channel.data); \
    if (*from == '\r') { \
      putc('\0', channel.data); \
    } \
  } \
}

#define AwaitDataIndication(channel, buffer, amount, errind)	\
{ register char *to, *end; \
  register int c; \
  pprintf("AwaitDataInd(%d, %d bytes)\n", fileno(channel.data), amount); \
  *errind = OK; \
  for (to = buffer, end = to + amount; to < end; ) { \
    if ((c = getc(channel.data)) == EOF) { \
	*errind = NOTOK; \
	break; \
    } \
    if (c == '\r') { \
      if ((c = getc(channel.data)) != '\n') { \
        if (ferror(channel.data)) { \
          *errind = NOTOK; \
	  break; \
        } \
        *to++ = '\r'; \
      } \
      if (c == '\0') { \
	continue; \
      } \
    } \
    *to++ = c; \
  } \
}

#else FTP_ASCII

#define DataRequest(channel,buffer,amount, errind) \
{ pprintf("DataRequest(%d, %d bytes)\n", fileno(channel.data), amount); \
  if (write(fileno(channel.data), buffer, amount) == NOTOK) \
      *errind = NOTOK; \
  else	\
      *errind = OK;					\
  }

/* problem when length bytes aren't read! */
#define AwaitDataIndication(channel, buffer, amount, errind)	\
{ 								\
      int left = amount;	 				\
      int got;							\
  								\
      pprintf("AwaitDataInd(%d, %d bytes)\n", fileno(channel.data), amount); \
      *errind = OK;						\
      while (left > 0) {					\
	  got = read(fileno(channel.data), buffer, left);	\
	  if (got < 0) { /* error */				\
	      *errind = NOTOK;					\
	      break;						\
	  } 							\
	  if (got == 0) { /* end-of-file */			\
	      *errind = NOTOK;					\
	      break;						\
	  }							\
	  left -= got;						\
      }								\
}
#endif ! FTP_ASCII

#define BulkGetDataReq		DataRequest
#define BulkPutDataReq  	DataRequest
#define BulkGetAwaitDataInd	AwaitDataIndication
#define BulkPutAwaitDataInd	AwaitDataIndication

/*
 * HACK --- the address of ch is passed --- won't always compile 
 */

#define BulkGetStart(ch, errind) \
	ftp_start_bulk_get(&ch, errind)

#define AwaitBulkGetStart(ch, errind)	\
	ftp_await_start_bulk_get(&ch, errind)

#define BulkGetStop(ch, errind) 	\
    (void)fclose(ch.data), ch.data = NULL, *errind = OK
    
#define AwaitBulkGetStop(ch, errind)	\
	ftp_await_bulk_stop(&ch, errind)



#define BulkPutStart(ch, errind)	\
	ftp_start_bulk_put(&ch, errind)

#define AwaitBulkPutStart(ch, errind)\
	ftp_await_start_bulk_put(&ch, errind)

#define BulkPutStop(ch, errind)	\
    (void)fclose(ch.data), ch.data = NULL, *errind = OK

#define AwaitBulkPutStop(ch, errind)	\
	ftp_await_bulk_stop(&ch, errind)
    
#endif _FTP_
