/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/* internet.c - TCP/IP abstractions */

#ifndef	lint
static char *rcsid = "$Header: /usr/share/src/nuada2/SpimsDir/new/protocols/RCS/internet.c,v 1.4 89/06/06 17:21:47 erikn Exp $";
#endif

/* 
 * $Header: /usr/share/src/nuada2/SpimsDir/new/protocols/RCS/internet.c,v 1.4 89/06/06 17:21:47 erikn Exp $
 *
 *
 * $Log:	internet.c,v $
 * Revision 1.4  89/06/06  17:21:47  erikn
 * Copyright added
 * 
 * Revision 1.3  88/07/07  15:33:37  erikn
 * *** empty log message ***
 * 
 * Revision 1.2  88/07/05  11:20:59  erikn
 * Excluded some code
 * 
 * Revision 1.1  88/06/22  16:20:16  erikn
 * Initial revision
 * 
 * Revision 4.2  87/12/28  18:18:08  mrose
 * clean-up
 * 
 * Revision 4.1  87/12/28  13:30:44  mrose
 * TWG
 * 
 * Revision 4.0  87/10/12  16:03:48  mrose
 * Release 3.0
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <general.h>	/* SPIMS */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <isode/general.h>
#include <isode/manifest.h>

#ifdef notdef
#include <isode/network.h>
#endif notdef
#include <isode/internet.h>
/*  */

int	start_tcp_server (sock, backlog, opt1, opt2)
struct sockaddr_in *sock;
int	backlog,
	opt1,
	opt2;
{
    register int    port;
    int     sd;

    pprintf("start_tcp_server(%d:0x%x:%d, %d, %d, %d)\n",
		sock->sin_family, sock->sin_addr.s_addr,
		sock->sin_port, backlog, opt1, opt2);

    /* BUG FIX */
    bzero(sock->sin_zero, sizeof (sock->sin_zero));
    
    sock->sin_addr.s_addr = 0;
    
    if ((sd = socket (AF_INET, SOCK_STREAM, 0)) == NOTOK) {
	eprintf(EF_SYSCALL, "FTAM", "socket", "start_tcp_server",
		getsyserr());
	return NOTOK;
    }

    if (sock -> sin_port != 0) {
	pprintf("start_tcp_server - have a port\n");
	if (bind (sd, (struct sockaddr *) sock, sizeof *sock) != NOTOK)
	    goto got_socket;

	eprintf(EF_SYSCALL, "FTAM", "bind", "start_tcp_server",
		getsyserr());
	(void) close (sd);
	return NOTOK;
    }

    for (port = IPPORT_RESERVED;; port++) {
	sock -> sin_port = htons ((u_short) port);

	if (bind (sd, (struct sockaddr *) sock, sizeof *sock) != NOTOK)
	    break;

	eprintf(EF_SYSCALL, "FTAM", "bind-2", "start_tcp_server",
		getsyserr());
	switch (errno) {
	    case EADDRINUSE: 
		continue;

	    case EADDRNOTAVAIL: 		
		eprintf("start_tcp_server: %d:0x%x:%d NOT AVAIL\n",
			sock->sin_family, sock->sin_addr.s_addr,
			sock->sin_port);
		continue;
		
	    default: 
		eprintf("start_tcp_server: %d:0x%x:%d => %d\n",
			sock->sin_family, sock->sin_addr.s_addr,
			sock->sin_port, errno);
		(void) close (sd);
		return NOTOK;
	}
    }

got_socket: ;
    pprintf("start_tcp_server - setting options\n");
    if (opt1)
	(void) setsockopt (sd, SOL_SOCKET, opt1, NULLCP, 0);
    if (opt2)
	(void) setsockopt (sd, SOL_SOCKET, opt2, NULLCP, 0);

    (void) listen (sd, backlog);

    return sd;
}


extern int  errno;

/*    Berkeley UNIX: 4.2 */


int	start_tcp_client (sock, priv)
struct sockaddr_in *sock;
int	priv;
{
    register int    port;
    int     sd;

    pprintf("start_tcp_client(0x%x, %d)\n", sock, priv);

    if ((sd = socket (AF_INET, SOCK_STREAM, 0)) == NOTOK)
	return NOTOK;

    if (sock == NULL)
	return sd;

    for (port = IPPORT_RESERVED - priv;; priv ? port-- : port++) {
	sock -> sin_port = htons ((u_short) port);

	if (bind (sd, (struct sockaddr *) sock, sizeof *sock) != NOTOK)
	    return sd;

	switch (errno) {
	    case EADDRINUSE: 
		if (!priv || (port >= IPPORT_RESERVED / 2))
		    continue;	/* else fall */

	    case EADDRNOTAVAIL: 
	    default: 
		(void) close_tcp_socket (sd);
		return NOTOK;
	}
    }
}

/*  */

int	join_tcp_client (fd, sock)
int	fd;
struct sockaddr_in *sock;
{
    int     len = sizeof *sock;

    pprintf("join_tcp_client(%d, 0x%x)\n", fd, sock);
    
    return accept (fd, (struct sockaddr *) sock, &len);
}


/*    GETHOSTENT PLUS */

static char *empty = NULL;
#ifdef	BIND
static char *addrs = NULL;
#endif


struct hostent *gethostbystring (s)
char   *s;
{
    register struct hostent *h;
#ifndef	DG
    static u_long iaddr;
#else
    static struct in_addr iaddr;
#endif
    static struct hostent   hs;

#ifndef	DG
    if ((iaddr = inet_addr (s)) == NOTOK)
#else
    iaddr = inet_addr (s);
    if (iaddr.s_addr == NOTOK)
#endif
	return gethostbyname (s);

    h = &hs;
    h -> h_name = s;
    h -> h_aliases = &empty;
    h -> h_addrtype = AF_INET;
    h -> h_length = sizeof (iaddr);
#ifdef	BIND
    h -> h_addr_list = &addrs;
#endif
    h -> h_addr = (char *) &iaddr;

    return h;
}

