/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks on the SUN RPC level
 *
 * SUNRPC_UDP if on top of udp
 * SUNRPC_TCP if on top of tcp
 *	(These should be defined in the Makefile)
 */

#ifndef _SUNRPC_
#define _SUNRPC_

#ifndef __SOCKET__
#define __SOCKET__
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif __SOCKET__

#include <rpc/rpc.h>

#ifndef __NETDB__
#define __NETDB__
#include <netdb.h>
#endif __NETDB__


#define NullProc 0
#define RPCCallProc 1
#define BulkGetStartProc 2
#define BulkGetStopProc 3
#define ConnIndProc 4
#define SendDataProc 5
#define ReceiveDataProc 6
#define BulkPutStartProc 7
#define BulkPutStopProc 8

#define EightK 8192

extern struct timeval RPC_total_time;
extern int xdr_byte_arr();

/* A channel (and a server) is a socket number, */
/* a client pointer, a xprt pointer and a xprt pointer */
/* transferred from RPCAwaitCallInd() to RPCReturn(). */

struct channel_structure {
    int socket;
    CLIENT *clientp;
    SVCXPRT *xprtp;
    SVCXPRT *rpc_xprtp;
};

typedef struct channel_structure  channel_t;
#define server_t channel_structure

#include "../protoaddrs/sunrpcaddr.h"


/*
 * Error handling
 */

typedef int error_t;
#define failed(errind)	(*errind < OK)

#define report_error(errind,str)	sunrpc_report_error(errind,str)


#define InitClient()

#define ConnRequest(addr,a_ch,errind) \
    				sunrpc_conn_request(addr, a_ch, errind)
#define DiscRequest(ch, errind) \
    				sunrpc_disc_request(ch, errind)
extern int conn_ind_flag;
#define AwaitConnInd(serverp, a_ch, errind) \
                pprintf("AwaitConnInd()\n"); \
                *(a_ch) = *serverp; /* struct copy */ \
                wait_for_flag(conn_ind_flag, errind); \
                pprintf("<AwaitConnInd\n")
#define AwaitDiscInd(ch, errind) \
                                *(errind) = OK

#define CreateServer(aa_server, aa_addr, errind) \
    				sunrpc_create_server(aa_server, aa_addr, errind)
#define DestroyServer(a_server, errind) \
    				sunrpc_destroy_server(a_server, errind)


typedef struct { char *chars; int length; } byte_arr_type;

extern int receive_data_flag;
extern byte_arr_type receive_data_buf;
extern int send_data_flag;
extern byte_arr_type send_data_buf;

#define BulkPutDataReq(channel, buffer, amount, errind) \
{ \
  byte_arr_type buf; \
 \
  pprintf("BulkPutDataReq(%#x, %#x:%d, %#x)\n", \
	  channel, buffer, amount, errind); \
  buf.chars = buffer; \
  buf.length = amount; \
  clnt_call((channel).clientp, ReceiveDataProc, xdr_byte_arr, &buf, \
	      xdr_void, NULL, RPC_total_time); \
  pprintf("<BulkPutDataReq\n"); \
}

#define BulkGetDataReq(channel, buffer, amount, errind) \
{ \
  pprintf("BulkGetDataReq(%#x, %#x:%d, %#x)\n", \
	  channel, buffer, amount, errind); \
  send_data_buf.chars = buffer; \
  send_data_buf.length = amount; \
  wait_for_flag(send_data_flag, errind); \
  pprintf("<BulkGetDataReq\n"); \
}

#define BulkGetAwaitDataInd(channel, buffer, amount, errind)	\
{ \
  byte_arr_type buf; \
 \
  pprintf("BulkGetAwaitDataInd(%#x, %#x:%d, %#x)\n", \
	  channel, buffer, amount, errind); \
  buf.chars = buffer; \
  buf.length = amount; \
  clnt_call((channel).clientp, SendDataProc, xdr_void, NULL, \
	      xdr_byte_arr, &buf, RPC_total_time); \
  pprintf("<BulkGetAwaitDataInd\n"); \
}

#define BulkPutAwaitDataInd(channel, buffer, amount, errind)	\
{ \
  pprintf("BulkPutAwaitDataInd(%#x, %#x:%d, %#x)\n", \
	  channel, buffer, amount, errind); \
  receive_data_buf.chars = buffer; \
  receive_data_buf.length = amount; \
  wait_for_flag(receive_data_flag, errind); \
  pprintf("<BulkPutAwaitDataInd\n"); \
}


#define RRSendRequest 		BulkPutDataReq
#define RRAwaitResponseInd	BulkGetAwaitDataInd
#define RRAwaitRequestInd	BulkPutAwaitDataInd
#define RRSendResponse		BulkGetDataReq

/*
 * Synchronize with the sender to avoid buffering anomalies (the
 * sender starting before this receiver and the receiver just retrieves
 * data from the buffers!)
 */

extern struct timeval RPC_total_time;
#define BulkGetStart(ch, errind) \
  *errind = ((int) clnt_call((ch).clientp, BulkGetStartProc, xdr_void, NULL, \
			     xdr_void, NULL, RPC_total_time) != 0 ? NOTOK : OK)

extern int start_bulkget_flag;
#define AwaitBulkGetStart(ch, errind)	\
    wait_for_flag(start_bulkget_flag, errind)

#define BulkGetStop(ch, errind)	\
  *errind = ((int) clnt_call((ch).clientp, BulkGetStopProc, xdr_void, NULL, \
			     xdr_void, NULL, RPC_total_time) != 0 ? NOTOK : OK)

extern int stop_bulkget_flag;
#define AwaitBulkGetStop(ch, errind)	\
    wait_for_flag(stop_bulkget_flag, errind)


#define BulkPutStart(ch, errind) \
  *errind = ((int) clnt_call((ch).clientp, BulkPutStartProc, xdr_void, NULL, \
			     xdr_void, NULL, RPC_total_time) != 0 ? NOTOK : OK)

extern int start_bulkput_flag;
#define AwaitBulkPutStart(ch, errind)	\
    wait_for_flag(start_bulkput_flag, errind)

#define BulkPutStop(ch, errind)	\
  *errind = ((int) clnt_call((ch).clientp, BulkPutStopProc, xdr_void, NULL, \
			     xdr_void, NULL, RPC_total_time) != 0 ? NOTOK : OK)

extern int stop_bulkput_flag;
#define AwaitBulkPutStop(ch, errind)	\
    wait_for_flag(stop_bulkput_flag, errind)
/*  */

#define QueryCall(addrp, srcbuf, srclen, dstbuf, dstlen, errind) \
{ \
  channel_t ch; \
 \
  ConnRequest(addrp, &ch, errind); \
  if (!failed(errind)) { \
    RPCCall(ch, srcbuf, srclen, dstbuf, dstlen, errind); \
    if (!failed(errind)) { \
      DiscRequest(ch, errind); \
    } \
  } \
}

#define QueryAwaitCallInd(serverp, dstbuf, dstlen, chp, errind) \
{ \
    AwaitConnInd(serverp, chp, errind); \
	if (!failed(errind)) { \
	RPCAwaitCallInd(*(chp), dstbuf, dstlen, errind); \
    } \
}

#define QueryReturn(ch, srcbuf, srclen, errind) \
{ \
    RPCReturn(ch, srcbuf, srclen, errind); \
    if (!failed(errind)) { \
	AwaitDiscInd(ch, errind); \
    } \
}

#define RPCCall(ch, srcbuf, srclen, dstbuf, dstlen, errind) \
{ \
  enum clnt_stat status; \
  byte_arr_type send, recv; \
 \
  pprintf("RPCCall(%#x, %#x:%d, %#x:%d, %#x)\n", \
	  ch, srcbuf, srclen, dstbuf, dstlen, errind); \
  send.chars = srcbuf; \
  send.length = srclen; \
  recv.chars = dstbuf; \
  recv.length = dstlen; \
  status = clnt_call((ch).clientp, RPCCallProc, xdr_byte_arr, &send, \
		     xdr_byte_arr, &recv, RPC_total_time); \
  *errind = ((int) status != 0 ? NOTOK : OK); \
  if (failed(errind)) { \
    report_error(errind, "RPCCall"); \
    clnt_perror((ch).clientp, "RPCCall"); \
  } \
  pprintf("<RPCCall\n"); \
}

extern byte_arr_type call_ind_buf;
extern int call_ind_flag;
extern SVCXPRT *call_ind_xprt;

#define RPCAwaitCallInd(ch, dstbuf, dstlen, errind) \
{ \
  pprintf("RPCAwaitCallInd(%#x, %#x:%d, %#x)\n", \
	  ch, dstbuf, dstlen, errind); \
  call_ind_buf.chars = dstbuf; \
  call_ind_buf.length = dstlen; \
  wait_for_flag(call_ind_flag, errind); \
  (ch).rpc_xprtp = call_ind_xprt; \
  pprintf("<RPCAwaitCallInd\n"); \
}


#define RPCReturn(ch, srcbuf, srclen, errind) \
{ \
  byte_arr_type answer; \
 \
  pprintf("RPCReturn(%#x, %#x:%d, %#x)\n", \
	  ch, srcbuf, srclen, errind); \
  answer.chars = srcbuf; \
  answer.length = srclen; \
  pprintf("RPCReturn %#x\n", (ch).xprtp); \
  Send_Reply((ch).rpc_xprtp, xdr_byte_arr, &answer); \
  pprintf("<RPCReturn\n"); \
}
    

#define wait_for_flag(Flag, Errind) \
{ \
  int fds, exit = 0, tmp; \
 \
  *(Errind) = OK; \
  (Flag) = 1; \
  pprintf("wait_for_flag(%#x, %#x)\n", \
	  &(Flag), Errind); \
  while ((Flag) && !exit) { \
    fds = svc_fds; \
    switch (tmp = select(32, &fds, NULL, NULL, NULL)) { \
    case -1: \
	if (errno == EINTR) continue; \
	*(Errind) = NOTOK; \
	perror("rstat: select"); \
    case 0: \
        exit = 1; \
        pprintf("wait_for_flag: exiting prematurely %d.\n", tmp); \
	break; \
    default: \
        pprintf("wait_for_flag: select returned (%d, %#x)\n", \
		tmp, fds); \
	svc_getreq(fds); \
        pprintf("wait_for_flag: svc_getreq returned\n"); \
    } \
  } \
  pprintf("<wait_for_flag (%#x)\n", &(Flag)); \
}

/* Two macros used by server_handler(). */
#define Get_Args(xprt, xdr_proc, place) \
  if (!svc_getargs(xprt, xdr_proc, place)) { \
    svcerr_decode(xprt); \
    exit(1); \
  }

#define Send_Reply(xprt, xdr_proc, place) \
  if (!svc_sendreply(xprt, xdr_proc, place)) { \
    perror("Sendreply failed"); \
    exit(1); \
  }

#endif _SUNRPC_
