/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring two-way delay including session/connection
 * setup and taredown. DEMON
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>


int eprofbothd(be, server, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct server_t 	*server;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    RESPONDER_VARIABLES;
    TIMING_VARIABLES(1);
    channel_t ch;
    
    mprintf("eprofbothd(be 0x%x, src 0x%x, dst 0x%x, mt 0x%x)\n",
		 be, srchdl, dsthdl, mt);

    TIMING_INITIATE(1);

    RESPONDER_BEFORE_START;

    if (StartProfiling()) {
	report_error(NULL, "StartProfiling");
	return NOTOK;
    }
    StartMeasurements(mt);
    
    AwaitConnInd(server, &ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitConnInd");
	return NOTOK;
    }

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	RESPONDER_RECVSIZE(msgsize,i);
	RPCAwaitCallInd(ch, srchdl->io_buffer, msgsize, &error);
	if (failed(&error)) {
	    report_error(&error, "RPCAwaitCallInd");
	    return NOTOK;
	}

	RESPONDER_SENDSIZE(msgsize,i);
	RPCReturn(ch, dsthdl->io_buffer, msgsize, &error);
	if (failed(&error)) {
	    report_error(&error, "RPCReturn");
	    return NOTOK;
	}

	if (interupted)
	    break;
	TIMING_DELAY(1);
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;
    if (StopProfiling()) {
	report_error(NULL, "StopProfiling");
	return NOTOK;
    }
    
    AwaitDiscInd(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitDiscInd");
	return NOTOK;
    }
    return OK;
} /* eprofbothd */
