/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Compute statistics
 */

#include <general.h>
#include <math.h>

/*
 * Exports: **OLD**
 *	AverageStats()
 *	MinStats()
 *	MaxStats()
 *	StdDevStats()
 *	InitStats(st: statistics_t *; val: double)
 *	TotalStatistics()
 */

#ifndef MAXFLOAT
#define MAXFLOAT 	HUGE
#endif


/*  */

InitStats(st, val)
    statistics_t *st;
    double val;
{
    tprintf("InitStats(0x%x, %f)\n", st, val);

    st->st_exitstatus = val;
    st->st_starttime = val;
    st->st_stoptime = val;
    st->st_elapsed = val;
    st->st_cputime = val;
    st->st_stime = val;
    st->st_utime = val;
    st->st_delay = val;
    st->st_datasent = val;
    st->st_datarcvd = val;
    st->st_msgsent = val;
    st->st_msgrcvd = val;
    st->st_packsent = val;
    st->st_packrcvd = val;
    st->st_signals = val;
    st->st_blockout = val;
    st->st_blockin = val;
    st->st_pageio = val;
    st->st_pagerecl = val;
    st->st_swaps = val;
    st->st_ivcsw = val;
    st->st_vcsw = val;
    st->st_maxrss = val;
}

/*  */

/* NOTE: sta is an array of statistics_t; NOT an array of pointers! */

TotalStatistics(stalen, sta, st)
    int stalen;
    statistics_t *sta, *st;
{
    register int i;

    tprintf("TotalStatistics(%d, 0x%x, 0x%x)\n", stalen, sta, st);
    
    InitStats(st, (double)0);
    
    if (stalen == 0)
	return;
    
    for (i = 0; i < stalen; i++) {
	if (sta[i].st_exitstatus == ST_UNDEF)
	    st->st_exitstatus = ST_UNDEF;
	else
	    st->st_exitstatus += sta[i].st_exitstatus;
	if (sta[i].st_starttime == ST_UNDEF)
	    st->st_starttime = ST_UNDEF;
	else
	    st->st_starttime += sta[i].st_starttime;
	if (sta[i].st_stoptime == ST_UNDEF)
	    st->st_stoptime = ST_UNDEF;
	else
	    st->st_stoptime += sta[i].st_stoptime;
	if (sta[i].st_elapsed == ST_UNDEF)
	    st->st_elapsed = ST_UNDEF;
	else
	    st->st_elapsed += sta[i].st_elapsed;
	if (sta[i].st_cputime == ST_UNDEF)
	    st->st_cputime = ST_UNDEF;
	else
	    st->st_cputime += sta[i].st_cputime;
	if (sta[i].st_stime == ST_UNDEF)
	    st->st_stime = ST_UNDEF;
	else
	    st->st_stime += sta[i].st_stime;
	if (sta[i].st_utime == ST_UNDEF)
	    st->st_utime = ST_UNDEF;
	else
	    st->st_utime += sta[i].st_utime;
	if (sta[i].st_delay == ST_UNDEF)
	    st->st_delay = ST_UNDEF;
	else
	    st->st_delay += sta[i].st_delay;
	if (sta[i].st_datasent == ST_UNDEF)
	    st->st_datasent = ST_UNDEF;
	else
	    st->st_datasent += sta[i].st_datasent;
	if (sta[i].st_datarcvd == ST_UNDEF)
	    st->st_datarcvd = ST_UNDEF;
	else
	    st->st_datarcvd += sta[i].st_datarcvd;
	if (sta[i].st_msgsent == ST_UNDEF)
	    st->st_msgsent = ST_UNDEF;
	else
	    st->st_msgsent += sta[i].st_msgsent;
	if (sta[i].st_msgrcvd == ST_UNDEF)
	    st->st_msgrcvd = ST_UNDEF;
	else
	    st->st_msgrcvd += sta[i].st_msgrcvd;
	if (sta[i].st_packsent == ST_UNDEF)
	    st->st_packsent = ST_UNDEF;
	else
	    st->st_packsent += sta[i].st_packsent;
	if (sta[i].st_packrcvd == ST_UNDEF)
	    st->st_packrcvd = ST_UNDEF;
	else
	    st->st_packrcvd += sta[i].st_packrcvd;
	if (sta[i].st_signals == ST_UNDEF)
	    st->st_signals = ST_UNDEF;
	else
	    st->st_signals += sta[i].st_signals;
	if (sta[i].st_blockout == ST_UNDEF)
	    st->st_blockout = ST_UNDEF;
	else
	    st->st_blockout += sta[i].st_blockout;
	if (sta[i].st_blockin == ST_UNDEF)
	    st->st_blockin = ST_UNDEF;
	else
	st->st_blockin += sta[i].st_blockin;
	if (sta[i].st_pageio == ST_UNDEF)
	    st->st_pageio = ST_UNDEF;
	else
	st->st_pageio += sta[i].st_pageio;
	if (sta[i].st_pagerecl == ST_UNDEF)
	    st->st_pagerecl = ST_UNDEF;
	else
	st->st_pagerecl += sta[i].st_pagerecl;
	if (sta[i].st_swaps == ST_UNDEF)
	    st->st_swaps = ST_UNDEF;
	else
	st->st_swaps += sta[i].st_swaps;
	if (sta[i].st_ivcsw == ST_UNDEF)
	    st->st_ivcsw = ST_UNDEF;
	else
	st->st_ivcsw += sta[i].st_ivcsw;
	if (sta[i].st_vcsw == ST_UNDEF)
	    st->st_vcsw = ST_UNDEF;
	else
	st->st_vcsw += sta[i].st_vcsw;
	if (sta[i].st_maxrss == ST_UNDEF)
	    st->st_maxrss = ST_UNDEF;
	else
	st->st_maxrss += sta[i].st_maxrss;
	
    }
} /* TotalStatistics */

/*  */

SumtoStats(src, dst)
    statistics_t *src, *dst;
{
    tprintf("SumtoStats(0x%x, 0x%x)\n", src, dst);

    dst->st_exitstatus += src->st_exitstatus;
    dst->st_starttime += src->st_starttime;
    dst->st_stoptime += src->st_stoptime;
    dst->st_elapsed += src->st_elapsed;
    dst->st_cputime += src->st_cputime;
    dst->st_stime += src->st_stime;
    dst->st_utime += src->st_utime;
    dst->st_delay += src->st_delay;
    dst->st_datasent += src->st_datasent;
    dst->st_datarcvd += src->st_datarcvd;
    dst->st_msgsent += src->st_msgsent;
    dst->st_msgrcvd += src->st_msgrcvd;
    dst->st_packsent += src->st_packsent;
    dst->st_packrcvd += src->st_packrcvd;
    dst->st_signals += src->st_signals;
    dst->st_blockout += src->st_blockout;
    dst->st_blockin += src->st_blockin;
    dst->st_pageio += src->st_pageio;
    dst->st_pagerecl += src->st_pagerecl;
    dst->st_swaps += src->st_swaps;
    dst->st_ivcsw += src->st_ivcsw;
    dst->st_vcsw += src->st_vcsw;
    dst->st_maxrss += src->st_maxrss;
} /* SumtoStats */

/*  */

MintoStats(src, dst)
    statistics_t *src, *dst;
{
    tprintf("MintoStats(0x%x, 0x%x)\n", src, dst);

    dst->st_exitstatus = MIN(dst->st_exitstatus, src->st_exitstatus);
    dst->st_starttime = MIN(dst->st_starttime, src->st_starttime);
    dst->st_stoptime = MIN(dst->st_stoptime, src->st_stoptime);
    dst->st_elapsed = MIN(dst->st_elapsed, src->st_elapsed);
    dst->st_cputime = MIN(dst->st_cputime, src->st_cputime);
    dst->st_stime = MIN(dst->st_stime, src->st_stime);
    dst->st_utime = MIN(dst->st_utime, src->st_utime);
    dst->st_delay = MIN(dst->st_delay, src->st_delay);
    dst->st_datasent = MIN(dst->st_datasent, src->st_datasent);
    dst->st_datarcvd = MIN(dst->st_datarcvd, src->st_datarcvd);
    dst->st_msgsent = MIN(dst->st_msgsent, src->st_msgsent);
    dst->st_msgrcvd = MIN(dst->st_msgrcvd, src->st_msgrcvd);
    dst->st_packsent = MIN(dst->st_packsent, src->st_packsent);
    dst->st_packrcvd = MIN(dst->st_packrcvd, src->st_packrcvd);
    dst->st_signals = MIN(dst->st_signals, src->st_signals);
    dst->st_blockout = MIN(dst->st_blockout, src->st_blockout);
    dst->st_blockin = MIN(dst->st_blockin, src->st_blockin);
    dst->st_pageio = MIN(dst->st_pageio, src->st_pageio);
    dst->st_pagerecl = MIN(dst->st_pagerecl, src->st_pagerecl);
    dst->st_swaps = MIN(dst->st_swaps, src->st_swaps);
    dst->st_ivcsw = MIN(dst->st_ivcsw, src->st_ivcsw);
    dst->st_vcsw = MIN(dst->st_vcsw, src->st_vcsw);
    dst->st_maxrss = MIN(dst->st_maxrss, src->st_maxrss);
} /* MintoStats */

/*  */

MaxtoStats(src, dst)
    statistics_t *src, *dst;
{
    tprintf("MaxtoStats(0x%x, 0x%x)\n", src, dst);

    dst->st_exitstatus = MAX(dst->st_exitstatus, src->st_exitstatus);
    dst->st_starttime = MAX(dst->st_starttime, src->st_starttime);
    dst->st_stoptime = MAX(dst->st_stoptime, src->st_stoptime);
    dst->st_elapsed = MAX(dst->st_elapsed, src->st_elapsed);
    dst->st_cputime = MAX(dst->st_cputime, src->st_cputime);
    dst->st_stime = MAX(dst->st_stime, src->st_stime);
    dst->st_utime = MAX(dst->st_utime, src->st_utime);
    dst->st_delay = MAX(dst->st_delay, src->st_delay);
    dst->st_datasent = MAX(dst->st_datasent, src->st_datasent);
    dst->st_datarcvd = MAX(dst->st_datarcvd, src->st_datarcvd);
    dst->st_msgsent = MAX(dst->st_msgsent, src->st_msgsent);
    dst->st_msgrcvd = MAX(dst->st_msgrcvd, src->st_msgrcvd);
    dst->st_packsent = MAX(dst->st_packsent, src->st_packsent);
    dst->st_packrcvd = MAX(dst->st_packrcvd, src->st_packrcvd);
    dst->st_signals = MAX(dst->st_signals, src->st_signals);
    dst->st_blockout = MAX(dst->st_blockout, src->st_blockout);
    dst->st_blockin = MAX(dst->st_blockin, src->st_blockin);
    dst->st_pageio = MAX(dst->st_pageio, src->st_pageio);
    dst->st_pagerecl = MAX(dst->st_pagerecl, src->st_pagerecl);
    dst->st_swaps = MAX(dst->st_swaps, src->st_swaps);
    dst->st_ivcsw = MAX(dst->st_ivcsw, src->st_ivcsw);
    dst->st_vcsw = MAX(dst->st_vcsw, src->st_vcsw);
    dst->st_maxrss = MAX(dst->st_maxrss, src->st_maxrss);
} /* MaxtoStats */

/*  */

SqsumtoStats(src, dst)
    statistics_t *src, *dst;
{
    tprintf("SqsumtoStats(0x%x, 0x%x)\n", src, dst);

    dst->st_exitstatus += src->st_exitstatus * src->st_exitstatus;
    dst->st_starttime += src->st_starttime * src->st_starttime;
    dst->st_stoptime += src->st_stoptime * src->st_stoptime;
    dst->st_elapsed += src->st_elapsed * src->st_elapsed;
    dst->st_cputime += src->st_cputime * src->st_cputime;
    dst->st_stime += src->st_stime * src->st_stime;
    dst->st_utime += src->st_utime * src->st_utime;
    dst->st_delay += src->st_delay * src->st_delay;
    dst->st_datasent += src->st_datasent * src->st_datasent;
    dst->st_datarcvd += src->st_datarcvd * src->st_datarcvd;
    dst->st_msgsent += src->st_msgsent * src->st_msgsent;
    dst->st_msgrcvd += src->st_msgrcvd * src->st_msgrcvd;
    dst->st_packsent += src->st_packsent * src->st_packsent;
    dst->st_packrcvd += src->st_packrcvd * src->st_packrcvd;
    dst->st_signals += src->st_signals * src->st_signals;
    dst->st_blockout += src->st_blockout * src->st_blockout;
    dst->st_blockin += src->st_blockin * src->st_blockin;
    dst->st_pageio += src->st_pageio * src->st_pageio;
    dst->st_pagerecl += src->st_pagerecl * src->st_pagerecl;
    dst->st_swaps += src->st_swaps * src->st_swaps;
    dst->st_ivcsw += src->st_ivcsw * src->st_ivcsw;
    dst->st_vcsw += src->st_vcsw * src->st_vcsw;
    dst->st_maxrss += src->st_maxrss * src->st_maxrss;
} /* SqsumtoStats */

/*  */

StatsSum2Avg(nrun, sum, avg)
    int nrun;
    statistics_t *sum, *avg;
{
    tprintf("StatsSum2Avg(%d, 0x%x, 0x%x)\n", nrun, sum, avg);

    if (nrun == 0)
	return;
	
    avg->st_exitstatus = sum->st_exitstatus / nrun;
    avg->st_starttime = sum->st_starttime / nrun;
    avg->st_stoptime = sum->st_stoptime / nrun;
    avg->st_elapsed = sum->st_elapsed / nrun;
    avg->st_cputime = sum->st_cputime / nrun;
    avg->st_stime = sum->st_stime / nrun;
    avg->st_utime = sum->st_utime / nrun;
    avg->st_delay = sum->st_delay / nrun;
    avg->st_datasent = sum->st_datasent / nrun;
    avg->st_datarcvd = sum->st_datarcvd / nrun;
    avg->st_msgsent = sum->st_msgsent / nrun;
    avg->st_msgrcvd = sum->st_msgrcvd / nrun;
    avg->st_packsent = sum->st_packsent / nrun;
    avg->st_packrcvd = sum->st_packrcvd / nrun;
    avg->st_signals = sum->st_signals / nrun;
    avg->st_blockout = sum->st_blockout / nrun;
    avg->st_blockin = sum->st_blockin / nrun;
    avg->st_pageio = sum->st_pageio / nrun;
    avg->st_pagerecl = sum->st_pagerecl / nrun;
    avg->st_swaps = sum->st_swaps / nrun;
    avg->st_ivcsw = sum->st_ivcsw / nrun;
    avg->st_vcsw = sum->st_vcsw / nrun;
    avg->st_maxrss = sum->st_maxrss / nrun;

} /* StatsSum2Avg */

/*  */

StatsSqsum2Std(nrun, avg, sqsum, std)
    int nrun;
    statistics_t *avg, *sqsum, *std;
{
    tprintf("StatsSqsum2Std(%d, 0x%x, 0x%x, 0x%x)\n", nrun, avg, sqsum, std);

    if (nrun <= 1) {
	InitStats(std, (double)0);
	return;
    }

#define sqrt_p(var) (var < 0) ? \
    ((Debug) ? printf("sqrt %.3f\n", var): 0), 0.0 : \
	sqrt(var);    
    
    std->st_exitstatus = sqrt_p((sqsum->st_exitstatus
				- nrun*avg->st_exitstatus*avg->st_exitstatus)
			       / (nrun - 1));
    std->st_starttime = sqrt_p((sqsum->st_starttime
			  - nrun*avg->st_starttime*avg->st_starttime)
			 / (nrun - 1));
    std->st_stoptime = sqrt_p((sqsum->st_stoptime
			     - nrun*avg->st_stoptime*avg->st_stoptime)
			    / (nrun - 1));
    std->st_elapsed = sqrt_p((sqsum->st_elapsed
			    - nrun*avg->st_elapsed*avg->st_elapsed)
			   / (nrun - 1));
    std->st_cputime = sqrt_p((sqsum->st_cputime
			    - nrun*avg->st_cputime*avg->st_cputime)
			   / (nrun - 1));
    std->st_stime = sqrt_p((sqsum->st_stime
			  - nrun*avg->st_stime*avg->st_stime)
			 / (nrun - 1));
    std->st_utime = sqrt_p((sqsum->st_utime
			  - nrun*avg->st_utime*avg->st_utime)
			 / (nrun - 1));
    std->st_delay = sqrt_p((sqsum->st_delay
			  - nrun*avg->st_delay*avg->st_delay)
			 / (nrun - 1));
    std->st_datasent = sqrt_p((sqsum->st_datasent
			     - nrun*avg->st_datasent*avg->st_datasent)
			    / (nrun - 1));
    std->st_datarcvd = sqrt_p((sqsum->st_datarcvd
			     - nrun*avg->st_datarcvd*avg->st_datarcvd)
			    / (nrun - 1));
    std->st_msgsent = sqrt_p((sqsum->st_msgsent
			    - nrun*avg->st_msgsent*avg->st_msgsent)
			   / (nrun - 1));
    std->st_msgrcvd = sqrt_p((sqsum->st_msgrcvd
			    - nrun*avg->st_msgrcvd*avg->st_msgrcvd)
			   / (nrun - 1));
    std->st_packsent = sqrt_p((sqsum->st_packsent
			     - nrun*avg->st_packsent*avg->st_packsent)
			    / (nrun - 1));
    std->st_packrcvd = sqrt_p((sqsum->st_packrcvd
			     - nrun*avg->st_packrcvd*avg->st_packrcvd)
			    / (nrun - 1));
    std->st_signals = sqrt_p((sqsum->st_signals
			    - nrun*avg->st_signals*avg->st_signals)
			   / (nrun - 1));
    std->st_blockout = sqrt_p((sqsum->st_blockout
			     - nrun*avg->st_blockout*avg->st_blockout)
			    / (nrun - 1));
    std->st_blockin = sqrt_p((sqsum->st_blockin
			    - nrun*avg->st_blockin*avg->st_blockin)
			   / (nrun - 1));
    std->st_pageio = sqrt_p((sqsum->st_pageio
			   - nrun*avg->st_pageio*avg->st_pageio)
			  / (nrun - 1));
    std->st_pagerecl = sqrt_p((sqsum->st_pagerecl
			     - nrun*avg->st_pagerecl*avg->st_pagerecl)
			    / (nrun - 1));
    std->st_swaps = sqrt_p((sqsum->st_swaps
			  - nrun*avg->st_swaps*avg->st_swaps)
			 / (nrun - 1));
    std->st_ivcsw = sqrt_p((sqsum->st_ivcsw
			  - nrun*avg->st_ivcsw*avg->st_ivcsw)
			 / (nrun - 1));
    std->st_vcsw = sqrt_p((sqsum->st_vcsw
			 - nrun*avg->st_vcsw*avg->st_vcsw)
			/ (nrun - 1));
    std->st_maxrss = sqrt_p((sqsum->st_maxrss
			   - nrun*avg->st_maxrss*avg->st_maxrss)
			  / (nrun - 1));
} /* StatsSqsum2Std */

/*  */

#ifdef notdef
AverageStats(stalen, sta, st)
    int stalen;
    statistics_t *sta[], *st;
{
    register int i;

    tprintf("AverageStats(%d, 0x%x, 0x%x)\n", stalen, sta, st);
    
    InitStats(st, (double)0);

    if (stalen == 0)
	return;
    
    for (i = 0; i < stalen; i++) {
	st->st_exitstatus += sta[i]->st_exitstatus;
	st->st_starttime += sta[i]->st_starttime;
	st->st_stoptime += sta[i]->st_stoptime;
	st->st_elapsed += sta[i]->st_elapsed;
	st->st_cputime += sta[i]->st_cputime;
	st->st_stime += sta[i]->st_stime;
	st->st_utime += sta[i]->st_utime;
	st->st_delay += sta[i]->st_delay;
	st->st_datasent += sta[i]->st_datasent;
	st->st_datarcvd += sta[i]->st_datarcvd;
	st->st_msgsent += sta[i]->st_msgsent;
	st->st_msgrcvd += sta[i]->st_msgrcvd;
	st->st_packsent += sta[i]->st_packsent;
	st->st_packrcvd += sta[i]->st_packrcvd;
	st->st_signals += sta[i]->st_signals;
	st->st_blockout += sta[i]->st_blockout;
	st->st_blockin += sta[i]->st_blockin;
	st->st_pageio += sta[i]->st_pageio;
	st->st_pagerecl += sta[i]->st_pagerecl;
	st->st_swaps += sta[i]->st_swaps;
	st->st_ivcsw += sta[i]->st_ivcsw;
	st->st_vcsw += sta[i]->st_vcsw;
	st->st_maxrss += sta[i]->st_maxrss;
    }
    st->st_exitstatus /= stalen;
    st->st_starttime /= stalen;
    st->st_stoptime /= stalen;
    st->st_elapsed /= stalen;
    st->st_cputime /= stalen;
    st->st_stime /= stalen;
    st->st_utime /= stalen;
    st->st_delay /= stalen;
    st->st_datasent /= stalen;
    st->st_datarcvd /= stalen;
    st->st_msgsent /= stalen;
    st->st_msgrcvd /= stalen;
    st->st_packsent /= stalen;
    st->st_packrcvd /= stalen;
    st->st_signals /= stalen;
    st->st_blockout /= stalen;
    st->st_blockin /= stalen;
    st->st_pageio /= stalen;
    st->st_pagerecl /= stalen;
    st->st_swaps /= stalen;
    st->st_ivcsw /= stalen;
    st->st_vcsw /= stalen;
    st->st_maxrss /= stalen;
} /* AverageStats */

/*  */

MaxStats(stalen, sta, st)
    int stalen;
    statistics_t *sta[], *st;
{
    register int i;

    tprintf("MaxStats(%d, 0x%x, 0x%x)\n", stalen, sta, st);

    InitStats(st, -MAXFLOAT);
    
    for (i = 0; i < stalen; i++) {
	st->st_exitstatus = MAX(sta[i]->st_exitstatus, st->st_exitstatus);
	st->st_starttime = MAX(sta[i]->st_starttime, st->st_starttime);
	st->st_stoptime = MAX(sta[i]->st_stoptime, st->st_stoptime);
	st->st_elapsed = MAX(sta[i]->st_elapsed, st->st_elapsed);
	st->st_cputime = MAX(sta[i]->st_cputime, st->st_cputime);
	st->st_stime = MAX(sta[i]->st_stime, st->st_stime);
	st->st_utime = MAX(sta[i]->st_utime, st->st_utime);
	st->st_delay = MAX(sta[i]->st_delay, st->st_delay);
	st->st_datasent = MAX(sta[i]->st_datasent, st->st_datasent);
	st->st_datarcvd = MAX(sta[i]->st_datarcvd, st->st_datarcvd);
	st->st_msgsent = MAX(sta[i]->st_msgsent, st->st_msgsent);
	st->st_msgrcvd = MAX(sta[i]->st_msgrcvd, st->st_msgrcvd);
	st->st_packsent = MAX(sta[i]->st_packsent, st->st_packsent);
	st->st_packrcvd = MAX(sta[i]->st_packrcvd, st->st_packrcvd);
	st->st_signals = MAX(sta[i]->st_signals, st->st_signals);
	st->st_blockout = MAX(sta[i]->st_blockout, st->st_blockout);
	st->st_blockin = MAX(sta[i]->st_blockin, st->st_blockin);
	st->st_pageio = MAX(sta[i]->st_pageio, st->st_pageio);
	st->st_pagerecl = MAX(sta[i]->st_pagerecl, st->st_pagerecl);
	st->st_swaps = MAX(sta[i]->st_swaps, st->st_swaps);
	st->st_ivcsw = MAX(sta[i]->st_ivcsw, st->st_ivcsw);
	st->st_vcsw = MAX(sta[i]->st_vcsw, st->st_vcsw);
	st->st_maxrss = MAX(sta[i]->st_maxrss, st->st_maxrss);
    }
} /* MaxStats */

/*  */

MinStats(stalen, sta, st)
    int stalen;
    statistics_t *sta[], *st;
{
    register int i;

    tprintf("MinStats(%d, 0x%x, 0x%x)\n", stalen, sta, st);

    InitStats(st, MAXFLOAT);
    
    for (i = 0; i < stalen; i++) {
	st->st_exitstatus = MIN(sta[i]->st_exitstatus, st->st_exitstatus);
	st->st_starttime = MIN(sta[i]->st_starttime, st->st_starttime);
	st->st_stoptime = MIN(sta[i]->st_stoptime, st->st_stoptime);
	st->st_elapsed = MIN(sta[i]->st_elapsed, st->st_elapsed);
	st->st_cputime = MIN(sta[i]->st_cputime, st->st_cputime);
	st->st_stime = MIN(sta[i]->st_stime, st->st_stime);
	st->st_utime = MIN(sta[i]->st_utime, st->st_utime);
	st->st_delay = MIN(sta[i]->st_delay, st->st_delay);
	st->st_datasent = MIN(sta[i]->st_datasent, st->st_datasent);
	st->st_datarcvd = MIN(sta[i]->st_datarcvd, st->st_datarcvd);
	st->st_msgsent = MIN(sta[i]->st_msgsent, st->st_msgsent);
	st->st_msgrcvd = MIN(sta[i]->st_msgrcvd, st->st_msgrcvd);
	st->st_packsent = MIN(sta[i]->st_packsent, st->st_packsent);
	st->st_packrcvd = MIN(sta[i]->st_packrcvd, st->st_packrcvd);
	st->st_signals = MIN(sta[i]->st_signals, st->st_signals);
	st->st_blockout = MIN(sta[i]->st_blockout, st->st_blockout);
	st->st_blockin = MIN(sta[i]->st_blockin, st->st_blockin);
	st->st_pageio = MIN(sta[i]->st_pageio, st->st_pageio);
	st->st_pagerecl = MIN(sta[i]->st_pagerecl, st->st_pagerecl);
	st->st_swaps = MIN(sta[i]->st_swaps, st->st_swaps);
	st->st_ivcsw = MIN(sta[i]->st_ivcsw, st->st_ivcsw);
	st->st_vcsw = MIN(sta[i]->st_vcsw, st->st_vcsw);
	st->st_maxrss = MIN(sta[i]->st_maxrss, st->st_maxrss);
    }
} /* MinStats */

/*  */

StdDevStats(stalen, sta, avg, st)
    int stalen;
    statistics_t *sta[], *avg, *st;
{
    register int i;

    tprintf("StdDevStats(%d, 0x%x, 0x%x, 0x%x)\n", stalen, sta, avg, st);

    InitStats(st, (double)0);

    if (stalen == 0 || stalen == 1)
	return;
    
    for (i = 0; i < stalen; i++) {
	st->st_exitstatus += SQR(sta[i]->st_exitstatus - avg->st_exitstatus);
	st->st_starttime += SQR(sta[i]->st_starttime - avg->st_starttime);
	st->st_stoptime += SQR(sta[i]->st_stoptime - avg->st_stoptime);
	st->st_elapsed += SQR(sta[i]->st_elapsed - avg->st_elapsed);
	st->st_cputime += SQR(sta[i]->st_cputime - avg->st_cputime);
	st->st_stime += SQR(sta[i]->st_stime - avg->st_stime);
	st->st_utime += SQR(sta[i]->st_utime - avg->st_utime);
	st->st_delay += SQR(sta[i]->st_delay - avg->st_delay);
	st->st_datasent += SQR(sta[i]->st_datasent - avg->st_datasent);
	st->st_datarcvd += SQR(sta[i]->st_datarcvd - avg->st_datarcvd);
	st->st_msgsent += SQR(sta[i]->st_msgsent - avg->st_msgsent);
	st->st_msgrcvd += SQR(sta[i]->st_msgrcvd - avg->st_msgrcvd);
	st->st_packsent += SQR(sta[i]->st_packsent - avg->st_packsent);
	st->st_packrcvd += SQR(sta[i]->st_packrcvd - avg->st_packrcvd);
	st->st_signals += SQR(sta[i]->st_signals - avg->st_signals);
	st->st_blockout += SQR(sta[i]->st_blockout - avg->st_blockout);
	st->st_blockin += SQR(sta[i]->st_blockin - avg->st_blockin);
	st->st_pageio += SQR(sta[i]->st_pageio - avg->st_pageio);
	st->st_pagerecl += SQR(sta[i]->st_pagerecl - avg->st_pagerecl);
	st->st_swaps += SQR(sta[i]->st_swaps - avg->st_swaps);
	st->st_ivcsw += SQR(sta[i]->st_ivcsw - avg->st_ivcsw);
	st->st_vcsw += SQR(sta[i]->st_vcsw - avg->st_vcsw);
	st->st_maxrss += SQR(sta[i]->st_maxrss - avg->st_maxrss);
    }
    st->st_exitstatus /= stalen - 1;
    st->st_starttime /= stalen - 1;
    st->st_stoptime /= stalen - 1;
    st->st_elapsed /= stalen - 1;
    st->st_cputime /= stalen - 1;
    st->st_stime /= stalen - 1;
    st->st_utime /= stalen - 1;
    st->st_delay /= stalen - 1;
    st->st_datasent /= stalen - 1;
    st->st_datarcvd /= stalen - 1;
    st->st_msgsent /= stalen - 1;
    st->st_msgrcvd /= stalen - 1;
    st->st_packsent /= stalen - 1;
    st->st_packrcvd /= stalen - 1;
    st->st_signals /= stalen - 1;
    st->st_blockout /= stalen - 1;
    st->st_blockin /= stalen - 1;
    st->st_pageio /= stalen - 1;
    st->st_pagerecl /= stalen - 1;
    st->st_swaps /= stalen - 1;
    st->st_ivcsw /= stalen - 1;
    st->st_vcsw /= stalen - 1;
    st->st_maxrss /= stalen - 1;
    
    st->st_exitstatus = sqrt(st->st_exitstatus);
    st->st_starttime = sqrt(st->st_starttime);
    st->st_stoptime = sqrt(st->st_stoptime);
    st->st_elapsed = sqrt(st->st_elapsed);
    st->st_cputime = sqrt(st->st_cputime);
    st->st_stime = sqrt(st->st_stime);
    st->st_utime = sqrt(st->st_utime);
    st->st_delay = sqrt(st->st_delay);
    st->st_datasent = sqrt(st->st_datasent);
    st->st_datarcvd = sqrt(st->st_datarcvd);
    st->st_msgsent = sqrt(st->st_msgsent);
    st->st_msgrcvd = sqrt(st->st_msgrcvd);
    st->st_packsent = sqrt(st->st_packsent);
    st->st_packrcvd = sqrt(st->st_packrcvd);
    st->st_signals = sqrt(st->st_signals);
    st->st_blockout = sqrt(st->st_blockout);
    st->st_blockin = sqrt(st->st_blockin);
    st->st_pageio = sqrt(st->st_pageio);
    st->st_pagerecl = sqrt(st->st_pagerecl);
    st->st_swaps = sqrt(st->st_swaps);
    st->st_ivcsw = sqrt(st->st_ivcsw);
    st->st_vcsw = sqrt(st->st_vcsw);
    st->st_maxrss = sqrt(st->st_maxrss);
    
} /* StdDevStats */
#endif notdef
