/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * strtod() and strtol() routines
 */

#include <general.h>
    
/*
 * This routine scans doubles from a string
 * Parameter semantics are the same as for strtol(3).
 */
double strtod(str, ptr)
    char *str, **ptr;
{
    char *first, *next;
    register int len;
    double res;
    int integer, frac, fd, i;

    first = str;
    integer = strtol(str, &next, 10);
    if (next == str) {
	dprintf("strtod: first number failed with %s\n", first);
	goto err;
    }
    if (*next != '.') {
	dprintf("strtod: no decimal point in %s\n", first);
	goto err;
    }
    str = next+1;
    frac = strtol(str, &next, 10);
    if (next == str) {
	dprintf("strtod: no fraction in %s\n", first);
	goto err;
    }	      
    if (frac <0) {
	dprintf("strtod: negative fraction in %s\n", first);
	goto err;
    }
    len = next - str;
    for (fd = 1, i = 0; i < len; i++)
	fd *= 10;

    res = integer + (1.0 * frac)/fd;
    if (ptr != NULL)
    	*ptr = next;
    return res;

 err:
    if (ptr != NULL)
    	*ptr = first;
    return 0.0;
} /* strtod */


/*  */

long strtol(str, ptr, radix)
     char *str, **ptr;
     int radix;
{
  char *first, *next;
  register int len;
  long res;
  int sign = 1;
  
  first = str;
  
  while (*first == ' ')
    first++;
  
  if (*first == '+')
    first++;
  else if (*first == '-') {
    first++;
    sign = -1;
  }
  
  if (*first == '0' && (first[1] == 'x' || first[1] == 'X')) {
    if (radix == 0)
      radix = 16;
    if (radix != 16)
      goto abort;
    first += 2;
  } else if (*first == '0' && radix == 0)
    radix = 8;

  if (!isrdigit(radix, *first)) 
    goto abort;
  
  res = 0;
  while (isrdigit(radix, *first)) {
    res = radix*res + rdigit2int(radix, *first);
    first++;
  }
  next = first;
  
  if (ptr)
    *ptr = next;
  return res*sign;
  
 abort:
  if (ptr)
    *ptr = str;
  return 0;
} /* strtol */


static isrdigit(r, ch)
     int r, ch;
{
  if (r <= 0) {
    dprintf("isrdigit: radix <= 0\n");
    return 0;
  }
  if (r <= 10)
    return  (ch >= '0' && ch < '0'+r);
  
  if (ch >= '0' && ch <= '9')
    return 1;
  if (ch >= 'a' && ch < 'a' +r-10)
    return 1;
  if (ch >= 'A' && ch < 'A' +r-10)
    return 1;
  return 0;
}

static int rdigit2int(r, ch)
     int r, ch;
{
  if (r <= 0) {
    dprintf("rdigit2int: radix <= 0\n");
    return 0;
  }
  if (r <= 10)
    return  (ch-'0');
  
  if (ch >= '0' && ch <= '9')
    return ch - '0';
  if (ch >= 'a' && ch < 'a' +r-10)
    return 10 + ch - 'a';
  if (ch >= 'A' && ch < 'A' +r-10)
    return 10 + ch - 'A';
  return 0;
}

