/* 1540, Sun 17 Jul 94

   NMC_SNMP.C:  NMC's SNMP interface with the meter

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

/***********************************************************
	Copyright 1988 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#define noTESTING

#include <sys/param.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>
#include <errno.h>

#include <string.h>
#include <malloc.h>

#include "ausnmp.h"

#include "snmp.h"
#include "snmpimpl.h"
#include "asn1.h"
#include "snmpclnt.h"
#include "snmpapi.h"
#include "mib.h"

#include "nmc.h"

#ifndef BSD4_3
#define BSD4_2
#endif


#define  INT_ACCT    1, 3, 6, 1, 3, 99
#define  U_AUCKLAND  1, 3, 6, 1, 4, 1, 411

oid CurrentVersion[]      = {U_AUCKLAND, 1, 2,3, 0};  /* NeTraMet, 2.3 */

oid o_sysDescr[]	  = {MIB, 1, 1, 0};
oid o_sysVersionId[]	  = {MIB, 1, 2, 0};
oid o_sysUpTime[]	  = {MIB, 1, 3, 0};
oid o_ifNumber[]	  = {MIB, 2, 1, 0};

oid o_HighWaterMark[]     = {INT_ACCT, 1,  1, 0};
oid o_FloodMark[]         = {INT_ACCT, 1,  2, 0};
oid o_InactivityTimeout[] = {INT_ACCT, 1,  3, 0};
oid o_SamplingRate[]      = {INT_ACCT, 1,  4, 1, 1};  /* Only one interface! */
oid o_LastCollectTime[]   = {INT_ACCT, 1,  6, 0};
oid o_riRuleSize[]        = {INT_ACCT, 1,  7, 1, 2, 0xFF};
oid o_riActionSize[]      = {INT_ACCT, 1,  7, 1, 3, 0xFF};
oid o_CurrentRuleSet[]    = {INT_ACCT, 1,  8, 0};
oid o_EmergencyRuleSet[]  = {INT_ACCT, 1,  9, 0};

oid o_ftFlowIndex[]            = {INT_ACCT, 2, 1, 1,  1, 0xFFFF};
oid o_ftFlowStatus[]           = {INT_ACCT, 2, 1, 1,  2, 0xFFFF};
oid o_ftLowInterface[]         = {INT_ACCT, 2, 1, 1,  3, 0xFFFF};
oid o_ftLowAdjacentType[]      = {INT_ACCT, 2, 1, 1,  4, 0xFFFF};
oid o_ftLowAdjacentAddress[]   = {INT_ACCT, 2, 1, 1,  5, 0xFFFF};
oid o_ftLowAdjacentMask[]      = {INT_ACCT, 2, 1, 1,  6, 0xFFFF};
oid o_ftLowPeerType[]          = {INT_ACCT, 2, 1, 1,  7, 0xFFFF};
oid o_ftLowPeerTypeMask[]      = {INT_ACCT, 2, 1, 1,  8, 0xFFFF};
oid o_ftLowPeerAddress[]       = {INT_ACCT, 2, 1, 1,  9, 0xFFFF};
oid o_ftLowPeerMask[]          = {INT_ACCT, 2, 1, 1, 10, 0xFFFF};
oid o_ftLowDetailType[]        = {INT_ACCT, 2, 1, 1, 11, 0xFFFF};
oid o_ftLowDetailTypeMask[]    = {INT_ACCT, 2, 1, 1, 12, 0xFFFF};
oid o_ftLowDetailAddress[]     = {INT_ACCT, 2, 1, 1, 13, 0xFFFF};
oid o_ftLowDetailMask[]        = {INT_ACCT, 2, 1, 1, 14, 0xFFFF};
oid o_ftHighInterface[]        = {INT_ACCT, 2, 1, 1, 17, 0xFFFF};
oid o_ftHighAdjacentType[]     = {INT_ACCT, 2, 1, 1, 18, 0xFFFF};
oid o_ftHighAdjacentAddress[]  = {INT_ACCT, 2, 1, 1, 19, 0xFFFF};
oid o_ftHighAdjacentMask[]     = {INT_ACCT, 2, 1, 1, 20, 0xFFFF};
oid o_ftHighPeerType[]         = {INT_ACCT, 2, 1, 1, 21, 0xFFFF};
oid o_ftHighPeerTypeMask[]     = {INT_ACCT, 2, 1, 1, 22, 0xFFFF};
oid o_ftHighPeerAddress[]      = {INT_ACCT, 2, 1, 1, 23, 0xFFFF};
oid o_ftHighPeerMask[]         = {INT_ACCT, 2, 1, 1, 24, 0xFFFF};
oid o_ftHighDetailType[]       = {INT_ACCT, 2, 1, 1, 25, 0xFFFF};
oid o_ftHighDetailTypeMask[]   = {INT_ACCT, 2, 1, 1, 26, 0xFFFF};
oid o_ftHighDetailAddress[]    = {INT_ACCT, 2, 1, 1, 27, 0xFFFF};
oid o_ftHighDetailMask[]       = {INT_ACCT, 2, 1, 1, 28, 0xFFFF};
oid o_ftPDUScale[]             = {INT_ACCT, 2, 1, 1, 33, 0xFFFF};
oid o_ftOctetScale[]           = {INT_ACCT, 2, 1, 1, 34, 0xFFFF};
oid o_ftRuleSet[]              = {INT_ACCT, 2, 1, 1, 35, 0xFFFF};
oid o_ftFlowType[]             = {INT_ACCT, 2, 1, 1, 36, 0xFFFF};
oid o_ftUpOctets[]             = {INT_ACCT, 2, 1, 1, 37, 0xFFFF};
oid o_ftUpPDUs[]               = {INT_ACCT, 2, 1, 1, 38, 0xFFFF};
oid o_ftDownOctets[]           = {INT_ACCT, 2, 1, 1, 39, 0xFFFF};
oid o_ftDownPDUs[]             = {INT_ACCT, 2, 1, 1, 40, 0xFFFF};
oid o_ftFirstTime[]            = {INT_ACCT, 2, 1, 1, 41, 0xFFFF};
oid o_ftLastTime[]             = {INT_ACCT, 2, 1, 1, 42, 0xFFFF};

oid o_ftCreateTime[]	  = {INT_ACCT, 2, 2, 1, 1, 0xFFFFFFFF, 0xFFFF};
oid o_ftCreateIndex[]	  = {INT_ACCT, 2, 2, 1, 2, 0xFFFFFFFF, 0xFFFF};

oid o_ftActiveTime[]	  = {INT_ACCT, 2, 3, 1, 1, 0xFFFFFFFF, 0xFFFF};
oid o_ftActiveIndex[]	  = {INT_ACCT, 2, 3, 1, 2, 0xFFFFFFFF, 0xFFFF};
oid o_ftActiveFlowBlob[]  = {INT_ACCT, 2, 3, 1, 3, 0xFFFFFFFF, 0xFFFF};

oid o_ftColumnBlob[]  = {INT_ACCT, 2, 4, 1, 4, 0xFF, 0xFFFFFFFF, 0xFFFF};

oid o_rtSelector[]        = {INT_ACCT, 3, 1, 1, 3, 0xFF, 0xFFFF};
oid o_rtRuleMask[]        = {INT_ACCT, 3, 1, 1, 4, 0xFF, 0xFFFF};
oid o_rtMatchedValue[]    = {INT_ACCT, 3, 1, 1, 5, 0xFF, 0xFFFF};
oid o_rtRuleAction[]      = {INT_ACCT, 3, 1, 1, 6, 0xFF, 0xFFFF};
oid o_rtJumpIndex[]       = {INT_ACCT, 3, 1, 1, 7, 0xFF, 0xFFFF};

oid o_atLowInterface[]         = {INT_ACCT, 4, 1, 1,  3, 0xFF, 0xFFFF};
oid o_atLowAdjacentType[]      = {INT_ACCT, 4, 1, 1,  4, 0xFF, 0xFFFF};
oid o_atLowAdjacentAddress[]   = {INT_ACCT, 4, 1, 1,  5, 0xFF, 0xFFFF};
oid o_atLowAdjacentMask[]      = {INT_ACCT, 4, 1, 1,  6, 0xFF, 0xFFFF};
oid o_atLowPeerType[]          = {INT_ACCT, 4, 1, 1,  7, 0xFF, 0xFFFF};
oid o_atLowPeerTypeMask[]      = {INT_ACCT, 4, 1, 1,  8, 0xFF, 0xFFFF};
oid o_atLowPeerAddress[]       = {INT_ACCT, 4, 1, 1,  9, 0xFF, 0xFFFF};
oid o_atLowPeerMask[]          = {INT_ACCT, 4, 1, 1, 10, 0xFF, 0xFFFF};
oid o_atLowDetailType[]        = {INT_ACCT, 4, 1, 1, 11, 0xFF, 0xFFFF};
oid o_atLowDetailTypeMask[]    = {INT_ACCT, 4, 1, 1, 12, 0xFF, 0xFFFF};
oid o_atLowDetailAddress[]     = {INT_ACCT, 4, 1, 1, 13, 0xFF, 0xFFFF};
oid o_atLowDetailMask[]        = {INT_ACCT, 4, 1, 1, 14, 0xFF, 0xFFFF};
oid o_atHighInterface[]        = {INT_ACCT, 4, 1, 1, 17, 0xFF, 0xFFFF};
oid o_atHighAdjacentType[]     = {INT_ACCT, 4, 1, 1, 18, 0xFF, 0xFFFF};
oid o_atHighAdjacentAddress[]  = {INT_ACCT, 4, 1, 1, 19, 0xFF, 0xFFFF};
oid o_atHighAdjacentMask[]     = {INT_ACCT, 4, 1, 1, 20, 0xFF, 0xFFFF};
oid o_atHighPeerType[]         = {INT_ACCT, 4, 1, 1, 21, 0xFF, 0xFFFF};
oid o_atHighPeerTypeMask[]     = {INT_ACCT, 4, 1, 1, 22, 0xFF, 0xFFFF};
oid o_atHighPeerAddress[]      = {INT_ACCT, 4, 1, 1, 23, 0xFF, 0xFFFF};
oid o_atHighPeerMask[]         = {INT_ACCT, 4, 1, 1, 24, 0xFF, 0xFFFF};
oid o_atHighDetailType[]       = {INT_ACCT, 4, 1, 1, 25, 0xFF, 0xFFFF};
oid o_atHighDetailTypeMask[]   = {INT_ACCT, 4, 1, 1, 26, 0xFF, 0xFFFF};
oid o_atHighDetailAddress[]    = {INT_ACCT, 4, 1, 1, 27, 0xFF, 0xFFFF};
oid o_atHighDetailMask[]       = {INT_ACCT, 4, 1, 1, 28, 0xFF, 0xFFFF};
oid o_atPDUScale[]             = {INT_ACCT, 4, 1, 1, 33, 0xFF, 0xFFFF};
oid o_atOctetScale[]           = {INT_ACCT, 4, 1, 1, 34, 0xFF, 0xFFFF};
oid o_atRuleSet[]              = {INT_ACCT, 4, 1, 1, 35, 0xFF, 0xFFFF};

oid o_msStatsReset[]      = {U_AUCKLAND, 1,  1, 0};
oid o_msStatsTime[]       = {U_AUCKLAND, 1,  2, 0};
oid o_msNbrPackets[]      = {U_AUCKLAND, 1,  3, 0};
oid o_msTotPktBacklog[]   = {U_AUCKLAND, 1,  4, 0};
oid o_msMaxPktRate[]      = {U_AUCKLAND, 1,  5, 0};
oid o_msMaxPktBacklog[]   = {U_AUCKLAND, 1,  6, 0};
oid o_msNbrFlows[]        = {U_AUCKLAND, 1,  7, 0};
oid o_msFlowsRecovered[]  = {U_AUCKLAND, 1,  8, 0};
oid o_msRuleMatches[]     = {U_AUCKLAND, 1,  9, 0};
oid o_msHashSearches[]    = {U_AUCKLAND, 1, 10, 0};
oid o_msHashCompares[]    = {U_AUCKLAND, 1, 11, 0};
oid o_msTotalHashSize[]   = {U_AUCKLAND, 1, 12, 0};
oid o_msNbrHashEntries[]  = {U_AUCKLAND, 1, 13, 0};
oid o_msGCInterval[]      = {U_AUCKLAND, 1, 14, 0};
oid o_msMaxFlows[]        = {U_AUCKLAND, 1, 15, 0};
oid o_msAvIdle1000[]      = {U_AUCKLAND, 1, 16, 0};
oid o_msMinIdle1000[]     = {U_AUCKLAND, 1, 17, 0};

oid o_pcNearMem[]         = {U_AUCKLAND, 2, 1, 0};
oid o_pcFarMem[]          = {U_AUCKLAND, 2, 2, 0};
oid o_pcBadPackets[]      = {U_AUCKLAND, 2, 3, 0};
oid o_pcNoBufPackets[]    = {U_AUCKLAND, 2, 4, 0};
oid o_pcLostPackets[]     = {U_AUCKLAND, 2, 5, 0};


int start_snmp_session(struct meter_status *ms)
{
   struct snmp_session session, *ssp;

   bzero((char *)&session, sizeof(struct snmp_session));
   session.peername = ms->name;
   session.community = ms->community;
   session.community_len = strlen((char *)ms->community);
   session.retries = SNMP_DEFAULT_RETRIES;
   session.timeout = SNMP_DEFAULT_TIMEOUT;
   session.authenticator = NULL;
   snmp_synch_setup(&session);
   ssp = snmp_open(&session);
   if (ssp == NULL) {
      printf("Couldn't open snmp to %s\n", session.peername);
      return 0;
      }
   ms->ss = ssp;
   return 1;
   }

int trim(unsigned char *s, int len)
{
   while (len != 0 && s[len-1] == 0) --len;
   return len;
   }

#define ADD_VAR(v)            snmp_add_null_var(pdu, v, sizeof(v)/sizeof(oid))
#define ADD_X_VAR(v,n1)         { v[sizeof(v)/sizeof(oid) - 1] = n1; \
            ADD_VAR(v); }
#define ADD_X2_VAR(v,n1,n2)     { v[sizeof(v)/sizeof(oid) - 2] = n1; \
            v[sizeof(v)/sizeof(oid) - 1] = n2; \
            ADD_VAR(v); }
#define ADD_X3_VAR(v,n1,n2,n3)  { v[sizeof(v)/sizeof(oid) - 3] = n1; \
            v[sizeof(v)/sizeof(oid) - 2] = n2; \
            v[sizeof(v)/sizeof(oid) - 1] = n3; \
            ADD_VAR(v); }

#define SET_INT(v)            { vars->type = INTEGER; \
  	    vars->val.integer = (long *)malloc(vars->val_len = sizeof(long)); \
	    *(vars->val.integer) = (long)v; }
#define SET_TIMETICKS(v)      { vars->type = TIMETICKS; \
  	    vars->val.integer = (long *)malloc(vars->val_len = sizeof(long)); \
	    *(vars->val.integer) = (long)v; }
#define SET_STRING(v,len)     { vars->type = STRING; \
	    vars->val.string = (u_char *)malloc(RULE_ADDR_LEN) ;\
	    bcopy(v, (char *)vars->val.string, vars->val_len = trim(v,len)); }

#define STRING_VAL(v)         bcopy(vars->val.string, v, vars->val_len)
#define INT_VAL(v)            v = *(vars->val.integer)
#define OID_VAL(v)            bcopy((char *)vars->val.objid, v, vars->val_len)


int set_meter_params(struct meter_status *ms)
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   if (ms->GCIntervalReqd == 0 && ms->HighWaterMark == 0 && 
         ms->InactivityTime == 0 && ms->SamplingRate == 0) 
      return 1;  /* Nothing to do */
   if (!ms->write_OK) return 1;  /* No write access */

   pdu = snmp_pdu_create(SET_REQ_MSG);
   i = 0;
   if (ms->GCInterval != 0) {
      ADD_VAR(o_msGCInterval);
      vars = pdu->variables;  i = 1;
      SET_INT(ms->GCIntervalReqd);
      }
   if (ms->HighWaterMark != 0) {
      ADD_VAR(o_HighWaterMark);
      vars = i ? vars->next_variable : pdu->variables;  i = 1;
      SET_INT(ms->HighWaterMark);
      }
   if (ms->InactivityTime != 0) {
      ADD_VAR(o_InactivityTimeout);
      vars = i ? vars->next_variable : pdu->variables;  i = 1;
      SET_INT(ms->InactivityTime);
      }
   if (ms->SamplingRate != 0) {
      ADD_VAR(o_SamplingRate);
      vars = i ? vars->next_variable : pdu->variables;
      SET_INT(ms->SamplingRate);
      }

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
         if (verbose) printf(
            "Meter parameters set: GCI=%u, HWM=%u, IAT=%u, SR=%u\n",
            ms->GCIntervalReqd,ms->HighWaterMark,
            ms->InactivityTime,ms->SamplingRate);
         fprintf(log, 
            "Meter parameters set: GCI=%u, HWM=%u, IAT=%u, SR=%u\n",
            ms->GCIntervalReqd,ms->HighWaterMark,
            ms->InactivityTime,ms->SamplingRate);
         fflush(log);
	 }
      else {
#ifdef TESTING
	 printf("set_meter_params(): Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
#endif
         ms->write_OK = 0;
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);
   return 1;
   }

int set_collect_time(ms,v)  /* Set LastCollectTime for meter - */
struct meter_status *ms;  /* this tells meter a collection is starting */
int v;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   printf("Set %d: starting collection\n", ms->ruleset);
   if (!ms->write_OK) return 1;

   pdu = snmp_pdu_create(SET_REQ_MSG);
   ADD_VAR(o_LastCollectTime);
   vars = pdu->variables;
   SET_TIMETICKS(v);

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat != SNMP_ERR_NOERROR) {
#ifdef TESTING
	 printf("set_collect_time(): Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
#endif
         ms->write_OK = 0;
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);
   return 1;
   }

int set_rule_info(ms,setset)  /* 1 to set rule+action set */
struct meter_status *ms;      /* 0 to set rule and actions tables sizes */
int setset;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   if (!ms->write_OK) return 1;
   pdu = snmp_pdu_create(SET_REQ_MSG);
   if (setset) {
      ADD_VAR(o_CurrentRuleSet);
         vars = pdu->variables;
         SET_INT(ms->ruleset);
      }
   else {
      ADD_X_VAR(o_riRuleSize, ms->ruleset);
         vars = pdu->variables;
         SET_INT(ms->nrules);
      ADD_X_VAR(o_riActionSize, ms->ruleset);
         vars = vars->next_variable;
         SET_INT(ms->nactions);
      }

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
         if (setset) printf(
            "Meter is now using rule+action set %d\n", ms->ruleset);
         else printf("Set %d: sizes set to %d rules + %d actions\n", 
            ms->ruleset,ms->nrules,ms->nactions);
	 }
      else {
#ifdef TESTING
	 printf("set_rule_info(): Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
#endif
         ms->write_OK = 0;
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);
   return 1;
   }

int add_rule(ms,ri)
struct meter_status *ms;
struct rule_info *ri;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   if (!ms->write_OK) return 1;
   pdu = snmp_pdu_create(SET_REQ_MSG);
   ADD_X2_VAR(o_rtSelector, ri->RuleSet,ri->RuleNbr);
      vars = pdu->variables;
      SET_INT(ri->RuleSelector);
   ADD_X2_VAR(o_rtRuleMask, ri->RuleSet,ri->RuleNbr);
      vars = vars->next_variable;
      SET_STRING(ri->RuleMask,RULE_ADDR_LEN);
   ADD_X2_VAR(o_rtMatchedValue, ri->RuleSet,ri->RuleNbr);
      vars = vars->next_variable;
      SET_STRING(ri->RuleMatchedValue,RULE_ADDR_LEN);
   ADD_X2_VAR(o_rtRuleAction, ri->RuleSet,ri->RuleNbr);
      vars = vars->next_variable;
      SET_INT(ri->RuleAction);
   ADD_X2_VAR(o_rtJumpIndex, ri->RuleSet,ri->RuleNbr);
      vars = vars->next_variable;
      SET_INT(ri->RuleJumpIndex);

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
         if (verbose || ri->RuleNbr % 10 == 0)  /* 28 Oct 93 */
            printf("Rule %d added to table %d\n", ri->RuleNbr,ri->RuleSet);
	 }
      else {
#ifdef TESTING
	 printf("add_rule(): Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
#endif
         ms->write_OK = 0;
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);
   return 1;
   }

int add_action(struct meter_status *ms, struct flow_info *ai,
   unsigned char ActionSet,unsigned char ActionNbr,
   unsigned char *required)
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   if (!ms->write_OK) return 1;
   pdu = snmp_pdu_create(SET_REQ_MSG);
   ADD_X2_VAR(o_atLowPeerType, ActionSet,ActionNbr);
      vars = pdu->variables;
      SET_INT(ai->LowPeerType);

   if (required[FTLOWINTERFACE]) {
      ADD_X2_VAR(o_atLowInterface, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->LowInterface);
      }
   if (required[FTLOWADJACENTTYPE]) {
      ADD_X2_VAR(o_atLowAdjacentType, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->LowAdjType);
      }
   if (required[FTLOWADJACENTADDRESS]) {
      ADD_X2_VAR(o_atLowAdjacentAddress, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->LowAdjAddress,MAC_ADDR_LEN);
      }
   if (required[FTLOWADJACENTMASK]) {
       ADD_X2_VAR(o_atLowAdjacentMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->LowAdjMask,MAC_ADDR_LEN);
      }
   if (required[FTLOWPEERTYPEMASK]) {
      ADD_X2_VAR(o_atLowPeerTypeMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->LowPeerTypeMask);
      }
   if (required[FTLOWPEERADDRESS]) {
      ADD_X2_VAR(o_atLowPeerAddress, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->LowPeerAddress,PEER_ADDR_LEN);
      }
   if (required[FTLOWPEERMASK]) {
      ADD_X2_VAR(o_atLowPeerMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->LowPeerMask,PEER_ADDR_LEN);
      }
   if (required[FTLOWDETAILTYPE]) {
      ADD_X2_VAR(o_atLowDetailType, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->LowDetailType);
      }
   if (required[FTLOWDETAILTYPEMASK]) {
      ADD_X2_VAR(o_atLowDetailTypeMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->LowDetailTypeMask);
      }
   if (required[FTLOWDETAILADDRESS]) {
      ADD_X2_VAR(o_atLowDetailAddress, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->LowDetailAddress,DETAIL_ADDR_LEN);
      }
   if (required[FTLOWDETAILMASK]) {
      ADD_X2_VAR(o_atLowDetailMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->LowDetailMask,DETAIL_ADDR_LEN);
      }
   if (required[FTHIINTERFACE]) {
      ADD_X2_VAR(o_atHighInterface, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->HighInterface);
      }
   if (required[FTHIADJACENTTYPE]) {
      ADD_X2_VAR(o_atHighAdjacentType, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->HighAdjType);
      }
   if (required[FTHIADJACENTADDRESS]) {
      ADD_X2_VAR(o_atHighAdjacentAddress, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->HighAdjAddress,MAC_ADDR_LEN);
      }
   if (required[FTHIADJACENTMASK]) {
      ADD_X2_VAR(o_atHighAdjacentMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->HighAdjMask,MAC_ADDR_LEN);
      }
   if (required[FTHIPEERTYPE]) {
      ADD_X2_VAR(o_atHighPeerType, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->HighPeerType);
      }
   if (required[FTHIPEERTYPEMASK]) {
      ADD_X2_VAR(o_atHighPeerTypeMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->HighPeerTypeMask);
      }
   if (required[FTHIPEERADDRESS]) {
      ADD_X2_VAR(o_atHighPeerAddress, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->HighPeerAddress,PEER_ADDR_LEN);
      }
   if (required[FTHIPEERMASK]) {
      ADD_X2_VAR(o_atHighPeerMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->HighPeerMask,PEER_ADDR_LEN);
      }
   if (required[FTHIDETAILTYPE]) {
      ADD_X2_VAR(o_atHighDetailType, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->HighDetailType);
      }
   if (required[FTHIDETAILTYPEMASK]) {
      ADD_X2_VAR(o_atHighDetailTypeMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_INT(ai->HighDetailTypeMask);
      }
   if (required[FTHIDETAILADDRESS]) {
      ADD_X2_VAR(o_atHighDetailAddress, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->HighDetailAddress,DETAIL_ADDR_LEN);
      }
   if (required[FTHIDETAILMASK]) {
      ADD_X2_VAR(o_atHighDetailMask, ActionSet,ActionNbr);
      vars = vars->next_variable;
      SET_STRING(ai->HighDetailMask,DETAIL_ADDR_LEN);
      }

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
         if (verbose || ActionNbr % 10 == 0)  /* 28 Oct 93 */
            printf("Action %d added to table %d\n", ActionNbr,ActionSet);
	 }
      else {
#ifdef TESTING
	 printf("add_action(): Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
#endif
         ms->write_OK = 0;
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);
   return 1;
   }

int same_acct_oid(oid *a, oid *b)  
   /* Compare oids for equality within internet-accounting MIB */
{
   int j;
   for (j = 6; j != 10; ++j) {
      if (a[j] != b[j]) return 0;
      }
   return 1;
   }

int column_info(struct meter_status *ms, unsigned char *fb,
   unsigned char a, unsigned long ft, int *fn)
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;
   int result;

   if (testing) printf("column_info(ms,fb,a=%d,ft=%lu,fn=%d)\n",a,ft,*fn);
   pdu = snmp_pdu_create(GETNEXT_REQ_MSG);
   ADD_X3_VAR(o_ftColumnBlob,a,ft,*fn)
   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
	 vars = response->variables;
         if (!same_acct_oid(vars->name,o_ftColumnBlob)) 
            return 0;  /* No more flows with last-active time > ft */
	 STRING_VAL(fb);  result = vars->val_len;
	 }
      else if (response->errstat == SNMP_ERR_NOSUCHNAME) return 0;
      else {
#ifdef TESTING
	 printf("column_info(): Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 printf("This name does not exist: ");
	 for (count=1, vars = response->variables;
	    vars && count != response->errindex;
	 vars = vars->next_variable, count++) ;
	 if (vars) print_objid(vars->name, vars->name_length);
	 printf("\n");
#endif
         result = 0;
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);
   return result;
   }

int meter_is_current(struct meter_status *ms)
{
   int j;
   sprintf(ms->version,"%lu.%lu", ms->versionid[8],ms->versionid[9]);
   for (j = 0;  ;  ++j) {
      if (ms->versionid[j] != CurrentVersion[j]) return 0;
      if (CurrentVersion[j] == 0) return 1;
      }
   }

int meter_info(struct meter_status *ms)
{
   int count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   if (testing) printf("meter_info(ms), statsreqd=%d\n", ms->statsreqd);
   pdu = snmp_pdu_create(GET_REQ_MSG);
   ADD_VAR(o_sysDescr);
   ADD_VAR(o_sysVersionId);
   ADD_VAR(o_sysUpTime);
   ADD_VAR(o_LastCollectTime);
   ADD_VAR(o_CurrentRuleSet);
   ADD_VAR(o_msMaxFlows);
   if (ms->statsreqd) {
      ADD_VAR(o_msStatsTime);
      ADD_VAR(o_msNbrPackets);
      ADD_VAR(o_msTotPktBacklog);
      ADD_VAR(o_msMaxPktRate);
      ADD_VAR(o_msMaxPktBacklog);
      ADD_VAR(o_msNbrFlows);
      ADD_VAR(o_msFlowsRecovered);
      ADD_VAR(o_msRuleMatches);
      ADD_VAR(o_msHashSearches);
      ADD_VAR(o_msHashCompares);
      ADD_VAR(o_msTotalHashSize);
      ADD_VAR(o_msNbrHashEntries);
      ADD_VAR(o_msGCInterval);
      ADD_VAR(o_msAvIdle1000);
      ADD_VAR(o_msMinIdle1000);
      ADD_VAR(o_pcLostPackets);
      }

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
         if (testing) printf("   snmp response OK\n");
	 vars = response->variables;
	 STRING_VAL(ms->descr);
         vars = vars->next_variable;
	 OID_VAL(ms->versionid);
         ms->versionid[vars->val_len / sizeof(oid)] = 0;
         vars = vars->next_variable;
	 INT_VAL(ms->uptime);
         vars = vars->next_variable;
	 INT_VAL(ms->LastCollectTime);
         vars = vars->next_variable;
	 INT_VAL(ms->CurrentRuleSet);
         vars = vars->next_variable;
	 INT_VAL(ms->MaxFlows);
         if (ms->statsreqd) {
            vars = vars->next_variable;
            INT_VAL(ms->StatsTime);
            vars = vars->next_variable;
            INT_VAL(ms->NbrPackets);
            vars = vars->next_variable;
            INT_VAL(ms->TotPktBacklog);
            vars = vars->next_variable;
            INT_VAL(ms->MaxPktRate);
            vars = vars->next_variable;
            INT_VAL(ms->MaxPktBacklog);
            vars = vars->next_variable;
            INT_VAL(ms->NbrFlows);
            vars = vars->next_variable;
            INT_VAL(ms->FlowsRecovered);
            vars = vars->next_variable;
            INT_VAL(ms->RuleMatches);
            vars = vars->next_variable;
            INT_VAL(ms->HashSearches);
            vars = vars->next_variable;
            INT_VAL(ms->HashCompares);
            vars = vars->next_variable;
            INT_VAL(ms->TotalHashSize);
            vars = vars->next_variable;
            INT_VAL(ms->NbrHashEntries);
            vars = vars->next_variable;
            INT_VAL(ms->GCInterval);
            vars = vars->next_variable;
            INT_VAL(ms->AvIdle1000);
            vars = vars->next_variable;
            INT_VAL(ms->MinIdle1000);
            vars = vars->next_variable;
            INT_VAL(ms->LostPackets);
            if (testing) printf("  stats read: StatsTime=%lu\n",ms->StatsTime);
            }
	 }
      else {
	 printf("Error in packet, reason = %s\n",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   mswait(ms->snmp_delay);

   if (ms->statsreqd && ms->write_OK) {  /* Zero meter statistics */
      if (testing) printf("   about to zero meter stats\n");
      pdu = snmp_pdu_create(SET_REQ_MSG);
      ADD_VAR(o_msStatsReset);
      vars = pdu->variables;
      SET_INT(1);
      status = snmp_synch_response(ms->ss, pdu, &response);
      if (status == STAT_SUCCESS) {
         if (testing) printf("  stats zeroed\n");
         if (response->errstat != SNMP_ERR_NOERROR) {
#ifdef TESTING
	    printf("meter_info(): Error in packet, reason = %s\n",
	       snmp_errstring(response->errstat));
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
	       vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
#endif
            ms->write_OK = 0;  /* Set failed, don't try again */
	    }
         }
      else {
         return 0;
         }
      snmp_free_pdu(response);
      mswait(ms->snmp_delay);
      }
   return 1;
   }

