/* 1035, Tue 11 Aug 92

   AUTREE.H:  Data structures for AU Monitor trees

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#define N_VOID       0  /* Types of tree node */
#define N_ROOT	     1
#define N_FLOW       2
#define N_BACK_FLOW  3

struct node_header {
   struct node *llink, *rlink;
   char balance;  /* -1 = left heavy, 0 = balanced, +1 = right heavy */
   char type;
   };

struct root_info {
   unsigned int height, nbr_nodes;
   unsigned long compares, searches;
   };

struct flow {
   unsigned int flowindex;
   unsigned char kind;
   unsigned int type;
   unsigned long packets,bytes,
      s_packets,s_bytes;
   };

struct back_flow {
   int key;
   };

struct node {
   struct node_header h;
   union nb {
      struct root_info r;
      struct flow f;
      struct back_flow b;
      } i;  /* info */
   };
