/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMSTDEFS.H - string table definitions
 *
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:18:58  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMSTDEFS.H_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:18:58   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 16:38:48   gfoster
 * Copyright text was reformated.
 * 
 *    Rev 1.0   27 May 1992 16:18:56   gfoster
 * Initial revision.
 *
*/


/* String table is organized as a balanced binary tree */
typedef struct _strtab {   /* string table node */
    PSZ pszVal;                 /* string value */
    SHORT fAccess;              /* access flag */
    SHORT sBal;                 /* balance factor */
    struct _mibsym *pSym;       /* ptr to symbol list */
    struct _strtab *pLeft;      /* left link */
    struct _strtab *pRight;     /* right link */
} STRTAB;


/* internal functions */
#ifdef __STDC__
STRTAB *StrTabInsert(PSZ pszVal);
STRTAB *StrTabNew(VOID);
STRTAB *StrTabSearch(PSZ pszVal);

VOID StrTabDump(VOID);
VOID StrTabPreOrder(PSZ pszPos, STRTAB *pCur, USHORT usLev);
VOID StrTabInOrder(STRTAB *pCur);
#else
STRTAB *StrTabInsert();
STRTAB *StrTabNew();
STRTAB *StrTabSearch();

VOID StrTabDump();
VOID StrTabPreOrder();
VOID StrTabInOrder();
#endif /* __STDC__ */


/* global variables */
extern STRTAB *pStrTabRoot;     /* ptr to root of string table */
extern USHORT usStrTabHeight;   /* heigth of string table */


/* end of file: SMSTDEFS.H */
