/*
	Author		: Sreedhar Sivakumaran
	Notes		:
	
		Test functions for inport.	
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <dtmint.h>
#include <dtm.h>

#include "test.h"

#define	MILLI_PER_SECOND		1000

int	readTest( )
{
	Dtm_set	dtmset[ TEST_DTM_PORTS ] ;

	fprintf( stdout, "%%Test: Entered readTest\n" );
	if( DTMtestInputAvail( 1 ) ) {
		fprintf( stdout, "%%Test: Exit readTest, availRead - TRUE\n" );
		return TRUE ;
	} else {
		int	status;
		int	p = port_count;
		int timeout	= 15*MILLI_PER_SECOND;
		while ( p-- ) {
			dtmset[p].port = port[p];
		}
		
		status = DTMselectRead( dtmset, port_count, 0, 0, timeout ) ;
		fprintf( stdout, "%%Test: Exit readTest, selectRead status %d\n", 
				status ); 
		p = port_count;
		while ( p-- ) {
			fprintf( stdout, "%%Test: status - port '%s'(%d) = %d\n",
				 port_names[p], port[p], dtmset[p].status );
		}
		return status ;
	}
}

int	readMsg( )
{
	char	hdr[ MAXMSGLEN ] ;
	char	data[ MAXMSGLEN ] ;
	int		p = port_count;

	while ( p-- ) {
		fprintf( stdout, "%%Test: readMsg port %d: l[%s]\n", p + 1,
			port_names[p] );
		if( DTMreadMsg( port[p], hdr,  MAXMSGLEN, data, 
				MAXMSGLEN, DTM_CHAR ) == DTMERROR ) {
			fprintf( stderr, "%%Test: composite read error %s\n", 
				sherr( DTMerrno ) );
			return 0 ;
		}
		fprintf( stdout, "%%Test: Port %s, Header '%s',Data1 '%s' read\n", 
				port_names[p], hdr, data );	
	}
	fprintf( stdout, "%%Test: port_count %d\n", port_count);	
	return 1 ;
}

int	readPort( )
{
	char	buf[ MAXMSGLEN ] ;
	int		p = port_count;

	fprintf( stdout, "%%Test: readPort port_count %d\n", p );

	while ( p-- ) {
		/*	Read on inport		*/

		if( DTMbeginRead( port[p], buf, MAXMSGLEN) == DTMERROR ) { 
			fprintf( stderr, "%%Test: ERROR - Inport %d beginRead, %s\n",
				port, sherr( DTMerrno ) );	
			return 0 ;
		} else {
			fprintf( stdout, "%%Test: Port %s, Header '%s' read \n", 
					port_names[p], buf );	
		}

		while ( TRUE ) {
			int		size;
			int		stemp;
			if( (size =  DTMreadDataset( port[p], buf,  MAXMSGLEN, DTM_CHAR ))
						== DTMERROR ) {
				fprintf( stderr, "%%Test: ERROR - Inport %d readDataset, %s\n",
					port[p], sherr( DTMerrno ) );
				return 0 ;
			} 
			if ( size == 0 ) break;
			stemp = size;
			while ( stemp > 1 ) {
				fprintf( stdout, "%%Test: Port %s, Data '%s' read \n",
						port_names[p], &buf[size - stemp] );
				stemp -= strlen( &buf[size - stemp ] ) + 1;
			}
		}

		if( DTMendRead( port[p] ) == DTMERROR ) {
			fprintf( stderr, "%%Test: ERROR - Inport %d, endRead, %s\n",
				port[p], sherr( DTMerrno ) );
			return 0 ;
		} else {
			fprintf( stdout, "%%Test: Port %d, Read over\n", port[p] );
		}
	}
		
	return 1 ;
}
