
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)help.c	1.5	(NCSA)	8/12/87";
#endif lint

/*
** help
*/

#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>
#include <sunwindow/notify.h>
#include <sunwindow/defaults.h>
#include "session.h"
#include "machdep.h"
#include "defs.h"

static short icon_image[] = {
#include "Icons/help.icon"
};

DEFINE_ICON_FROM_IMAGE(help_icon, icon_image);

/*
** initialize the help menu
*/

Menu					help_menu;
char 					help_dir[1000];
extern struct Pixfont	*zzbold;

init_help_menu()
{
	caddr_t version();
	caddr_t	overview_help();
	caddr_t	session_help();
	caddr_t	emulation_help();
	caddr_t	options_help();
	caddr_t	keyboard_help();

	strcpy(help_dir, defaults_get_string("/Teltool/Default_Help_Dir",
			DEFHELPDIR, 0));
				
	help_menu = menu_create(MENU_FONT, zzbold,
							MENU_ITEM,
							MENU_STRING,"Version",
							MENU_ACTION_PROC,version,
							0,
							MENU_ITEM,
							MENU_STRING,"Overview",
							MENU_ACTION_PROC,overview_help,	/* 2 */
							0,
							MENU_ITEM,
							MENU_STRING,"Session",
							MENU_ACTION_PROC,session_help,	/* 3 */
							0,
							MENU_ITEM,
							MENU_STRING,"Emulation",
							MENU_ACTION_PROC,emulation_help,	/* 4 */
							0,
							MENU_ITEM,
							MENU_STRING,"Options",
							MENU_ACTION_PROC,options_help,	/* 5 */
							0,
							MENU_ITEM,
							MENU_STRING,"Keyboard",
							MENU_ACTION_PROC,keyboard_help,	/* 6 */
							0,
							0);

}

/*
** notify proc for help menu 
*/

Notify_value helphandler(item, event)
Panel_item item;
Event *event;
{
	extern Panel	menubar;

	/*
	** only process on right button down
	*/

	switch (event_id(event)) {

		case MS_RIGHT:
			if (event_is_up(event))
				return;
			menu_show(help_menu, menubar, event, 0);
			break;

		default:
			kbdhandler(Session.s_canvas, event);
			break;
	}

	return NOTIFY_DONE;
}

/*
** #1 -- version
*/

caddr_t version(m, mi)
Menu m;
Menu_item mi;
{
	extern char vers[];
	errmsg(vers,"");
}

/*
** #2 -- overview
*/

caddr_t overview_help(m, mi)
Menu m;
Menu_item mi;
{
	char help_file[1024];

	strcpy(help_file, help_dir);
	strcat(help_file, "/overview.help");
	show_help_file(help_file, "Overview Help");
	return mi;
}

/*
** #3 -- session help
*/

caddr_t session_help(m, mi)
Menu m;
Menu_item mi;
{
	char help_file[1024];

	strcpy(help_file, help_dir);
	strcat(help_file, "/session.help");
	show_help_file(help_file, "Session Help");
	return mi;
}

/*
** #4 -- emulation help
*/

caddr_t emulation_help(m, mi)
Menu m;
Menu_item mi;
{
	char help_file[1024];

	strcpy(help_file, help_dir);
	strcat(help_file, "/emulation.help");
	show_help_file(help_file, "Emulation Help");
	return mi;
}

/*
** #5 -- options help
*/

caddr_t options_help(m, mi)
Menu m;
Menu_item mi;
{
	char help_file[1024];

	strcpy(help_file, help_dir);
	strcat(help_file, "/options.help");
	show_help_file(help_file, "Options Help");
	return mi;
}

/*
** #6 -- keyboard help
*/

caddr_t keyboard_help(m, mi)
Menu m;
Menu_item mi;
{
	char help_file[1024];

	strcpy(help_file, help_dir);
	strcat(help_file, "/keyboard.help");
	show_help_file(help_file, "Keyboard Help");
	return mi;
}

/*
** show a help file in a text subwindow
*/

Frame 		help_frame;
Panel		help_panel;
Textsw		help_text;	

show_help_file(f, t)
char *f;
char *t;
{

	int				v;
	Textsw_status	status = TEXTSW_STATUS_OKAY;

	/*
	** set up the window
	*/

	init_help_frame(f, t);

	/*
	** load the file
	*/

	window_set(help_text, TEXTSW_STATUS, &status,
				TEXTSW_FILE, f,
				0);

	/*
	** if not there, error and return
	*/

	if (status != TEXTSW_STATUS_OKAY) {
		char buf[200];

		sprintf(buf, "Couldn't Load Help File.  Code = %d",status);
		errmsg(buf, "");
		window_destroy(help_frame);
		return;
	}

	window_set(help_frame, WIN_SHOW, TRUE, 0);
	window_set(help_text, TEXTSW_DISABLE_LOAD, TRUE, 0);

	return;

}

/*
** initialize the help_frame
*/

init_help_frame(f, t)
char *f;
char *t;
{
	Panel_item		done_button;
	void			done_proc();

	/*
	** create the frame
	*/

	help_frame = window_create(0, FRAME, FRAME_LABEL, t, FRAME_ICON,
				&help_icon,0);
	window_set(help_frame, FRAME_NO_CONFIRM, TRUE, 0);

	/*
	** make the done button
	*/

	help_panel = window_create(help_frame, PANEL, 0);

	done_button = panel_create_item(help_panel,
				PANEL_BUTTON,
				PANEL_NOTIFY_PROC, done_proc,
				PANEL_LABEL_IMAGE, panel_button_image(help_panel, "Done", 4,
					zzbold),
				0);

	window_fit(help_panel);

	help_text = window_create(help_frame, TEXTSW,
				WIN_ROWS, 30,
				WIN_COLUMNS, 83,
				TEXTSW_IGNORE_LIMIT,
				TEXTSW_INFINITY,
				TEXTSW_READ_ONLY,TRUE,
				TEXTSW_BROWSING, TRUE,
				TEXTSW_DISABLE_CD, TRUE,
				0);

	window_fit(help_frame);
}

/*
** done
*/

void done_proc()
{
	Textsw tp;
	Textsw tp2;
	/*
	** loop thru all split views & destroy them
	*/

	window_destroy(help_text);
	window_destroy(help_panel);
	window_destroy(help_frame);
}
