/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/DrawnB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Label.h>
#include <Xm/Form.h>

#include "view.h"
#include "doodle.h"

#include "d_arrow.xbm"
#include "d_box.xbm"
#include "d_doodle.xbm"
#include "d_erase.xbm"
#include "d_erasebox.xbm"
#include "d_line.xbm"
#include "d_oval.xbm"
#include "d_text.xbm"
#include "d_asel.xbm"
#include "d_psel.xbm"
#include "d_lsel.xbm"
#include "d_hlsel.xbm"
#include "d_vlsel.xbm"

#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif


extern Widget InitPen();
extern Widget InitPenMenu();
extern void CBGrabProc();
extern void CBClearDrawArea();
extern void CBSetPaste();
extern void CBSetPasteNoBack();
extern void CBSetLine();
extern void CBSetArrow();
extern void CBSetOval();
extern void CBSetBox();
extern void CBSetFreehand();
extern void CBSetText();
extern void CBSetErase();
extern void CBSetEraseBlock();
extern void CBSetAreaSelect();
extern void CBSetLineSelect();
extern void CBSetXLineSelect();
extern void CBSetYLineSelect();
extern void CBSetPointSelect();
extern void CBSetGlobalPointer();
extern void CBSetPolyview();
extern void CBDoContour();
extern void DrawPenPointer();
extern void SetButton();
extern void UnsetButton();
extern unsigned long BestColor();


extern Display *myDpy;
extern GC drawAreaGC;


void
InitSelMenu(V, menuBar)
	View *V;
	Widget menuBar;
{
	Cardinal i;
	Arg argList[30];
	Widget b, pulldown;
	XmString label;

	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(argList[i], XmNradioBehavior, True); i++;
	XtSetArg(argList[i], XmNradioAlwaysOne, False); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Operations");
	XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'p'); i++;
	V->operationMenu = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(V->operationMenu);
	XmStringFree(label);

    if (V->type == V_SHEET)
    {
	i = 0;
	label = XmStringCreateSimple("Histogram");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'H'); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBSetAreaSelect, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);
    }

/*
	if (V->type == V_RASTER)
	{
		i = 0;
		label = XmStringCreateSimple("X-Y Plot");
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNmnemonic, 'l'); i++;
		XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
		b = XmCreateToggleButtonGadget(pulldown, "toggleButton",
			argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBSetLineSelect,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);

		i = 0;
		label = XmStringCreateSimple("X Axis Slice");
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNmnemonic, 'X'); i++;
		XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
		b = XmCreateToggleButtonGadget(pulldown, "toggleButton",
			argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBSetXLineSelect,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);

		i = 0;
		label = XmStringCreateSimple("Y Axis Slice");
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNmnemonic, 'Y'); i++;
		XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
		b = XmCreateToggleButtonGadget(pulldown, "toggleButton",
			argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBSetYLineSelect,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	}

*/
    if (V->type == V_SHEET)
    {
	i = 0;
	label = XmStringCreateSimple("Point Selection");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBSetPointSelect, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);
    }

/*
	i = 0;
	label = XmStringCreateSimple("Global Pointer");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'G'); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBSetGlobalPointer,
		(caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);
*/

	if (V->type == V_RASTER)
	{
		i = 0;
		label = XmStringCreateSimple("Contour");
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
		b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
		XtAddCallback(b, XmNactivateCallback, CBDoContour, (caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);

	    if (strcmp(V->cData->name, "Polyview 3.0 Image") == 0)
	    {
		i = 0;
		label = XmStringCreateSimple("Polyview");
		XtSetArg(argList[i], XmNlabelString, label); i++;
		XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
		XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
		b = XmCreateToggleButtonGadget(pulldown, "viewer", argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBSetPolyview,
			(caddr_t)V);
		XtManageChild(b);
		XmStringFree(label);
	    }
	}
}


void
CBExposeWidth(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	int width = (int)client_data;
	int y;
	XWindowAttributes attr;
	Cardinal i;
	Arg argList[10];
	Pixel fg;

	i = 0;
	XtSetArg(argList[i], XmNforeground, &fg); i++;
	XtGetValues(w, argList, i);
	XSetForeground(myDpy, drawAreaGC, fg);

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);
	y = attr.height / 2;

	XSetLineAttributes(myDpy, drawAreaGC, width, LineSolid,
		CapButt, JoinBevel);
	XDrawLine(myDpy, XtWindow(w), drawAreaGC, 0, y, attr.width, y);

	XSetLineAttributes(myDpy, drawAreaGC, 0, LineSolid,
		CapButt, JoinBevel);
}

void
CBWidth1(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 1;
}
void
CBWidth2(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 2;
}
void
CBWidth3(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 3;
}
void
CBWidth4(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 4;
}
void
CBWidth5(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 5;
}
void
CBWidth7(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 7;
}
void
CBWidth9(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 9;
}
void
CBWidth10(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 10;
}
void
CBWidth15(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 15;
}
void
CBWidth20(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	V->doodleWidth = 20;
}


/*
 * Create a doodle overlay menu off the passed menubar.  Returns the widget
 * id of the setColor widget, since that is the only widget in the menu
 * that ever needs to be modified after creation.
 */
Widget
InitOptions(V, menuBar)
	View *V;
	Widget menuBar;
{
	Cardinal i;
	Arg argList[30];
	Widget b, pulldown;
	Widget setColor, pen;
	Widget overlayPulldown;
	char lab[20];
	XmString label;

	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(argList[i], XmNradioBehavior, True); i++;
	XtSetArg(argList[i], XmNradioAlwaysOne, False); i++;
	overlayPulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	/*
	 * Overlay menu
	 */
	i = 0;
	label = XmStringCreateSimple("Options");
	XtSetArg(argList[i], XmNsubMenuId, overlayPulldown); i++;
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'O'); i++;
	V->optionMenu = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(V->optionMenu);
	XmStringFree(label);

/* EJB
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(argList[i], XmNradioBehavior, True); i++;
	XtSetArg(argList[i], XmNradioAlwaysOne, False); i++;
	pulldown = XmCreatePulldownMenu(overlayPulldown, "pulldown",
		argList, i);

	i = 0;
	label = XmStringCreateSimple("Clear");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'e'); i++;
	XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
	b = XmCreateCascadeButton(overlayPulldown, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Eraser");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'E'); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBSetErase, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);
*/

	sprintf(lab, "       ");
	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth1, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)1);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth3, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)3);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth5, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)5);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth7, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)7);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth10, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)10);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth15, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)15);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple(lab);
	XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButton(overlayPulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBWidth20, (caddr_t)V);
	XtAddEventHandler(b, ExposureMask, 0, CBExposeWidth, (caddr_t)20);
	XtManageChild(b);
	XmStringFree(label);

	return(V->optionMenu);
}

