/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>

#ifdef HDF32
#include <hdf/hdf.h>
#else
#include <hdf/df.h>
#endif

#include "view.h"


#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif


extern Display *myDpy;
extern Widget rootWidget;


struct img_rec {
	unsigned int width, height;
	unsigned char *imgptr;
	unsigned char *palptr;
};

Widget fileBox = (Widget)0;
Boolean fileBoxOpen = False;


void CBSaveImageOk();
void CBSaveImageCancel();


InitRasSave(V)
	View *V;
{
        fileBox = XmCreateFileSelectionDialog(rootWidget, "fileSelectionBox",
                        NULL, 0);
        fileBoxOpen = False;
}


void
CBSaveImageCancel(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	struct img_rec *iptr = (struct img_rec *)client_data;

	XtUnmanageChild(fileBox);
	fileBoxOpen = False;

        XtRemoveCallback(fileBox, XmNokCallback, CBSaveImageOk, (caddr_t)iptr);
        XtRemoveCallback(fileBox, XmNcancelCallback, CBSaveImageCancel,
		(caddr_t)iptr);

	FREE((char *)iptr->palptr);
	FREE((char *)iptr->imgptr);
	FREE((char *)iptr);
}


void
CBSaveImageOk(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	struct img_rec *iptr = (struct img_rec *)client_data;
	XmFileSelectionBoxCallbackStruct *fsb =
		(XmFileSelectionBoxCallbackStruct *)call_data;
	char *fileName;

	if (fileBoxOpen == False)
	{
		return;
	}

	XtUnmanageChild(fileBox);
	fileBoxOpen = False;

	XmStringGetLtoR(fsb->value, XmSTRING_DEFAULT_CHARSET, &fileName);
	if (iptr->palptr != NULL)
	{
		DFR8setpalette(iptr->palptr);
	}
	DFR8addimage(fileName, (VOIDP)iptr->imgptr, iptr->width, iptr->height,
		DFTAG_RLE);
/*
	DFR8putimage(fileName, iptr->imgptr, iptr->width, iptr->height,
		DFTAG_RLE);
*/

        XtRemoveCallback(fileBox, XmNokCallback, CBSaveImageOk, (caddr_t)iptr);
        XtRemoveCallback(fileBox, XmNcancelCallback, CBSaveImageCancel,
		(caddr_t)iptr);

	if (iptr->palptr != NULL)
	{
		FREE((char *)iptr->palptr);
	}
	FREE((char *)iptr->imgptr);
	FREE((char *)iptr);
}


void
CBRasSaveImage(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	unsigned int width, height;
	unsigned char *palptr;
	unsigned char *imgptr;
	struct img_rec *iptr;

	if (fileBox == (Widget)0)
	{
		InitRasSave(V);
	}

        if (fileBoxOpen)
	{
                XRaiseWindow(XtDisplay(fileBox),XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
	}

	if (V->cData->hasPalette)
	{
		palptr = (unsigned char *)MALLOC(768);
		bcopy(V->cData->pal->rgb, palptr, 768);
	}
	else
	{
		palptr = NULL;
	}

	width = V->cData->xdim;
	height = V->cData->ydim;
	imgptr = (unsigned char *)MALLOC(width * height *
			sizeof(unsigned char));
	bcopy(V->cData->buff, imgptr, (width * height));

	iptr = (struct img_rec *)MALLOC(sizeof(struct img_rec));
	iptr->width = width;
	iptr->height = height;
	iptr->palptr = palptr;
	iptr->imgptr = imgptr;

        XtManageChild(fileBox);
        XtAddCallback(fileBox, XmNokCallback, CBSaveImageOk, (caddr_t)iptr);
        XtAddCallback(fileBox, XmNcancelCallback, CBSaveImageCancel,
		(caddr_t)iptr);
        fileBoxOpen = True;
}


void
CBRasSaveOverlay(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	Cardinal argcnt;
	Arg argList[10];
	Pixel bg;
	XImage *img1;
	XImage *img2;
	int whiteboard;
	int x, y;
	unsigned int width, height;
	unsigned char *ptr;
	unsigned char *palptr;
	unsigned char *imgptr;
	struct img_rec *iptr;

	if (fileBox == (Widget)0)
	{
		InitRasSave(V);
	}

        if (fileBoxOpen)
	{
                XRaiseWindow(XtDisplay(fileBox),XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
	}

	if (V->type == V_WHITEBOARD)
	{
		whiteboard = 1;
	}
	else
	{
		whiteboard = 0;
	}

	argcnt = 0;
	XtSetArg(argList[argcnt], XmNbackground, &bg); argcnt++;
	XtGetValues(V->drawArea, argList, argcnt);

	if (V->cData->hasPalette)
	{
		palptr = (unsigned char *)MALLOC(768);
		bcopy(V->cData->pal->rgb, palptr, 768);
	}
	else
	{
		palptr = NULL;
	}

	width = V->cData->xdim;
	height = V->cData->ydim;
	imgptr = (unsigned char *)MALLOC(width * height *
			sizeof(unsigned char));

	if (!whiteboard)
	{
#ifdef DEBUG
		printf("Doing a XGetImage(%x,%x,%d,%d,%d,%d,%x,%x)\n",
			myDpy, V->drawPix, 0, 0, width, height,
                        AllPlanes, ZPixmap);

#endif
		img1 = XGetImage(myDpy, V->drawPix, 0, 0, width, height,
			AllPlanes, ZPixmap);
	}
#ifdef DEBUG
		printf("Doing a XGetImage(%x,%x,%d,%d,%d,%d,%x,%x)\n",
			myDpy, V->doodlePix, 0, 0, width, height,
                        AllPlanes, ZPixmap);
#endif
	img2 = XGetImage(myDpy, V->doodlePix, 0, 0, width, height,
		AllPlanes, ZPixmap);

	ptr = imgptr;
	for (y=0; y<height; y++)
	{
		for (x=0; x<width; x++)
		{
			unsigned long p1, p2;
			if (!whiteboard)
			{
				p1 = XGetPixel(img1, x, y);
			}
			p2 = XGetPixel(img2, x, y);
			if ((!whiteboard)&&(p2 == p1))
			{
				*ptr++ = (unsigned char)bg;
			}
			else
			{
				*ptr++ = (unsigned char)p2;
			}
		}
	}

	XDestroyImage(img2);
	if (!whiteboard)
	{
		XDestroyImage(img1);
	}

	iptr = (struct img_rec *)MALLOC(sizeof(struct img_rec));
	iptr->width = width;
	iptr->height = height;
	iptr->palptr = palptr;
	iptr->imgptr = imgptr;

        XtManageChild(fileBox);
        XtAddCallback(fileBox, XmNokCallback, CBSaveImageOk, (caddr_t)iptr);
        XtAddCallback(fileBox, XmNcancelCallback, CBSaveImageCancel,
		(caddr_t)iptr);
        fileBoxOpen = True;
}


void
CBRasSaveImageOverlay(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	XImage *img;
	int x, y;
	unsigned int width, height;
	unsigned char *ptr;
	unsigned char *palptr;
	unsigned char *imgptr;
	struct img_rec *iptr;

	if (fileBox == (Widget)0)
	{
		InitRasSave(V);
	}

        if (fileBoxOpen)
	{
                XRaiseWindow(XtDisplay(fileBox),XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
	}

	if (V->cData->hasPalette)
	{
		palptr = (unsigned char *)MALLOC(768);
		bcopy(V->cData->pal->rgb, palptr, 768);
	}
	else
	{
		palptr = NULL;
	}

	width = V->cData->xdim;
	height = V->cData->ydim;
	imgptr = (unsigned char *)MALLOC(width * height *
			sizeof(unsigned char));

	img = XGetImage(myDpy, V->doodlePix, 0, 0, width, height,
		AllPlanes, ZPixmap);

	ptr = imgptr;
	for (y=0; y<height; y++)
	{
		for (x=0; x<width; x++)
		{
			unsigned long p;
			p = XGetPixel(img, x, y);
			*ptr++ = (unsigned char)p;
		}
	}

	XDestroyImage(img);

	iptr = (struct img_rec *)MALLOC(sizeof(struct img_rec));
	iptr->width = width;
	iptr->height = height;
	iptr->palptr = palptr;
	iptr->imgptr = imgptr;

        XtManageChild(fileBox);
        XtAddCallback(fileBox, XmNokCallback, CBSaveImageOk, (caddr_t)iptr);
        XtAddCallback(fileBox, XmNcancelCallback, CBSaveImageCancel,
		(caddr_t)iptr);
        fileBoxOpen = True;
}

