/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: threeDim.c,v 1.1 1993/05/17 16:49:46 gbourhis Exp $";
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/ToggleBG.h>
#include <Xm/TextF.h>
#include <Xm/Scale.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include "data.h"
#include "netdata.h"
#include "view.h"
#include "list.h"

typedef enum { X_Axe = 0, Y_Axe = 1, Z_Axe = 2} Axe;
typedef struct {
	struct view_rec view;
	char *name;
	Data *net_data;
	Axe axe;
	unsigned int slice_number;
} PanelView;

#define TextWidget colwin
#define MaxLabel   rowwin
#define MainForm   toolform
#define ScaleWidget hscroll

static List panelList;


Cdata *ExtractSlice(axe, slice, netData)
    Axe axe;			/* perpendicular to the slice */
    unsigned slice;		/* slice number */
    Data *netData;		/* a 3D scientific dataset  */
{
	int sizeOfElt;
	int base_address, x_inc, y_inc, xdim, ydim;
	Cdata *cData;
	float *datBuff;
	float *inFloat;
	int *inInt;
	int i, j;
	static char axeName[3] = {'|',0, 0} ;

	if (netData->dost == DOST_Float)
		sizeOfElt = sizeof(float);
	else if (netData->dost == DOST_Int32)
		sizeOfElt = sizeof(int);
	else
		return NULL;
	switch (axe) {
	    case X_Axe:
		base_address = slice;
		x_inc = netData->dim[0] * netData->dim[1];
		xdim = netData->dim[2];
		y_inc = netData->dim[0], ydim = netData->dim[1];
		axeName[1] = 'X';
		break;
	    case Y_Axe:
		base_address = slice * netData->dim[0];
		x_inc = 1; xdim = netData->dim[0];
		y_inc = netData->dim[0] * netData->dim[1];
		ydim = netData->dim[2];
		axeName[1] = 'Y';
		break;
	    case Z_Axe:
		base_address = slice * netData->dim[0] * netData->dim[1];
		x_inc = 1; xdim = netData->dim[0];
		y_inc = netData->dim[0]; ydim = netData->dim[1];
		axeName[1] = 'Z';
		break;
	}
	if ((cData = CdataNew()) == NULL)
		return;
	datBuff = cData->fbuff = (float *)MALLOC(xdim*ydim*sizeOfElt);
	cData->name = (char *)MALLOC(strlen(netData->label) + 3);
	if (cData->fbuff == NULL || cData->name == NULL) {
		ErrMesg("Out of Memory\n");
		return NULL;
	}
	cData->xdim = xdim;
	cData->ydim = ydim;
	cData->min = netData->min;
	cData->max = netData->max;
	strcat(strcpy(cData->name, netData->label), axeName);
	if (netData->dost == DOST_Float) {
		cData->type = D_FLOAT;
		inFloat =  ((float *)netData->data) + base_address;
		for (j=0; j<ydim; j++)
			for (i=0; i<xdim; i++)
				datBuff[j*xdim+i] = inFloat[j*y_inc+i*x_inc];
	}
	else {			/* DOST_Int32 */
		cData->type = D_INT;
		inInt = ((int *)netData->data) + base_address;
		for (j=0; j<ydim; j++)
			for (i=0; i<xdim; i++)
				((int *)datBuff)[j*xdim+i] =
					inInt[j*y_inc+i*x_inc];
	}
	return cData;
}


static PanelView *
PanelSearchByName(name)
    char *name;
{
	PanelView *p;
	for (p = (PanelView *)ListHead(panelList); p && strcmp(p->name, name);
	     p = (PanelView *)ListNext(panelList))
		;		/* empty statement */
	return p;
}

static void
CBshowSpreadSheet(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	PanelView *panel = (PanelView *)client_data;
	Data *netData = panel->net_data, *d;
	Cdata *cData;

	cData = ExtractSlice(panel->axe, panel->slice_number, netData);
	if (cData == NULL)
		return;
	d = DataNew();
	if (d != NULL) {
		d->label = cData->name;
		d->entity = ENT_Network;
		d->view_type = V_SHEET;
		d->dot = DOT_Array;
		d->dost = netData->dost;
		d->rank = 2;
		d->dim[0] = cData->xdim;
		d->dim[1] = cData->ydim;
		d->min = netData->min;
		d->max = netData->max;
		d->data = (GenericPtr)cData->fbuff;
		d->group = NULL;
		(void)NetSendDataObject(0, d, True /*shouldCopy*/,
					True /*distributeInternally*/,
					"Slicer");
	}
	FREE(cData);
	return;
}
	
static void
CBmakeImage(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	PanelView *panel = (PanelView *)client_data;
	Data *netData = panel->net_data;
	Cdata *cData;

	cData = ExtractSlice(panel->axe, panel->slice_number, netData);
	if (cData != NULL) {
		panel->view.cData = cData;
		CBGetMagnification(w, (caddr_t)&(panel->view), (caddr_t)0);
	}
	return;
}


static void
CBtoggleAxe(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	if (((XmToggleButtonCallbackStruct *)call_data)->set) {
		char lastSliceValStr[40];
		Arg argList[2];
		Cardinal i;
		static PanelView *panel;
		static Arg arg = { XmNuserData, (XtArgVal)&panel};
		int dimOfSelAxe;

		XtGetValues(w, &arg, (Cardinal)1);
		panel->axe = (Axe)client_data;
		dimOfSelAxe = panel->net_data->dim[(int)panel->axe];
		sprintf(lastSliceValStr, "%d", dimOfSelAxe-1);
		XtSetArg(argList[0], XmNlabelString,
			 XmStringCreateSimple(lastSliceValStr));
		XtSetValues(panel->view.MaxLabel, argList, (Cardinal)1);
		i =0;
		if (panel->slice_number >= dimOfSelAxe) {
			XtSetArg(argList[i], XmNvalue, dimOfSelAxe-1); i++;
			XmTextFieldSetString(panel->view.TextWidget,
					     lastSliceValStr);
			panel->slice_number = dimOfSelAxe-1;
		}
		XtSetArg(argList[i], XmNmaximum, dimOfSelAxe-1); i++;
		XtSetValues(panel->view.ScaleWidget, argList, i);
	}
}

static void
CBSliceChanged(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	int value = ((XmScaleCallbackStruct *)call_data)->value;
	PanelView *panel = (PanelView *)client_data;
	static char valStr[40];

	panel->slice_number = value;
	sprintf(valStr, "%d", value);
	XmTextFieldSetString(panel->view.TextWidget, valStr);
}


static void
CBTextActivate(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	int value;
	PanelView *panel = (PanelView *)client_data;
	char *valStr, *sptr;
	int dimOfSelAxe = panel->net_data->dim[(int)panel->axe];

	valStr = XmTextFieldGetString(w);
	value = strtol(valStr, &sptr, 0);
	if (sptr != valStr && value >= 0 && value < dimOfSelAxe) {
		panel->slice_number = value;
		XmScaleSetValue(panel->view.ScaleWidget, value);
	}
	XtFree(valStr);
}


static void
CBdestroyPanel(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	PanelView *panel = (PanelView *)client_data;

	ListDeleteEntry(panelList, panel);
	DataDestroy(panel->net_data);
	FREE(panel);
}

static void
CBClosePanel(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
	XtDestroyWidget(((PanelView *)client_data)->view.shell);
}

static void
CheckMinMax(netData)
    Data *netData;
{
	if (netData->dost == DOST_Float) {
		if (netData->min.f == netData->max.f)
			SetMinMax(netData->data,
				  netData->dim[0]*netData->dim[1],
				  netData->dim[2], &netData->min.f,
				  &netData->max.f);
	}
	else if (netData->dost == DOST_Int32) {
		if (netData->min.i == netData->max.i)
			SetIntMinMax(netData->data,
				     netData->dim[0]*netData->dim[1],
				     netData->dim[2], &netData->min.i,
				     &netData->max.i);
	}
}

static PanelView *
Init3DPanel(netData)
    Data *netData;
{
	PanelView *panel;
	View *view;
	Arg argList[20];
	Cardinal i;
	int j;
	extern Widget rootWidget;
	Widget b, radioBox, scaleWidget, sepWidget;
	static char axeName[3] = { 'X', 'Y', 'Z' };
	static char labelSlice[] = "X slice";
	char lastSliceValStr[40];

	panel = (PanelView *)calloc(1, sizeof(PanelView));
	if (panel == NULL) {
		ErrMesg("Out of Memory.\n");
		return NULL;
	}
	view = &(panel->view);
	view->type = V_3DPANEL;
	panel->name = netData->label;
	panel->net_data = netData;
	CheckMinMax(netData);
	panel->axe = X_Axe;
	i = 0;
	XtSetArg(argList[i], XmNiconName, panel->name); i++;
	view->shell = XtCreatePopupShell("Panel_3D", topLevelShellWidgetClass,
					 rootWidget, argList, i);
	XtAddCallback(view->shell, XtNdestroyCallback, CBdestroyPanel,
		      (caddr_t)panel);

	i = 0;
	view->MainForm = XmCreateForm(view->shell, "panelMainForm",
				      argList, i);
	XtManageChild(view->MainForm);
	radioBox = XmCreateRadioBox(view->MainForm, "axes", argList, i);
	XtManageChild(radioBox);

	for (j=0; j<3; j++) {
		labelSlice[0] = axeName[j];
		i = 0;
		if (! j)
			XtSetArg(argList[i], XmNset, True), i++;
		XtSetArg(argList[i], XmNlabelString,
			 XmStringCreateSimple(labelSlice)); i++;
		XtSetArg(argList[i],XmNshadowThickness,0); i++;
		XtSetArg(argList[i], XmNuserData, panel); i++;
		b = XmCreateToggleButtonGadget(radioBox, "axe", argList, i);
		XtAddCallback(b, XmNvalueChangedCallback, CBtoggleAxe, 
			      (caddr_t)j);
		XtManageChild(b);
	}
				/* scale for the slice number */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmHORIZONTAL); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, radioBox); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNmaximum, netData->dim[0]-1); i++;
	view->ScaleWidget = scaleWidget =
		XmCreateScale(view->MainForm, "frame", argList, i);
	XtAddCallback(scaleWidget, XmNvalueChangedCallback, CBSliceChanged,
		      (caddr_t)panel);
				/* label for the min slice number */
	i = 0;
	XtSetArg(argList[i], XmNlabelString,
		 XmStringCreateSimple("0")); i++;
	b = XmCreateLabelGadget(scaleWidget, "scale", argList, i);
	XtManageChild(b);
				/* label for the max slice number */
	i = 0;
	sprintf(lastSliceValStr, "%d", netData->dim[0]-1);
	XtSetArg(argList[i], XmNlabelString,
		 XmStringCreateSimple(lastSliceValStr)); i++;
	view->MaxLabel = XmCreateLabelGadget(scaleWidget, "scale", argList, i);
	XtManageChild(view->MaxLabel);
	XtManageChild(scaleWidget);
				/* editable text showing slice number */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, scaleWidget); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNvalue, "0"); i++;
	view->TextWidget = XmCreateTextField(view->MainForm, "selText",
					     argList, i);
	XtAddCallback(view->TextWidget, XmNactivateCallback, CBTextActivate,
		      (caddr_t)panel);
	XtManageChild(view->TextWidget);
				/* label  */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, scaleWidget); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, radioBox); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNrightWidget, view->TextWidget); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET);
	i++;
	XtSetArg(argList[i], XmNbottomWidget, view->TextWidget); i++;
	XtSetArg(argList[i], XmNlabelString,
		 XmStringCreateSimple("Selection")); i++;
	b = XmCreateLabelGadget(view->MainForm, "label", argList, i);
	XtManageChild(b);
				/* separator */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, radioBox); i++;
	XtSetArg(argList[i], XmNshadowThickness, 2); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	sepWidget = XmCreateSeparatorGadget(view->MainForm, "separator",
				    argList, i);
	XtManageChild(sepWidget);
				/* Make Image button */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, sepWidget); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNrightPosition, 33); i++;
	XtSetArg(argList[i], XmNlabelString,
		 XmStringCreateSimple("Make Image")); i++;
	b = XmCreatePushButtonGadget(view->MainForm, "button",
				    argList, i);
	XtAddCallback(b, XmNactivateCallback, CBmakeImage,
		      (caddr_t)panel);
	XtManageChild(b);
				/* Show Spreadsheet button */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, sepWidget); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNleftPosition, 34); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNrightPosition, 66); i++;
	XtSetArg(argList[i], XmNlabelString,
		 XmStringCreateSimple("Show Spreadsheet")); i++;
	b = XmCreatePushButtonGadget(view->MainForm, "button",
				    argList, i);
	XtAddCallback(b, XmNactivateCallback, CBshowSpreadSheet,
		      (caddr_t)panel);
	XtManageChild(b);
				/* Close button */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, sepWidget); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNleftPosition, 67); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNlabelString,
		 XmStringCreateSimple("Close")); i++;
	b = XmCreatePushButtonGadget(view->MainForm, "button",
				    argList, i);
	XtAddCallback(b, XmNactivateCallback, CBClosePanel, (caddr_t)panel);
	XtManageChild(b);

	XtPopup(view->shell, XtGrabNone);

	return panel;
}

static void
UpdatePanel(panel, netData)
    PanelView *panel;
    Data *netData;
{
	panel->net_data = netData;
}


void Got3Dsds(netData, new)
    Data *netData;
    int new;
{
	PanelView *panel;
	static int first = True;

	if (first)
	{
		first = False;
		panelList = ListCreate();
	}

	if (netData->rank != 3)
		return;

	if (new) {
		panel = Init3DPanel(netData);
		if (panel != NULL)
			ListAddEntry(panelList, panel);
	}
	else {
		panel = PanelSearchByName(netData->label);
		if (panel != NULL)
			UpdatePanel(panel, netData);
		else if ((panel = Init3DPanel(netData)) != NULL)
			ListAddEntry(panelList, panel);
	}
}
