/* gminmax.h - macro */

#if defined(LTGT) && defined(MSG_TYPE)
#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#undef  DIRECT_METHOD
#ifndef MULTIP
#define MULTIP
#define DIRECT_METHOD
#endif

static int FUNC(data, ndata, result, procindex)
     TYPE *data;
     int ndata;
     TYPE *result;
     int *procindex;
{
  int procindex_comes_too;

  if (ME > 0) { /* Nodes with # > 0  */
    pvm_initsend(INITHOW_node);
    PACK(data, ndata, 1);          /* Send my contribution */
    pvm_send(NODEID[0], MSG_TYPE);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(4,0,MSG_TYPE,MULTIP sizeof(*data) * ndata);
      TRACEF(7,MSG_SUM);
    }
#endif
    
    pvm_recv(ANYBODY, MSG_TYPE);
    UNPACK(result, ndata, 1);
    pvm_upkint(&procindex_comes_too,1,1);
    if (procindex && procindex_comes_too > 0) {
      pvm_upkint(procindex, ndata, 1);
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(8,0,MSG_TYPE,MULTIP sizeof(*data) * ndata);
    }
#endif
  }
  else { /* Node == 0 */
    int i, j;
    TYPE *tmp = (TYPE *)malloc( MULTIP ndata * sizeof(*tmp) );

    if (result != data) {
      for (i=0; i<MULTIP ndata; i++) {
	result[i] = data[i];
      }
    }

    for (j=1; j<NUMNODES; j++) {
      int source, bufid;

#ifdef PICL
      if (logfp) {
	TRACETIME();
	TRACEF(7,MSG_TYPE);
      }
#endif

      bufid = pvm_recv(ANYBODY, MSG_TYPE);
      if (procindex) recvinfo(bufid,&source,NULL,NULL);

      UNPACK(tmp, ndata, 1);       /* Recv somebody's contribution */

#ifdef PICL
      if (logfp) {
	int source;
	recvinfo(NOCARE, &source, NULL, NULL);
	TRACETIME();
	TRACEF(8,source,MSG_TYPE,MULTIP sizeof(*data) * ndata);
      }
#endif


#ifdef DIRECT_METHOD
      for (i=0; i<ndata; i++) {
	if (tmp[i] LTGT result[i]) {
	  result[i] = tmp[i];
	  if (procindex) procindex[i] = source;
	}
      } /* for (i=0; i<ndata; i++) */
#else       /* COMPLEX-pair */
      for (i=0; i<2*ndata; i += 2) {
	TYPE t = tmp[i]*tmp[i] + tmp[i+1]*tmp[i+1];
	TYPE r = result[i]*result[i] + result[i+1]*result[i+1];
	if (t LTGT r) {
	  result[i] = tmp[i];
	  result[i+1] = tmp[i+1];
	  if (procindex) procindex[i] = source;
	}
      } /* for (i=0; i<2*ndata; i += 2) */
#endif
    }
      
    free(tmp);

    pvm_initsend(INITHOW_node);
    PACK(result, ndata, 1);
    procindex_comes_too = procindex ? 1 : 0;
    pvm_pkint(&procindex_comes_too,1,1);    
    if (procindex) pvm_pkint(procindex, ndata, 1);
    pvm_mcast(&NODEID[1], NUMNODES-1, MSG_TYPE);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      for (i=1; i<NUMNODES; i++) 
	TRACEF(4,i,MSG_TYPE,MULTIP sizeof(*data) * ndata);
    }
#endif


  }

  return 0;
}


#undef DIRECT_METHOD
#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */
#endif  /* defined(LTGT) && defined(MSG_TYPE) */
