#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define MAXMSGS_PENDING 100   /* Enough ? */

typedef struct msg_context {  /* Message context to be stored/restored */
  int is_recv;
  int done;
  int active;
  int datatype;
  int stride;
  int src_dest;
  int msgtag;
  void *data;
  int ndata;
} MSG_Context;


static MSG_Context msgctx[MAXMSGS_PENDING] = { 0 };

static void assign(m, is_recv, bufid, src_dest, msgtag, data, ndata)
     MSG_Context *m;
     int is_recv;
     int bufid;
     int src_dest; 
     int msgtag;
     void *data;
     int ndata;
{
  if (m) {
    m->is_recv  = is_recv;
    m->done = (bufid > 0 || !is_recv) ? 1 : 0;
    m->active   = 1;        /* Gets inactivated only upon msgdone/-wait calls */
    m->datatype = DATATYPE;
    m->stride   = STRIDE;
    m->src_dest = src_dest;
    m->msgtag   = msgtag;
    m->data     = data;
    m->ndata    = ndata;
  }
}

int isend(src_dest, msgtag, data, ndata)
     int src_dest; 
     int msgtag;
     void *data; 
     int ndata;
{ /* A weak solution ...: recv() & send() pending buffers may overlap !  */
  MSG_Context *m = NULL;
  int bufid = send(src_dest,msgtag,data,ndata); /* Non-blocking, but not async
						   anyway ! */

  if (bufid < 0 || bufid >= MAXMSGS_PENDING) {
    fprintf(stderr,"isend(@%d): Invalid bufid %d. Range [0..%d]\n",
            ME,bufid,MAXMSGS_PENDING-1);
    killproc(ME);
  }
  
  m = &msgctx[bufid];

  /* Store settings for subsequent msgdone() or msgwait() */

  assign(m,0,bufid,src_dest,msgtag,data,ndata);

  return bufid;
}

int irecv(src_dest, msgtag, data, ndata)
     int src_dest;
     int msgtag;
     void *data;
     int ndata;
{
  MSG_Context *m = NULL;

  /* Try with one non-blocking recv (nrecv) */

  int bufid = nrecv(src_dest,msgtag,data,ndata);

  if (bufid < 0 || bufid >= MAXMSGS_PENDING) {
    fprintf(stderr,"irecv(@%d): Invalid bufid %d. Range [0..%d]\n",
	    ME,bufid,MAXMSGS_PENDING-1);
    killproc(ME);
  }

  m = &msgctx[bufid];

  /* Store settings for subsequent msgdone() or msgwait() */

  assign(m,1,bufid,src_dest,msgtag,data,ndata);

  return bufid;
}


static int getmsg(calledfrom, bufid, nonblocking, recvfunc)
     char *calledfrom;
     int bufid;
     int nonblocking;
     int (*recvfunc)();
{
  if (recvfunc && bufid >= 0 && bufid < MAXMSGS_PENDING) {

    MSG_Context *m = &msgctx[bufid];  

    if (m->active) {

      /* Previous irecv() already succeeded to recv() ? */

      if (m->done) {
	m->done = 1;
	m->active = 0;
	return bufid;
      }
      else {
      
	/* Restore settings and perform the actual recvfunc()-call */
      
	int olddatatype = DATATYPE;
	int oldstride = STRIDE;
	int newbufid;
	
	DATATYPE = m->datatype;
	STRIDE = m->stride;
	
	newbufid = recvfunc(m->src_dest,m->msgtag,m->data,m->ndata);
	
	DATATYPE = olddatatype;
	STRIDE = oldstride;
	
	if (nonblocking && newbufid == 0) {
	  return bufid;
	}
	else {
	  m->done = 1;
	  m->active = 0;
	  return newbufid;
	}

      } /* ! m->done */
    }
    else {
      fprintf(stderr,"%s(@%d): Attempt to read empty buffer.\n",
	      calledfrom,ME);
      killproc(ME);
    } /* ! m->active */
  }

  return bufid;
}


int msgdone(bufid)
     int bufid;
{
  return getmsg("msgdone",bufid,1,nrecv);
}

int msgwait(bufid)
     int bufid;
{
  return getmsg("msgwait",bufid,0,recv);
}

