#include "easy.h"
#include "easydefs.h"

#include <stddef.h>
#include <signal.h>

int killproc(id)
     int id;
{
  if (id == HOSTID) {
    pvm_kill(id);
  }
  else if (id == ME) {
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&ME,1,1);
    if (pvm_pstat(HOSTID) == PvmOk) 
      pvm_send(HOSTID,MSG_PANICSTOP);
    detachproc();
    exit(id);
  }
  else {
    pvm_kill(NODEID[id]);
  }
  return id;
}

int killcluster(cl_id)
     int cl_id;
{
  int i;
  int old = setcluster(cl_id);

  cl_id = getcluster();
  cluster_id[cl_id] = 0;
  if (ME != HOSTID) return old;

  for (i=0; i<NUMNODES; i++) {
    pvm_sendsig(NODEID[i],SIGTERM);
  }

  AllMPP_Info[cl_id].nnodes = 0;
  if (AllMPP_Info[cl_id].nodeid) {
    free(AllMPP_Info[cl_id].nodeid);
    AllMPP_Info[cl_id].nodeid = NULL;
  }

  /*
  if (ME != HOSTID) {
    if (AllMPP_Info[cl_id].bcast_nodeid) {
      free(AllMPP_Info[cl_id].bcast_nodeid);
      AllMPP_Info[cl_id].bcast_nodeid = NULL;
    }
  }
  */

  setcluster(NOCARE); /* Set cluster to next free (from beginning of list) */

  return old;
}
