#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#ifndef PROBE_WAIT
#define PROBE_WAIT 1000  /* microsecs wait in blocking probe */
#endif

#include <sys/types.h>
#include <sys/time.h>
#include <stddef.h>

static void usec_sleep(microsecs)
     unsigned int microsecs;
     /* Microsecond sleep */
{
  static struct timeval timeout;

  timeout.tv_sec = microsecs / 1000000;
  timeout.tv_usec = microsecs % 1000000;

  select(0,NULL,NULL,NULL,&timeout);
}


static unsigned int nonblocking_probe = 0; /* Default is blocking */

int iprobe(source, msgtag) /* Note: By reference */
     int *source;
     int *msgtag;
{
  int bufid;
  nonblocking_probe = 1;
  bufid = probe(source,msgtag);
  nonblocking_probe = 0;
  return bufid;
}

int probe(source, msgtag) /* Note: By reference */
     int *source;
     int *msgtag;
{
  int bufid;
  int nbytes;
  int src = NOCARE;
  static unsigned int microsecs = PROBE_WAIT;
  
  if ( *source == HOSTID ) {
    src = HOSTID;
  }
  else if ( *source >= 0 && *source < NUMNODES ) {
    src = NODEID[*source];
  }
  else if ( *source != NOCARE ) {
    fprintf(stderr,"probe(@%d): No such source %d\n",ME,*source);
    killproc(ME);
  }

  for (;;) { /* Match message until arrived */

    bufid = pvm_probe(src, *msgtag);

    if (bufid != 0 || nonblocking_probe) break;

    usec_sleep(microsecs);

  } /* for (;;) */

  if (bufid > 0) {
    recvinfo(bufid, source, msgtag, &nbytes);
  }
  else if (nonblocking_probe && bufid == 0) {
    return 0;
  }
  else {
    pvm_perror("probe");
    exit(1);
  }

  return bufid;
}

