#include "easy.h"
#include "easydefs.h"

int storefwd2d(source, recv_msgtag,
	       dest, send_msgtag,
	       data, nrows, ncols, offset)
     int source;
     int recv_msgtag;
     int dest;
     int send_msgtag;
     void *data; 
     int nrows; 
     int ncols;
     int offset;
{
  int recv_bufid;
  int old_sbufid, old_rbufid;
  int destx = dest;
  int src = source;

  if (ME == HOSTID) check_printfmsg_arrival();

  if (src == HOSTID) {
    src = HOSTID;
  }
  else if (src >= 0 && src < NUMNODES) {
    src = NODEID[src];
  }
  else if (src != ANYBODY) {
    fprintf(stderr,"%s(@%d): No such src %d (msgtag=%d)\n",
	    "storefwd",ME,src,recv_msgtag);
    killproc(ME);
  }
  
#ifdef PICL
  if (logfp) {
    tracemsg("storefwd2d()");
    SETIDLETIME();
  }
#endif /* PICL */
  
  recv_bufid = pvm_recv(src,recv_msgtag);
  
  if (recv_bufid < 0) {
    fprintf(stderr,"%s(@%d): Invalid bufid (src=%d, msgtag=%d)\n",
	    "storefwd",ME,src,recv_msgtag);
    killproc(ME);
  }
  

  /* Set send buffer to pnt to the recv (probe) buffer */
  old_sbufid = pvm_setsbuf(recv_bufid); 

  if (dest == NOCARE) {
    pvm_mcast(NODEID,NUMNODES,send_msgtag);
  }
  else if (dest == HOSTID) { 
    dest = HOSTID;
    pvm_send(dest,send_msgtag);
  }
  else if ( dest >= 0 && dest < NUMNODES ) {
    dest = NODEID[dest];
    pvm_send(dest,send_msgtag);
  }
  else {
    fprintf(stderr,"%s(@%d): No such destination %d\n",
	    "storefwd",ME,dest);
    killproc(ME);
  }

#ifdef PICL
  if (logfp) {
    int nbytes = getdatasize() * nrows * ncols;
    TRACEF(4,destx == HOSTID ? PICLHOST : destx,send_msgtag,nbytes);
    TRACETIME();
    UPDATEIDLETIME();
  }
#endif /* PICL */

  pvm_freebuf(old_sbufid);

  {
    extern int bypassrecv;
    old_rbufid = pvm_setrbuf(recv_bufid);

    bypassrecv = 1;     /* Bypass actual pvm_recv() and perform unpacking only */

    recv_bufid = 
      recv2d(source, recv_msgtag, data, nrows, ncols, offset);

    bypassrecv = 0;
  }

  return recv_bufid;
}


int storefwd(source, recv_msgtag,
	    dest, send_msgtag,
	    data, ndata)
     int source;
     int recv_msgtag;
     int dest;
     int send_msgtag;
     void *data;
     int ndata;
{
  return storefwd2d(source,recv_msgtag,
		    dest, send_msgtag,
		    data, ndata, 1, ndata);
}
