#include <stdio.h>
#ifdef SYSVSTR
#include <string.h>
#else
#include <strings.h>
#endif

#include "easy.h"
#include "easydefs.h"

#define WAITALL   "waitall"

int waitall_verbose = 0;

int waitall(cl_id)
     int cl_id;
{
  int nnodes = numnodes();
  MPP_Info *info;
  int retcode = 0;
  int ended_progs = 0;
  struct hostinfo *hostp=NULL;
  int nhost=0, narch=0;
  int lastval = -1;

  if (ME != HOSTID) return 1;

  if (cl_id == NOCARE || 
      cl_id < 0 || cl_id >= MAXCLUSTERS) 
    cl_id = getcluster();

  info = procinfo(cl_id);

  pvm_config(&nhost,&narch,&hostp);

  while ( ended_progs < nnodes ) {
    int bufid, nbytes, msgtag, taskid;

    check_printfmsg_arrival();

    if (waitall_verbose && lastval != ended_progs) {
      printf(
	     "%s(%d): %saiting for %d of %d nodes to finish ...\n",
	     WAITALL,cl_id,
	     (ended_progs > 0) ? "Still w" : "W",
	     nnodes-ended_progs,nnodes);
      lastval = ended_progs;
      fflush(stdout);
    }

    bufid = pvm_recv(ANYBODY,NOCARE);
    if (bufid < 0) {
      pvm_perror("waitall");
      retcode = 1;
      break;
    }

    pvm_bufinfo(bufid, &nbytes, &msgtag, &taskid);

    switch ( msgtag ) {

    case MSG_PRINTF:
      get_printfmsg();
      check_printfmsg_arrival();
      break;

    case MSG_HOSTDEL:
    case MSG_HOSTADD:
      {
	int i,j;
	int count = 1; /* Specifically for MSG_HOSTDEL */
	int *tid;
	
	if (msgtag == MSG_HOSTADD) pvm_upkint(&count,1,1);
	tid = (int *)malloc(count * sizeof(*tid));
	pvm_upkint(tid,count,1);

	if (msgtag == MSG_HOSTADD) {
	  pvm_config(&nhost,&narch,&hostp);

	  printf("%s(%d): Added %d host(s):",
		 WAITALL,cl_id,
		 count);
	  for (j=0; j<count; j++) {
	    for (i=0; i<nhost; i++) {
	      if (tid[j] == hostp[i].hi_tid) {
		printf(" %s (%s/%d/Ox%x)",
		       hostp[i].hi_name,
		       hostp[i].hi_arch,
		       hostp[i].hi_speed,
		       hostp[i].hi_tid);
		break;
	      }
	    } /* for (i=0; i<nhost; i++) */
	  } /* for (j=0; j<count; j++) */
	}
	else {

	  printf("%s(%d): Deleted host",
		 WAITALL,cl_id);
	  for (i=0; i<nhost; i++) {
	    if (tid[0] == hostp[i].hi_tid) {
	      printf(" %s (%s/%d/Ox%x)",
		     hostp[i].hi_name,
		     hostp[i].hi_arch,
		     hostp[i].hi_speed,
		     hostp[i].hi_tid);
	      break;
	    }
	  } /* for (i=0; i<nhost; i++) */

	  pvm_config(&nhost,&narch,&hostp);
	}
	printf("\n");
	fflush(stdout);

	free(tid);
      }
      break;

    case MSG_PANICSTOP:
      {
	int who;
	pvm_upkint(&who,1,1);
	printf("%s(%d): Panic stop from NODE#%d\n",
	       WAITALL,cl_id,
	       who);
	killcluster(cl_id);
      }
      return retcode;
      
    case MSG_SHUTDOWN:
      {
	int j;

	pvm_upkint(&taskid,1,1);
	
	for (j=0; j<nnodes; j++) {
	  
	  if (info->nodeid[j] == taskid) {
	    ended_progs++;
	    if (waitall_verbose) {
	      printf("%s(%d): NODE#%d (t%x) finished.\n",
		     WAITALL,cl_id,
		     j,taskid);
	      fflush(stdout);
	    }
	    break;
	  }

	} /* for (j=0; j<nnodes; j++) */
      }
      break;
      
    case MSG_QUERY:
      {
	int question;

	pvm_upkint(&question,1,1);

	switch ( question ) {

	case Q_GETLOAD: /* pipe "uptime" & get load averages */
	  {
	    double load[3];
	    char *cmd=
	      "uptime | sed 's/load average:/#/g' | awk -F# '{print $2}'";
	    FILE *fp = popen(cmd,"r");

	    load[0] = load[1] = load[2] = 0.0;

	    if (fp) {
	      fscanf(fp,"%lf, %lf, %lf",load,load+1,load+2);
	      pclose(fp);
	    }
	    
	    pvm_initsend(PvmDataDefault);
	    pvm_pkdouble(load,3,1);
	    pvm_send(taskid,Q_GETLOAD);

	  }
	  break;

	case Q_GETCLINFO: 
	  /* Get cl_id from which node-taskid-info is requested */
	  {
	    int cl_id;
	    MPP_Info *clinfo;
	    
	    pvm_upkint(&cl_id,1,1);
	    clinfo = procinfo(cl_id);

	    pvm_initsend(PvmDataDefault);
	    if (clinfo) {
	      pvm_pkint(&clinfo->nnodes,1,1);
	      pvm_pkint(clinfo->nodeid,clinfo->nnodes,1);
	    }
	    else {
	      int Numnodes=0;
	      pvm_pkint(&Numnodes,1,1);
	      pvm_pkint(&Numnodes,0,1);
	    }
	    pvm_send(taskid,Q_GETCLINFO);
		      
	  }
	  break;

	default:
	  break;
	} /* switch ( question ) */
      }
      break;
      
    default:
      pvm_perror("waitall: unexpected msg");
      break;
      
    } /* switch ( msgtag ) */
    
    fflush(stdout);

  } /* while ( ended_progs < nnodes ) */
    
  return retcode;
}

