use ExtUtils::MakeMaker;

$os = `uname`;

# look for external tools
@search_path = split(/:/, $ENV{PATH});

if($os =~ /SunOS/ ){
  push @search_path, "/usr/ccs/bin";
}

foreach $path (@search_path){
  	$full_ar = "$path/ar" if -f "$path/ar";
}


WriteMakefile(
	'NAME'         => 'Net::Whois::RIPE::RPSL',
	'VERSION_FROM' => 'RPSL.pm',   # finds $VERSION
	'PREREQ_PM'    => { Tie::IxHash => 1.21 },  # needed by TemplateAttribute
	'DEFINE'       => '',          # e.g., '-DHAVE_SOMETHING'
	'LIBS'         => ['-L./lib -lrpsl -lglib -lpthread'],
	'INC'          => '-I./include `glib-config --cflags`',
	'FULL_AR'      => $full_ar,
	'dist'         => { 
	     'COMPRESS'     => 'gzip -9f' 
	}
);
