#       addkey - add, delete keys & get values with known keys
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: addkey.pl,v 2.3 1998/07/15 18:01:21 joao Exp $
#
#	$RCSfile: addkey.pl,v $
#	$Revision: 2.3 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:21 $


sub getvalues {
    local(*db, $key) = @_;

    local($value)=$db{$key};
    
    if ($value=~ s/^$OVERFLOWPREFIXREGULAR//o) {
       
       if (open(OVERFLOWGET, "<".$db[1].$OVERFLOWEXTENSION.$value)) {
          
          $value=<OVERFLOWGET>;
          close(OVERFLOWGET);
          
       }
       else {
          &fatalerror("in getvalues: cannot open for getting values $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!");
       }
   
    }
    
    return $value;
    
}


#
# addkey
#
# return 1 (for classless indexing) if the key didn't already existed, else 0

sub addkey {
    local(*db, $key, $offsets)=@_;

    local($value)=$db{$key};
    
#    print STDERR "key: $key offset: $offsets oldvalue: -$value-\n";
    
    local($length)=length($offsets)+length($key)+length($value)+4;
    
    return 1 if ((!$value) && ($length<$OVERFLOWSIZE) && ($db{$key}=$offsets));
    
    if ($value=~ s/^$OVERFLOWPREFIXREGULAR//o) {
       
       if (open(OVERFLOWADD, ">>".$db[1].$OVERFLOWEXTENSION.$value)) {
          
          &fatalerror("in addkey: cannot write $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!") if ( ! print OVERFLOWADD "\,", $offsets );
          close(OVERFLOWADD);
          
          return 0;
          
       }
       else {
          &fatalerror("in addkey: cannot open for addition $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!");
       }
   
    }
    
    return 0 if ($length<$OVERFLOWSIZE) && ($db{$key}=join("\,", $value, $offsets));
    
    # print STDERR $db{$OVERFLOWKEY}, "-", $value, "-", $offsets, "-",(length($value)+length($offsets)), "<$OVERFLOWSIZE\n";
    
    local($filenumber)=++$db{$OVERFLOWKEY};
    if (open(OVERFLOWADD, ">".$db[1].$OVERFLOWEXTENSION.$filenumber)) {
       
       if ($value) {
          
          &fatalerror("in addkey: cannot write $db[1]$OVERFLOWEXTENSION$filenumber key: $key value: $offsets code: $!") if ( ! print OVERFLOWADD $value, "\,", $offsets );
          close(OVERFLOWADD);

          $db{$key}=$OVERFLOWPREFIX.$filenumber;
       
          return 0;
          
          
       }
       else {
          &fatalerror("in addkey: cannot write $db[1]$OVERFLOWEXTENSION$filenumber key: $key value: $offsets code: $!") if ( ! print OVERFLOWADD $offsets );
          close(OVERFLOWADD);

          $db{$key}=$OVERFLOWPREFIX.$filenumber;
       
          return 1;
          
       }
       
    }
    else {
       &fatalerror("in addkey: cannot open new $db[1]$OVERFLOWEXTENSION$filenumber code: $!");
    }
    
    &fatalerror("in addkey: could not add $key with value $offsets");   
    
}

sub delkey {
    local(*db, $key, $offsets)=@_;

    local($value)=$db{$key};
    
    local(@values);
    local(%mark)=();

    grep($mark{$_}++, split(/\,/, $offsets));

    if ($value=~ s/^$OVERFLOWPREFIXREGULAR//o) {
       
       if (open(OVERFLOWDEL, "+<".$db[1].$OVERFLOWEXTENSION.$value)) {
          
          if ((@values=grep(!$mark{$_}, split(/\,/, <OVERFLOWDEL>)))) {
             
             seek(OVERFLOWDEL, 0, 0);
             &fatalerror("in addkey: cannot write $db[1]$OVERFLOWEXTENSION$value code: $!") if ( ! print OVERFLOWDEL join("\,", @values) );
             close(OVERFLOWDEL);
    
          }
          else {
             
             delete $db{$key};
             close(OVERFLOWDEL);
             unlink($db[1].$OVERFLOWEXTENSION.$value);
          
          }
          
          return;
          
       }
       else {
          &fatalerror("in delkey: cannot open for deletion $db[1]$OVERFLOWEXTENSION$value key: $key value: $offsets code: $!");
       }
   
    }   
       
    if ((@values=grep(!$mark{$_}, split(/\,/, $value)))) {
       $db{$key}=join("\,", @values);
    }
    else {
       delete($db{$key});
    }
       
    return;
       
}

1;
