#!/bin/sh

## Configurable variables

# Base directory
RIPDIR=/home/daniele/ripe/reimp/RIP

# Where is the remadmin command
REMADMIN=$RIPDIR/utils/remadmin/remadmin.pl.yucca

# Where is the hs_cleanup command
HSCLEANUP=$RIPDIR/utils/hs_cleanup/hs_cleanup
# Time arguments to the command
# -M 30: archive entries older than 30 minutes
# -D 1: archive entries older than 1 day
#TIMEARGS="-D 1"
TIMEARGS="-H 2"
#TIMEARGS="-T 977403043"
# Libraries for the hs_cleanup command
LD_LIBRARY_PATH=/opt/package/mysql/lib/mysql:/ncc/dbwork/platforms/yucca-debug/lib
export LD_LIBRARY_PATH

# Information about the whois_rip server
WHOISHOST=yucca.ripe.net
CONFIGPORT=43702

# Information about the SQL server where the data is kept
SQLHOST=orange.ripe.net
SQLPORT=3306
SQLUSER=dbint
SQLPSWD=reimp
SQLDB=daniele

# Logfile
LOGFILE=$RIPDIR/utils/hs_cleanup/log/hs_cleanup.log


## The commands

PAUSEUPDATES="$REMADMIN -h $WHOISHOST -p $CONFIGPORT set updates pause"
RESUMEUPDATES="$REMADMIN -h $WHOISHOST -p $CONFIGPORT set updates resume"
RUNHSCLEANUP="$HSCLEANUP  -h $SQLHOST -P$SQLPORT -u$SQLUSER -p$SQLPSWD \
	      -d$SQLDB $TIMEARGS >> $LOGFILE"

curdate=`date`
echo "Starting $0: $curdate" >> $LOGFILE 2>&1

echo "% $PAUSEUPDATES" >> $LOGFILE 2>&1
$PAUSEUPDATES >> $LOGFILE 2>&1
retcode=$?

if [ $retcode -eq 0 ]
then
  echo "% $RUNHSCLEANUP" >> $LOGFILE 2>&1
  $RUNHSCLEANUP >> $LOGFILE 2>&1
else
  echo "ERROR: Couldn't pause updates. Exiting." >> $LOGFILE 2>&1
  echo "ERROR: Couldn't pause updates. Exiting."
  exit $retcode
fi

echo "% $RESUMEUPDATES" >> $LOGFILE 2>&1
$RESUMEUPDATES >> $LOGFILE 2>&1
retcode=$?
if [ $retcode -ne 0 ]
then
  echo "ERROR: Couldn't resume updates!" >> $LOGFILE 2>&1
  echo "ERROR: Couldn't resume updates!"
fi

curdate=`date`
echo "Ending $0: $curdate\n\n" >> $LOGFILE 2>&1

exit $retcode
