/***************************************
  $Revision: 1.18 $

  gpg.h - header for gpg.c .

  Status: COMPLETE, REVUED, TESTED

  ******************/ /******************
  Filename            : gpg.h
  Authors             : filippo@ripe.net
  OSs Tested          : Solaris 7
  ******************/ /******************
  Copyright (c) 2000,2001,2002                    RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef GPG_H
#define GPG_H

#include <netdb.h>
#include <unistd.h>
#include "mail_parser.h"

/* FP: interface file for RIPE gnuPG */

#define INPUT_FD 0
#define OUTPUT_FD 1
#define ERROR_FD 2

#define LINE_LENGTH 1024
#define STRING_LENGTH 255
#define FILENAME_LENGTH 1024

#define ERRSTRING strerror (errno)

#define MAX_LINE_BUF 50000

/* FP : global objects used as and interface with gnuPG */

struct VerifySignObject {
  char iDocSigFilename[FILENAME_LENGTH],  /* IN  */
    iSigFilename[FILENAME_LENGTH],        /* IN  */
    outputPath[FILENAME_LENGTH],          /* IN  */
    oStream[FILENAME_LENGTH];             /* OUT */
  
  char keyRing[FILENAME_LENGTH];
  int isValid;
  u32 keyID;
  struct VerifySignObject *next;
  struct VerifySignObject *inner;
  int nMsg;
  int type;
  int isMIME;
};

struct ReadCryptedObject {
  char iFilename[FILENAME_LENGTH], 
       oStream[FILENAME_LENGTH];
  char keyRing[FILENAME_LENGTH];
  int isValid;
  u32 keyID;
};

struct ImportKeyObject {
  char iFilename[FILENAME_LENGTH];
  char keyRing[FILENAME_LENGTH];
  int rc;
  u32 keyID; 
  char fingerPrint[STRING_LENGTH];
  char keyOwner[STRING_LENGTH];
};

struct RemoveKeyObject {
  char iFilename[FILENAME_LENGTH];
  char keyRing[FILENAME_LENGTH];
  int rc;
  u32 keyID; 
};

enum {
   iKO_OK  = 0,
   iKO_UNCHANGED,
   iKO_NOUSERID,
   iKO_GENERAL,
   iKO_NOTVALIDUSERID,
   iKO_NOPUBLICKEY,
   iKO_NODEFAULTPUBLICKEYRING,
   iKO_CRC_ERROR,
   iKO_NO_OPENPGP_DATA,
   iKO_NO_IN_FILES,
   iKO_SECRET_KEY_PRESENT,
   iKO_MULTIPLE_KEYS,
   iKO_GENERALFAILURE
};

enum {
   vSO_IS_VALID  = 0,
   vSO_KO,
   vSO_CRC_ERROR,
   vSO_NO_PUBLIC_KEY,
   vSO_NO_OPENPGP_DATA,
   vSO_NO_IN_FILES,
   vSO_NO_OUT_FILES
};

enum {
  vSO_Type_PlainText = 0,
  vSO_Type_Unparsed,
  vSO_Type_ToBeGPGVerified,
  vSO_Type_Signed
};

#ifdef __cplusplus
extern "C" {
#endif

void PA_VerifySignature(struct VerifySignObject *vSO);
void PA_ImportKey(struct ImportKeyObject *iKO);
void PA_RemoveKey_withKeyID(struct ImportKeyObject *iKO);
void PA_RemoveKey(struct ImportKeyObject *iKO);
void PA_Decrypt(struct ReadCryptedObject *rDO);
EPNodePtr PA_ParseMessage(EPNodePtr ptr);
void GetFingerPrint(struct ImportKeyObject *iKO);
void GetKeyOwner(struct ImportKeyObject *iKO);

#ifdef __cplusplus
 }
#endif

#endif
